/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.helper;

import com.ibm.team.enterprise.systemdefinition.common.helper.ValidationHelper;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ItemNotFoundHelper {
    public static void handleDeletedLanguageDefinition(IItemHandle languageDefinition, int severity) {
        ValidationHelper.validateNotNull((String)"languageDefinition", (Object)languageDefinition);
        ItemNotFoundHelper.handleDeletedLanguageDefinition(languageDefinition, null, severity);
    }

    public static void handleDeletedLanguageDefinition(IItemHandle languageDefinition, String message, int severity) {
        ValidationHelper.validateNotNull((String)"languageDefinition", (Object)languageDefinition);
        Status status = new Status(severity, Activator.getUniqueIdentifier(), NLS.bind((String)Messages.ItemNotFoundHelper_SELECTED_LANGUAGE_DEFINITION_DELETED, (Object)languageDefinition.getItemType().getName()));
        ItemNotFoundHelper.displayErrorDialog(Messages.ItemNotFoundHelper_LANGUAGE_DEFINITION_DELETED_ERROR_DIALOG_TITLE, message, status);
        ItemNotFoundHelper.updateItemManager(languageDefinition);
    }

    public static void updateItemManager(IItemHandle languageDefinition) {
        ITeamRepository repository = (ITeamRepository)languageDefinition.getOrigin();
        if (repository != null) {
            repository.itemManager().applyItemDeletes(Collections.singletonList(languageDefinition));
        }
    }

    protected static void displayErrorDialog(String title, final String message, final Status status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell();
                try {
                    ErrorDialog.openError((Shell)shell, (String)Messages.ItemNotFoundHelper_LANGUAGE_DEFINITION_DELETED_ERROR_DIALOG_TITLE, (String)message, (IStatus)status);
                }
                finally {
                    shell.dispose();
                }
            }
        });
    }
}

