/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.helper;

import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConditionValidator {
    protected static Map<String, Info> allowed;

    static {
        ConditionValidator.initAllowed();
    }

    public static IStatus validate(String condition) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            Handler h = new Handler();
            parser.parse((InputStream)new ByteArrayInputStream(condition.getBytes()), (DefaultHandler)h);
            if (h.error != null && !h.error.equals("")) {
                return new Status(4, "unknown", h.error);
            }
            if (h.warning != null && !h.warning.equals("")) {
                return new Status(2, "unknown", h.warning);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            return new Status(4, "unknown", e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    protected static void initAllowed() {
        if (allowed != null) {
            return;
        }
        allowed = new HashMap<String, Info>();
        allowed.put("not", new Info(new String[0], new String[0], Info.Nested.MANY));
        allowed.put("and", new Info(new String[0], new String[0], Info.Nested.MANY));
        allowed.put("or", new Info(new String[0], new String[0], Info.Nested.MANY));
        allowed.put("xor", new Info(new String[0], new String[0], Info.Nested.MANY));
        allowed.put("available", new Info(new String[]{"property", "value", "classname", "file", "resource", "classpath", "filepath", "classpathref", "type", "ignoresystemclasses", "searchparents"}, new String[0], Info.Nested.IGNORE));
        allowed.put("uptodate", new Info(new String[]{"property", "value", "srcfile", "targetfile"}, new String[0], Info.Nested.IGNORE));
        allowed.put("os", new Info(new String[]{"family", "name", "arch", "version"}, new String[0], Info.Nested.NONE));
        allowed.put("equals", new Info(new String[]{"arg1", "arg2", "casesensitive", "trim", "forecasting"}, new String[]{"arg1", "arg2"}, Info.Nested.NONE));
        allowed.put("isset", new Info(new String[]{"property"}, new String[]{"property"}, Info.Nested.NONE));
        allowed.put("http", new Info(new String[]{"url", "errorsBeginAt", "requestMethod"}, new String[]{"url"}, Info.Nested.NONE));
        allowed.put("socket", new Info(new String[]{"server", "port"}, new String[]{"server", "port"}, Info.Nested.NONE));
        allowed.put("filesmatch", new Info(new String[]{"file1", "file2", "textfile"}, new String[]{"file1", "file2"}, Info.Nested.NONE));
        allowed.put("contains", new Info(new String[]{"string", "substring", "casesensitive"}, new String[]{"string", "substring"}, Info.Nested.NONE));
        allowed.put("istrue", new Info(new String[]{"value"}, new String[]{"value"}, Info.Nested.NONE));
        allowed.put("isfalse", new Info(new String[]{"value"}, new String[]{"value"}, Info.Nested.NONE));
        allowed.put("isreference", new Info(new String[]{"refid", "type"}, new String[]{"refid"}, Info.Nested.NONE));
        allowed.put("issigned", new Info(new String[]{"file", "name"}, new String[]{"file"}, Info.Nested.NONE));
        allowed.put("isfileselected", new Info(new String[]{"file", "basedir"}, new String[]{"file"}, Info.Nested.IGNORE));
        allowed.put("typefound", new Info(new String[]{"uri", "name"}, new String[]{"name"}, Info.Nested.NONE));
        allowed.put("scriptcondition", new Info(new String[]{"language", "manager", "value", "src", "setbeans", "classpath", "classpathref"}, new String[]{"language"}, Info.Nested.NONE));
        allowed.put("parsersupports", new Info(new String[]{"property", "feature", "value"}, new String[0], Info.Nested.NONE));
        allowed.put("isreachable", new Info(new String[]{"host", "url", "timeout"}, new String[0], Info.Nested.NONE));
        allowed.put("length", new Info(new String[]{"property", "file", "resource", "string", "mode", "trim", "length", "when"}, new String[0], Info.Nested.IGNORE));
        allowed.put("isfailure", new Info(new String[]{"code"}, new String[]{"code"}, Info.Nested.NONE));
        allowed.put("resourcecount", new Info(new String[]{"property", "refid", "count", "when"}, new String[0], Info.Nested.IGNORE));
        allowed.put("resourcesmatch", new Info(new String[]{"astext"}, new String[0], Info.Nested.IGNORE));
        allowed.put("resourcecontains", new Info(new String[]{"resource", "refid", "substring", "casesensitive"}, new String[]{"substring"}, Info.Nested.MANY));
        allowed.put("hasmethod", new Info(new String[]{"classname", "field", "method", "ignoreSystemClasses", "classpath", "classpathref"}, new String[]{"classname"}, Info.Nested.IGNORE));
        allowed.put("matches", new Info(new String[]{"string", "pattern", "casesensitive", "multiline", "singleline"}, new String[]{"string"}, Info.Nested.IGNORE));
        allowed.put("antversion", new Info(new String[]{"atleast", "exactly", "property"}, new String[0], Info.Nested.NONE));
        allowed.put("hasfreespace", new Info(new String[]{"partition", "needed"}, new String[]{"partition", "needed"}, Info.Nested.NONE));
        allowed.put("islastmodified", new Info(new String[]{"millis", "datetime", "pattern", "mode"}, new String[0], Info.Nested.IGNORE));
        allowed.put("resourceexists", new Info(new String[0], new String[0], Info.Nested.IGNORE));
        allowed.put("ac:ispropertytrue", new Info(new String[]{"property"}, new String[]{"property"}, Info.Nested.NONE));
        allowed.put("ac:ispropertyfalse", new Info(new String[]{"property"}, new String[]{"property"}, Info.Nested.NONE));
        allowed.put("ac:startswith", new Info(new String[]{"string", "with"}, new String[]{"string", "with"}, Info.Nested.NONE));
        allowed.put("ac:endswith", new Info(new String[]{"string", "with"}, new String[]{"string", "with"}, Info.Nested.NONE));
        allowed.put("ac:isgreaterthan", new Info(new String[]{"arg1", "arg2"}, new String[]{"arg1", "arg2"}, Info.Nested.NONE));
        allowed.put("ac:islessthan", new Info(new String[]{"arg1", "arg2"}, new String[]{"arg1", "arg2"}, Info.Nested.NONE));
    }

    private static class Handler
    extends DefaultHandler {
        public String warning = null;
        public String error = null;
        protected Stack<String> nameStack = new Stack();
        protected int ignoreCount = 0;

        private Handler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                String prefix;
                if (this.ignoreCount > 0) {
                    ++this.ignoreCount;
                    return;
                }
                if (!this.nameStack.isEmpty() && allowed.containsKey(this.nameStack.peek())) {
                    Info.Nested n = ConditionValidator.allowed.get((Object)this.nameStack.peek()).nested;
                    if (n == Info.Nested.IGNORE) {
                        ++this.ignoreCount;
                        return;
                    }
                    if (n == Info.Nested.NONE) {
                        this.error = NLS.bind((String)Messages.ConditionValidator_ILLEGAL_NESTED_ELEMENT, (Object)this.nameStack.peek());
                        return;
                    }
                }
                if (!(qName.indexOf(58) < 1 || "ac".equals(prefix = qName.substring(0, qName.indexOf(58))) || "antz".equals(prefix) || "antp".equals(prefix))) {
                    this.warning = NLS.bind((String)Messages.ConditionValidator_UNRECOGNIZED_PREFIX, (Object)prefix, (Object)qName);
                    ++this.ignoreCount;
                    return;
                }
                if (!allowed.containsKey(qName)) {
                    this.error = NLS.bind((String)Messages.ConditionValidator_ILLEGAL_ELEMENT, (Object)qName);
                    return;
                }
                Info info = allowed.get(qName);
                int i = 0;
                while (i < attributes.getLength()) {
                    if (!info.attributes.contains(attributes.getQName(i))) {
                        this.error = NLS.bind((String)Messages.ConditionValidator_ILLEGAL_ATTRIBUTE, (Object)qName, (Object)attributes.getQName(i));
                    }
                    ++i;
                }
                i = 0;
                while (i < info.required.size()) {
                    if (attributes.getIndex(info.required.get(i)) < 0) {
                        this.error = NLS.bind((String)Messages.ConditionValidator_MISSING_REQUIRED_ATTRIBUTE, (Object)qName, (Object)info.required.get(i));
                    }
                    ++i;
                }
            }
            finally {
                this.nameStack.push(qName);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.nameStack.pop();
            if (this.ignoreCount > 0) {
                --this.ignoreCount;
            }
        }
    }

    protected static class Info {
        public List<String> attributes;
        public List<String> required;
        public Nested nested;

        public Info(String[] attributes, String[] required, Nested nested) {
            this.attributes = Arrays.asList(attributes);
            this.required = Arrays.asList(required);
            this.nested = nested;
        }

        public static enum Nested {
            NONE,
            ONE,
            MANY,
            IGNORE;

        }
    }
}

