/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.elements;

import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheItem;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICachePlatform;
import com.ibm.team.enterprise.systemdefinition.client.cache.ICacheType;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.FilteredSystemDefinitionTree;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionErrorNode;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class SystemDefinitionHandleDeferredContentProvider
implements ITreeContentProvider,
IDeferredWorkbenchAdapter {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    protected boolean doFullResolution;
    protected IItemType type;
    protected ISystemDefinitionCache cache;
    protected ITeamRepository repository;
    protected ISystemDefinition.Platform platform;
    protected DeferredTreeContentManager deferredTreeManager;
    protected TreeViewer treeViewer;
    protected List<Integer> usages;
    protected Map<Object, Object[]> fetched;

    public SystemDefinitionHandleDeferredContentProvider(ITeamRepository repository, ISystemDefinition.Platform platform, IItemType type) {
        this(repository, platform, type, null, false, null);
    }

    public SystemDefinitionHandleDeferredContentProvider(ITeamRepository repository, ISystemDefinition.Platform platform, IItemType type, boolean doFullResolution) {
        this(repository, platform, type, null, doFullResolution, null);
    }

    public SystemDefinitionHandleDeferredContentProvider(ITeamRepository repository, ISystemDefinition.Platform platform, IItemType type, List<Integer> usages) {
        this(repository, platform, type, usages, false, null);
    }

    public SystemDefinitionHandleDeferredContentProvider(ITeamRepository repository, ISystemDefinition.Platform platform, IItemType type, List<Integer> usages, boolean doFullResolution) {
        this(repository, platform, type, usages, doFullResolution, null);
    }

    public SystemDefinitionHandleDeferredContentProvider(ITeamRepository repository, ISystemDefinition.Platform platform, IItemType type, List<Integer> usages, boolean doFullResolution, ISystemDefinitionCache cache) {
        this.repository = repository;
        this.platform = platform;
        this.type = type;
        this.usages = usages;
        this.doFullResolution = doFullResolution;
        this.cache = cache;
        this.fetched = new HashMap<Object, Object[]>();
    }

    public final void dispose() {
        this.deferredTreeManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        Object object2 = object;
        synchronized (object2) {
            block12: {
                if (this.fetched.containsKey(object)) {
                    return;
                }
                try {
                    try {
                        if (object instanceof ITeamRepository) {
                            this.fetchRepositoryChildren((ITeamRepository)object, collector, monitor);
                        } else if (object instanceof IProjectAreaHandle) {
                            this.fetchProjectAreaChildren((IProjectAreaHandle)object, collector, monitor);
                        }
                    }
                    catch (Exception e) {
                        Activator.log(e);
                        StringWriter writer = new StringWriter();
                        e.printStackTrace(new PrintWriter(writer));
                        Object[] error = new Object[]{new SystemDefinitionErrorNode(writer.toString())};
                        collector.add(error, monitor);
                        this.fetched.put(object, error);
                        monitor.done();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        }
    }

    private void fetchProjectAreaChildren(IProjectAreaHandle projectArea, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList handles;
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
        if (this.platform == null) {
            if (this.usages == null) {
                handles = client.findSystemDefinitionHandles(this.type, projectArea, -1, false, null);
            } else {
                ArrayList gathered = new ArrayList();
                for (Integer usage : this.usages) {
                    gathered.addAll(client.findSystemDefinitionHandles(this.type, projectArea, usage.intValue(), false, null));
                }
                handles = new ArrayList(gathered);
            }
        } else {
            switch (ICacheType.CacheType.get((ISystemDefinition.Platform)this.platform, (IItemType)this.type)) {
                case DATASET: {
                    ICacheItem cacheItem = ItemCacheFactory.getDatasetHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea);
                    ICachePlatform cachePlatform = (ICachePlatform)cacheItem;
                    handles = new ArrayList();
                    if (this.usages != null) {
                        for (Integer usage : this.usages) {
                            if (cacheItem != null && cachePlatform.getPlatformEntry(this.platform, usage) != null) {
                                handles.addAll(cachePlatform.getPlatformEntry(this.platform, usage));
                                continue;
                            }
                            handles.addAll(ItemCacheFactory.addDatasetHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea, (ISystemDefinition.Platform)this.platform, (Integer)usage, (IDebugger)new Debugger(this.getClass())));
                        }
                        break;
                    }
                    if (cacheItem != null && cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)) != null) {
                        handles.addAll(cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)));
                        break;
                    }
                    handles.addAll(ItemCacheFactory.addDatasetHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea, (ISystemDefinition.Platform)this.platform, (Integer)-1, (IDebugger)new Debugger(this.getClass())));
                    break;
                }
                case FUNCTION: {
                    ICacheItem cacheItem = ItemCacheFactory.getFunctionHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea);
                    ICachePlatform cachePlatform = (ICachePlatform)cacheItem;
                    handles = new ArrayList();
                    if (cacheItem != null && cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)) != null) {
                        handles.addAll(cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)));
                        break;
                    }
                    handles.addAll(ItemCacheFactory.addFunctionHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea, (ISystemDefinition.Platform)this.platform, (IDebugger)new Debugger(this.getClass())));
                    break;
                }
                case LANGUAGE: {
                    ICacheItem cacheItem = ItemCacheFactory.getLanguageHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea);
                    ICachePlatform cachePlatform = (ICachePlatform)cacheItem;
                    handles = new ArrayList();
                    if (cacheItem != null && cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)) != null) {
                        handles.addAll(cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)));
                        break;
                    }
                    handles.addAll(ItemCacheFactory.addLanguageHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea, (ISystemDefinition.Platform)this.platform, (IDebugger)new Debugger(this.getClass())));
                    break;
                }
                case LIBRARY: {
                    ICacheItem cacheItem = ItemCacheFactory.getLibraryHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea);
                    ICachePlatform cachePlatform = (ICachePlatform)cacheItem;
                    handles = new ArrayList();
                    if (this.usages != null) {
                        for (Integer usage : this.usages) {
                            if (cacheItem != null && cachePlatform.getPlatformEntry(this.platform, usage) != null) {
                                handles.addAll(cachePlatform.getPlatformEntry(this.platform, usage));
                                continue;
                            }
                            handles.addAll(ItemCacheFactory.addLibraryHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea, (ISystemDefinition.Platform)this.platform, (Integer)usage, (IDebugger)new Debugger(this.getClass())));
                        }
                        break;
                    }
                    if (cacheItem != null && cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)) != null) {
                        handles.addAll(cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)));
                        break;
                    }
                    handles.addAll(ItemCacheFactory.addLibraryHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea, (ISystemDefinition.Platform)this.platform, (Integer)-1, (IDebugger)new Debugger(this.getClass())));
                    break;
                }
                case SEARCHPATH: {
                    ICacheItem cacheItem = ItemCacheFactory.getSearchPathHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea);
                    ICachePlatform cachePlatform = (ICachePlatform)cacheItem;
                    handles = new ArrayList();
                    if (cacheItem != null && cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)) != null) {
                        handles.addAll(cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)));
                        break;
                    }
                    handles.addAll(ItemCacheFactory.addSearchPathHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea, (ISystemDefinition.Platform)this.platform, (IDebugger)new Debugger(this.getClass())));
                    break;
                }
                case TRANSLATOR: {
                    ICacheItem cacheItem = ItemCacheFactory.getTranslatorHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea);
                    ICachePlatform cachePlatform = (ICachePlatform)cacheItem;
                    handles = new ArrayList();
                    if (cacheItem != null && cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)) != null) {
                        handles.addAll(cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)));
                        break;
                    }
                    handles.addAll(ItemCacheFactory.addTranslatorHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea, (ISystemDefinition.Platform)this.platform, (IDebugger)new Debugger(this.getClass())));
                    break;
                }
                case VERSION: {
                    ICacheItem cacheItem = ItemCacheFactory.getVersionHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea);
                    ICachePlatform cachePlatform = (ICachePlatform)cacheItem;
                    handles = new ArrayList();
                    if (cacheItem != null && cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)) != null) {
                        handles.addAll(cachePlatform.getPlatformEntry(this.platform, Integer.valueOf(-1)));
                        break;
                    }
                    handles.addAll(ItemCacheFactory.addVersionHandle((ITeamRepository)this.repository, (IProjectAreaHandle)projectArea, (ISystemDefinition.Platform)this.platform, (IDebugger)new Debugger(this.getClass())));
                    break;
                }
                default: {
                    handles = client.findSystemDefinitionHandles(this.type, projectArea, -1, false, null);
                }
            }
        }
        if (this.doFullResolution) {
            ArrayList<ISystemDefinition> fullyResolvedDefinitions = new ArrayList<ISystemDefinition>(handles.size());
            for (ISystemDefinitionHandle handle : handles) {
                ISystemDefinition systemDefinition = this.resolveHandle(handle, client);
                if (systemDefinition.isArchived()) continue;
                fullyResolvedDefinitions.add(systemDefinition);
            }
            Collections.sort(fullyResolvedDefinitions, new Comparator<ISystemDefinition>(){

                @Override
                public int compare(ISystemDefinition o1, ISystemDefinition o2) {
                    String label1 = o1.getName();
                    String label2 = o2.getName();
                    return label1.compareTo(label2);
                }
            });
            Object[] added = fullyResolvedDefinitions.toArray();
            collector.add(added, monitor);
            this.fetched.put(projectArea, added);
        } else {
            Collections.sort(handles, new Comparator<ISystemDefinitionHandle>(){

                @Override
                public int compare(ISystemDefinitionHandle o1, ISystemDefinitionHandle o2) {
                    String label1 = ((ISystemDefinition)o1).getName();
                    String label2 = ((ISystemDefinition)o2).getName();
                    return label1.compareTo(label2);
                }
            });
            Object[] added = handles.toArray();
            collector.add(added, monitor);
            this.fetched.put(projectArea, added);
        }
    }

    private void fetchRepositoryChildren(ITeamRepository repository, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
        List rawProjectAreas = repository.itemManager().fetchCompleteItems(repository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, null);
        ArrayList<IProjectArea> projectAreas = new ArrayList<IProjectArea>(rawProjectAreas.size());
        for (IProjectArea projectArea : rawProjectAreas) {
            if (projectArea == null || projectArea.isArchived() || !client.hasSystemDefinitions((IProjectAreaHandle)projectArea, this.type, -1, false, null)) continue;
            projectAreas.add(projectArea);
        }
        Collections.sort(projectAreas, new Comparator<IProjectArea>(){

            @Override
            public int compare(IProjectArea o1, IProjectArea o2) {
                String label1 = o1.getName();
                String label2 = o2.getName();
                return label1.compareTo(label2);
            }
        });
        Object[] added = projectAreas.toArray();
        collector.add(added, monitor);
        this.fetched.put(repository, added);
    }

    public final Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ITeamRepository || parentElement instanceof IProjectAreaHandle) {
            if (this.fetched.containsKey(parentElement)) {
                return this.fetched.get(parentElement);
            }
            if (this.getContentManager() != null) {
                return this.getContentManager().getChildren(parentElement);
            }
            return new Object[]{""};
        }
        return EMPTY_ARRAY;
    }

    private DeferredTreeContentManager getContentManager() {
        if (this.deferredTreeManager == null && this.treeViewer != null) {
            this.deferredTreeManager = new DeferredTreeContentManager((AbstractTreeViewer)this.treeViewer){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (SystemDefinitionHandleDeferredContentProvider.this.hasChildren(element)) {
                        return SystemDefinitionHandleDeferredContentProvider.this;
                    }
                    return super.getAdapter(element);
                }
            };
            this.deferredTreeManager.addUpdateCompleteListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK() && !SystemDefinitionHandleDeferredContentProvider.this.treeViewer.getTree().isDisposed()) {
                        Composite filteredTree = SystemDefinitionHandleDeferredContentProvider.this.treeViewer.getTree().getParent().getParent();
                        if (filteredTree instanceof FilteredSystemDefinitionTree) {
                            ((FilteredSystemDefinitionTree)filteredTree).refresh();
                        } else {
                            SystemDefinitionHandleDeferredContentProvider.this.treeViewer.refresh();
                        }
                    }
                }
            });
        }
        return this.deferredTreeManager;
    }

    public final Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public final ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public final String getLabel(Object o) {
        if (o instanceof ITeamRepository) {
            return ((ITeamRepository)o).getName();
        }
        if (o instanceof IProjectArea) {
            return ((IProjectArea)o).getName();
        }
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public final Object getParent(Object element) {
        return null;
    }

    public final ISchedulingRule getRule(Object object) {
        return null;
    }

    public final boolean hasChildren(Object element) {
        return element instanceof ITeamRepository || element instanceof IProjectAreaHandle;
    }

    public final void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.treeViewer = (TreeViewer)viewer;
        }
    }

    public final boolean isContainer() {
        return true;
    }

    public final void refresh() {
        this.fetched.clear();
    }

    private ISystemDefinition resolveHandle(ISystemDefinitionHandle handle, ISystemDefinitionModelClient client) throws TeamRepositoryException {
        if (this.cache != null) {
            return this.cache.getSystemDefinition(handle, null);
        }
        return client.fetchSystemDefinitionComplete(handle, this.doFullResolution, (IProgressMonitor)new NullProgressMonitor());
    }
}

