/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.elements;

import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingFactory;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepAsm;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepIrx;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepLnk;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepSld;
import com.ibm.team.enterprise.systemdefinition.ui.ILanguageWizardPage;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewPackagingLanguageWizardPage01Asm;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewPackagingLanguageWizardPage01Irx;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewPackagingLanguageWizardPage01Lnk;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewPackagingLanguageWizardPage01Sld;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.Constructor;

public class PackagingPageFactory {
    private PackagingPageFactory() {
    }

    public static ILanguageWizardPage createPackagingPage(String languageId, IImporterParserStep step) throws Exception {
        ILanguageWizardPage result = null;
        switch (step.getPgmName()) {
            case "ASMA90": {
                IImporterStepAsm defaults = PackagingFactory.createStepAsm();
                defaults.init(step);
                result = PackagingPageFactory.createPackagingLanguageStepPage(NewPackagingLanguageWizardPage01Asm.class, Messages.NewPackagingLanguageWizardPage01Asm_Title, Messages.NewPackagingLanguageWizardPage01Asm_Description, languageId, (IImporterStep)defaults, step);
                break;
            }
            case "IRXJCL": {
                IImporterStepIrx defaults = PackagingFactory.createStepIrx();
                defaults.init(step);
                result = PackagingPageFactory.createPackagingLanguageStepPage(NewPackagingLanguageWizardPage01Irx.class, Messages.NewPackagingLanguageWizardPage01Irx_Title, Messages.NewPackagingLanguageWizardPage01Irx_Description, languageId, (IImporterStep)defaults, step);
                break;
            }
            case "IEWBLINK": {
                IImporterStepLnk defaults = PackagingFactory.createStepLnk();
                defaults.init(step);
                result = PackagingPageFactory.createPackagingLanguageStepPage(NewPackagingLanguageWizardPage01Lnk.class, Messages.NewPackagingLanguageWizardPage01Lnk_Title, Messages.NewPackagingLanguageWizardPage01Lnk_Description, languageId, (IImporterStep)defaults, step);
                break;
            }
            case "XSLDMOD": {
                IImporterStepSld defaults = PackagingFactory.createStepSld();
                defaults.init(step);
                result = PackagingPageFactory.createPackagingLanguageStepPage(NewPackagingLanguageWizardPage01Sld.class, Messages.NewPackagingLanguageWizardPage01Sld_Title, Messages.NewPackagingLanguageWizardPage01Sld_Description, languageId, (IImporterStep)defaults, step);
            }
        }
        return result;
    }

    private static ILanguageWizardPage createPackagingLanguageStepPage(Class clazz, String titleMsg, String titleDsc, String languageId, IImporterStep defaults, IImporterParserStep step) throws Exception {
        String title = NLS.bind((String)titleMsg, (Object)languageId, (Object[])new Object[]{step.getName(), step.getPgmName()});
        Constructor constructor = clazz.getConstructor(String.class);
        ILanguageWizardPage result = (ILanguageWizardPage)constructor.newInstance(title);
        result.setTitle(title);
        result.setDescription(titleDsc);
        result.setDefaults(defaults);
        return result;
    }

    public static ILanguageWizardPage createPackagingLanguagePageAsm(String languageId, boolean defaultsBuiltin) {
        IImporterStepAsm defaults = PackagingFactory.createStepAsm((boolean)defaultsBuiltin);
        String title = NLS.bind((String)Messages.NewPackagingLanguageWizardPage01Asm_Title, (Object)languageId, (Object[])new Object[]{"Assemble", "ASMA90"});
        NewPackagingLanguageWizardPage01Asm result = new NewPackagingLanguageWizardPage01Asm(title);
        result.setTitle(title);
        result.setDescription(Messages.NewPackagingLanguageWizardPage01Asm_Description);
        result.setDefaults((IImporterStep)defaults);
        return result;
    }

    public static ILanguageWizardPage createPackagingLanguagePageIrx(String languageId, boolean defaultsBuiltin) {
        IImporterStepIrx defaults = PackagingFactory.createStepIrx((boolean)defaultsBuiltin);
        String title = NLS.bind((String)Messages.NewPackagingLanguageWizardPage01Irx_Title, (Object)languageId, (Object[])new Object[]{"RexxExec", "IRXJCL"});
        NewPackagingLanguageWizardPage01Irx result = new NewPackagingLanguageWizardPage01Irx(title);
        result.setTitle(title);
        result.setDescription(Messages.NewPackagingLanguageWizardPage01Irx_Description);
        result.setDefaults((IImporterStep)defaults);
        return result;
    }

    public static ILanguageWizardPage createPackagingLanguagePageLnk(String languageId, boolean defaultsBuiltin) {
        IImporterStepLnk defaults = PackagingFactory.createStepLnk((boolean)defaultsBuiltin);
        String title = NLS.bind((String)Messages.NewPackagingLanguageWizardPage01Lnk_Title, (Object)languageId, (Object[])new Object[]{"Linkedit", "IEWBLINK"});
        NewPackagingLanguageWizardPage01Lnk result = new NewPackagingLanguageWizardPage01Lnk(title);
        result.setTitle(title);
        result.setDescription(Messages.NewPackagingLanguageWizardPage01Lnk_Description);
        result.setDefaults((IImporterStep)defaults);
        return result;
    }

    public static ILanguageWizardPage createPackagingLanguagePageSld(String languageId, boolean defaultsBuiltin) {
        IImporterStepSld defaults = PackagingFactory.createStepSld((boolean)defaultsBuiltin);
        String title = NLS.bind((String)Messages.NewPackagingLanguageWizardPage01Sld_Title, (Object)languageId, (Object[])new Object[]{"SldLogic", "XSLDMOD"});
        NewPackagingLanguageWizardPage01Sld result = new NewPackagingLanguageWizardPage01Sld(title);
        result.setTitle(title);
        result.setDescription(Messages.NewPackagingLanguageWizardPage01Sld_Description);
        result.setDefaults((IImporterStep)defaults);
        return result;
    }
}

