/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.elements;

import com.ibm.team.enterprise.systemdefinition.client.builder.BuilderFactory;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStep;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepAsm;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepCob;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepDef;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepIrx;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepLnk;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterStepSld;
import com.ibm.team.enterprise.systemdefinition.common.util.DatasetCache;
import com.ibm.team.enterprise.systemdefinition.ui.ILanguageWizardPage;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewBuilderLanguageWizardPage01Asm;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewBuilderLanguageWizardPage01Cob;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewBuilderLanguageWizardPage01Def;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewBuilderLanguageWizardPage01Irx;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewBuilderLanguageWizardPage01Lnk;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewBuilderLanguageWizardPage01Sld;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;

public class BuilderPageFactory {
    private BuilderPageFactory() {
    }

    public static ILanguageWizardPage createPage(String languageId, IImporterParserStep step, DatasetCache datasetCache) throws Exception {
        ILanguageWizardPage result = null;
        step.setPgmName(BuilderPageFactory.getPotentiallyAliasedPgmName(step.getPgmName()));
        switch (step.getPgmName()) {
            case "ASMA90": {
                IImporterStepAsm defaults = BuilderFactory.createStepAsm();
                defaults.init(step);
                result = BuilderPageFactory.createStepPage(NewBuilderLanguageWizardPage01Asm.class, Messages.NewBuilderLanguageWizardPage01Asm_Title, Messages.NewBuilderLanguageWizardPage01Asm_Description, languageId, (IImporterStep)defaults, step, datasetCache);
                break;
            }
            case "IGYCRCTL": {
                IImporterStepCob defaults = BuilderFactory.createStepCob();
                defaults.init(step);
                result = BuilderPageFactory.createStepPage(NewBuilderLanguageWizardPage01Cob.class, Messages.NewBuilderLanguageWizardPage01Cob_Title, Messages.NewBuilderLanguageWizardPage01Cob_Description, languageId, (IImporterStep)defaults, step, datasetCache);
                break;
            }
            case "IRXJCL": {
                IImporterStepIrx defaults = BuilderFactory.createStepIrx();
                defaults.init(step);
                result = BuilderPageFactory.createStepPage(NewBuilderLanguageWizardPage01Irx.class, Messages.NewBuilderLanguageWizardPage01Irx_Title, Messages.NewBuilderLanguageWizardPage01Irx_Description, languageId, (IImporterStep)defaults, step, datasetCache);
                break;
            }
            case "IEWBLINK": {
                IImporterStepLnk defaults = BuilderFactory.createStepLnk();
                defaults.init(step);
                result = BuilderPageFactory.createStepPage(NewBuilderLanguageWizardPage01Lnk.class, Messages.NewBuilderLanguageWizardPage01Lnk_Title, Messages.NewBuilderLanguageWizardPage01Lnk_Description, languageId, (IImporterStep)defaults, step, datasetCache);
                break;
            }
            case "XSLDMOD": {
                IImporterStepSld defaults = BuilderFactory.createStepSld();
                defaults.init(step);
                result = BuilderPageFactory.createStepPage(NewBuilderLanguageWizardPage01Sld.class, Messages.NewBuilderLanguageWizardPage01Sld_Title, Messages.NewBuilderLanguageWizardPage01Sld_Description, languageId, (IImporterStep)defaults, step, datasetCache);
                break;
            }
            default: {
                IImporterStepDef defaults = BuilderFactory.createStepDefault();
                defaults.init(step);
                result = BuilderPageFactory.createStepPage(NewBuilderLanguageWizardPage01Def.class, Messages.NewBuilderLanguageWizardPage01Def_Title, Messages.NewBuilderLanguageWizardPage01Def_Description, languageId, (IImporterStep)defaults, step, datasetCache);
            }
        }
        return result;
    }

    private static String getPotentiallyAliasedPgmName(String pgmName) {
        List<String> stepPgmAliases = Arrays.asList("IEWL", "LINKEDIT", "EWL", "HEWLH096");
        if (stepPgmAliases.contains(pgmName)) {
            return "IEWBLINK";
        }
        return pgmName;
    }

    private static ILanguageWizardPage createStepPage(Class clazz, String titleMsg, String titleDsc, String languageId, IImporterStep defaults, IImporterParserStep step, DatasetCache datasetCache) throws Exception {
        String title = NLS.bind((String)titleMsg, (Object)languageId, (Object[])new Object[]{step.getName(), step.getPgmName()});
        Constructor constructor = clazz.getConstructor(String.class);
        ILanguageWizardPage result = (ILanguageWizardPage)constructor.newInstance(title);
        result.setTitle(title);
        result.setDescription(titleDsc);
        result.setDefaults(defaults);
        result.setCache(datasetCache);
        result.getDefaults().setMaxRc(step.getMaxRc());
        return result;
    }

    public static ILanguageWizardPage createLanguagePageAsm(String languageId, boolean defaultsBuiltin, DatasetCache datasetCache) {
        IImporterStepAsm defaults = BuilderFactory.createStepAsm((boolean)defaultsBuiltin);
        String title = NLS.bind((String)Messages.NewBuilderLanguageWizardPage01Asm_Title, (Object)languageId, (Object[])new Object[]{"Assemble", "ASMA90"});
        NewBuilderLanguageWizardPage01Asm result = new NewBuilderLanguageWizardPage01Asm(title);
        result.setTitle(title);
        result.setDescription(Messages.NewBuilderLanguageWizardPage01Asm_Description);
        result.setDefaults((IImporterStep)defaults);
        result.setCache(datasetCache);
        result.setUsedBuiltinDefaults(defaultsBuiltin);
        return result;
    }

    public static ILanguageWizardPage createLanguagePageIrx(String languageId, boolean defaultsBuiltin, DatasetCache datasetCache) {
        IImporterStepIrx defaults = BuilderFactory.createStepIrx((boolean)defaultsBuiltin);
        String title = NLS.bind((String)Messages.NewBuilderLanguageWizardPage01Irx_Title, (Object)languageId, (Object[])new Object[]{"RexxExec", "IRXJCL"});
        NewBuilderLanguageWizardPage01Irx result = new NewBuilderLanguageWizardPage01Irx(title);
        result.setTitle(title);
        result.setDescription(Messages.NewBuilderLanguageWizardPage01Irx_Description);
        result.setDefaults((IImporterStep)defaults);
        result.setCache(datasetCache);
        result.setUsedBuiltinDefaults(defaultsBuiltin);
        return result;
    }

    public static ILanguageWizardPage createLanguagePageLnk(String languageId, boolean defaultsBuiltin, DatasetCache datasetCache) {
        IImporterStepLnk defaults = BuilderFactory.createStepLnk((boolean)defaultsBuiltin);
        String title = NLS.bind((String)Messages.NewBuilderLanguageWizardPage01Lnk_Title, (Object)languageId, (Object[])new Object[]{"Linkedit", "IEWBLINK"});
        NewBuilderLanguageWizardPage01Lnk result = new NewBuilderLanguageWizardPage01Lnk(title);
        result.setTitle(title);
        result.setDescription(Messages.NewBuilderLanguageWizardPage01Lnk_Description);
        result.setDefaults((IImporterStep)defaults);
        result.setCache(datasetCache);
        result.setUsedBuiltinDefaults(defaultsBuiltin);
        return result;
    }

    public static ILanguageWizardPage createLanguagePageCob(String languageId, boolean defaultsBuiltin, DatasetCache datasetCache) {
        IImporterStepCob defaults = BuilderFactory.createStepCob((boolean)defaultsBuiltin);
        String title = NLS.bind((String)Messages.NewBuilderLanguageWizardPage01Cob_Title, (Object)languageId, (Object[])new Object[]{"COBOL", "IGYCRCTL"});
        NewBuilderLanguageWizardPage01Cob result = new NewBuilderLanguageWizardPage01Cob(title);
        result.setTitle(title);
        result.setDescription(Messages.NewBuilderLanguageWizardPage01Cob_Description);
        result.setDefaults((IImporterStep)defaults);
        result.setCache(datasetCache);
        result.setUsedBuiltinDefaults(defaultsBuiltin);
        return result;
    }

    public static ILanguageWizardPage createLanguagePageDefault(String languageId, boolean defaultsBuiltin, DatasetCache datasetCache) {
        IImporterStepDef defaults = BuilderFactory.createStepDefault((boolean)defaultsBuiltin);
        String title = NLS.bind((String)Messages.NewBuilderLanguageWizardPage01Def_Title, (Object)languageId, (Object[])new Object[]{"Default", ""});
        NewBuilderLanguageWizardPage01Def result = new NewBuilderLanguageWizardPage01Def(title);
        result.setTitle(title);
        result.setDescription(Messages.NewBuilderLanguageWizardPage01Def_Description);
        result.setDefaults((IImporterStep)defaults);
        result.setCache(datasetCache);
        result.setUsedBuiltinDefaults(defaultsBuiltin);
        return result;
    }

    public static ILanguageWizardPage createLanguagePageSld(String languageId, boolean defaultsBuiltin, DatasetCache datasetCache) {
        IImporterStepSld defaults = BuilderFactory.createStepSld((boolean)defaultsBuiltin);
        String title = NLS.bind((String)Messages.NewBuilderLanguageWizardPage01Sld_Title, (Object)languageId, (Object[])new Object[]{"SldLogic", "XSLDMOD"});
        NewBuilderLanguageWizardPage01Sld result = new NewBuilderLanguageWizardPage01Sld(title);
        result.setTitle(title);
        result.setDescription(Messages.NewBuilderLanguageWizardPage01Sld_Description);
        result.setDefaults((IImporterStep)defaults);
        result.setCache(datasetCache);
        result.setUsedBuiltinDefaults(defaultsBuiltin);
        return result;
    }
}

