/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.elements;

import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.IImporterBuildOptionsTreeNode;
import com.ibm.team.enterprise.systemdefinition.ui.elements.BuilderBuildOptionsTreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class BuilderBuildOptionsListener
implements Listener {
    private final Image enabledNoneImage = Activator.getImage("icons/obj16/enabled_none_obj.gif");
    private final Image enabledSomeImage = Activator.getImage("icons/obj16/enabled_some_obj.gif");
    private final Image disabledNoneImage = Activator.getImage("icons/obj16/disabled_none_obj.gif");
    private final Image disabledSomeImage = Activator.getImage("icons/obj16/disabled_some_obj.gif");
    private final Image disabledTickImage = Activator.getImage("icons/obj16/disabled_tick_obj.gif");

    public void handleEvent(Event event) {
        if (!(event.widget instanceof Tree) || event.button != 1) {
            return;
        }
        Tree tree = (Tree)event.widget;
        Point p = new Point(event.x, event.y);
        TreeItem item = tree.getItem(p);
        if (item != null) {
            int i = 1;
            while (i < tree.getColumnCount()) {
                Rectangle r = item.getBounds(i);
                if (r.contains(p)) {
                    Object data = item.getData();
                    if (data instanceof IImporterBuildOptions) {
                        IImporterBuildOptions child = (IImporterBuildOptions)data;
                        switch (i) {
                            case 1: {
                                if (!child.isCompileEnabled()) break;
                                child.setCompile(!child.isCompile());
                                break;
                            }
                            case 2: {
                                if (!child.isInitialEnabled()) break;
                                child.setInitial(!child.isInitial());
                                break;
                            }
                            case 3: {
                                if (!child.isLibraryEnabled()) break;
                                child.setLibrary(!child.isLibrary());
                                break;
                            }
                            case 4: {
                                if (!child.isRefreshEnabled()) break;
                                child.setRefresh(!child.isRefresh());
                                break;
                            }
                            case 5: {
                                if (!child.isServiceEnabled()) break;
                                child.setService(!child.isService());
                                break;
                            }
                            case 6: {
                                if (!child.isTestingEnabled()) break;
                                child.setTesting(!child.isTesting());
                            }
                        }
                        tree.redraw();
                        break;
                    }
                    if (data instanceof BuilderBuildOptionsTreeNode) {
                        IImporterBuildOptionsTreeNode node = (IImporterBuildOptionsTreeNode)data;
                        Image image = node.getImageMap().get(i);
                        if (image == this.disabledNoneImage || image == this.disabledSomeImage || image == this.disabledTickImage) break;
                        boolean newState = image == this.enabledNoneImage || image == this.enabledSomeImage ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
                        for (IImporterBuildOptions child : node.getChildren()) {
                            switch (i) {
                                case 1: {
                                    if (!child.isCompileEnabled()) break;
                                    child.setCompile(newState);
                                    break;
                                }
                                case 2: {
                                    if (!child.isInitialEnabled()) break;
                                    child.setInitial(newState);
                                    break;
                                }
                                case 3: {
                                    if (!child.isLibraryEnabled()) break;
                                    child.setLibrary(newState);
                                    break;
                                }
                                case 4: {
                                    if (!child.isRefreshEnabled()) break;
                                    child.setRefresh(newState);
                                    break;
                                }
                                case 5: {
                                    if (!child.isServiceEnabled()) break;
                                    child.setService(newState);
                                    break;
                                }
                                case 6: {
                                    if (!child.isTestingEnabled()) break;
                                    child.setTesting(newState);
                                }
                            }
                        }
                        tree.redraw();
                        break;
                    }
                }
                ++i;
            }
        }
    }
}

