/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.elements;

import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.elements.BuilderBuildOptionsTreeNode;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;

public class BuilderBuildOptionsLabelProvider
extends OwnerDrawLabelProvider {
    private final Image enabledNoneImage = Activator.getImage("icons/obj16/enabled_none_obj.gif");
    private final Image enabledSomeImage = Activator.getImage("icons/obj16/enabled_some_obj.gif");
    private final Image enabledTickImage = Activator.getImage("icons/obj16/enabled_tick_obj.gif");
    private final Image disabledNoneImage = Activator.getImage("icons/obj16/disabled_none_obj.gif");
    private final Image disabledSomeImage = Activator.getImage("icons/obj16/disabled_some_obj.gif");
    private final Image disabledTickImage = Activator.getImage("icons/obj16/disabled_tick_obj.gif");

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
        if (element instanceof BuilderBuildOptionsTreeNode) {
            if (event.index == 0) {
                TreeItem treeItem = (TreeItem)event.item;
                treeItem.setText(((BuilderBuildOptionsTreeNode)element).getLabel());
            } else if (event.index > 0) {
                this.paintParentCheckbox(event, element);
            }
        } else if (element instanceof IImporterBuildOptions) {
            if (event.index == 0) {
                TreeItem treeItem = (TreeItem)event.item;
                treeItem.setText(((IImporterBuildOptions)element).getId());
            } else if (event.index > 0) {
                this.paintChildCheckbox(event, element);
            }
        }
    }

    private void paintChildCheckbox(Event event, Object element) {
        IImporterBuildOptions child = (IImporterBuildOptions)element;
        Image image = null;
        switch (event.index) {
            case 1: {
                if (child.isCompileEnabled()) {
                    if (child.isCompile()) {
                        image = this.enabledTickImage;
                        break;
                    }
                    image = this.enabledNoneImage;
                    break;
                }
                if (child.isCompile()) {
                    image = this.disabledTickImage;
                    break;
                }
                image = this.disabledNoneImage;
                break;
            }
            case 2: {
                if (child.isInitialEnabled()) {
                    if (child.isInitial()) {
                        image = this.enabledTickImage;
                        break;
                    }
                    image = this.enabledNoneImage;
                    break;
                }
                if (child.isInitial()) {
                    image = this.disabledTickImage;
                    break;
                }
                image = this.disabledNoneImage;
                break;
            }
            case 3: {
                if (child.isLibraryEnabled()) {
                    if (child.isLibrary()) {
                        image = this.enabledTickImage;
                        break;
                    }
                    image = this.enabledNoneImage;
                    break;
                }
                if (child.isLibrary()) {
                    image = this.disabledTickImage;
                    break;
                }
                image = this.disabledNoneImage;
                break;
            }
            case 4: {
                if (child.isRefreshEnabled()) {
                    if (child.isRefresh()) {
                        image = this.enabledTickImage;
                        break;
                    }
                    image = this.enabledNoneImage;
                    break;
                }
                if (child.isRefresh()) {
                    image = this.disabledTickImage;
                    break;
                }
                image = this.disabledNoneImage;
                break;
            }
            case 5: {
                if (child.isServiceEnabled()) {
                    if (child.isService()) {
                        image = this.enabledTickImage;
                        break;
                    }
                    image = this.enabledNoneImage;
                    break;
                }
                if (child.isService()) {
                    image = this.disabledTickImage;
                    break;
                }
                image = this.disabledNoneImage;
                break;
            }
            case 6: {
                if (child.isTestingEnabled()) {
                    if (child.isTesting()) {
                        image = this.enabledTickImage;
                        break;
                    }
                    image = this.enabledNoneImage;
                    break;
                }
                image = child.isTesting() ? this.disabledTickImage : this.disabledNoneImage;
            }
        }
        TreeItem treeItem = (TreeItem)event.item;
        Rectangle cellBounds = treeItem.getBounds(event.index);
        Rectangle imageBounds = image.getBounds();
        int x = cellBounds.x + (cellBounds.width - imageBounds.width) / 2;
        int y = cellBounds.y + (cellBounds.height - imageBounds.height) / 2;
        event.gc.drawImage(image, x, y);
    }

    private void paintParentCheckbox(Event event, Object element) {
        BuilderBuildOptionsTreeNode node = (BuilderBuildOptionsTreeNode)element;
        int total = 0;
        int count = 0;
        int check = 0;
        for (IImporterBuildOptions child : node.getChildren()) {
            switch (event.index) {
                case 1: {
                    ++total;
                    if (child.isCompile()) {
                        ++check;
                    }
                    if (!child.isCompileEnabled()) break;
                    ++count;
                    break;
                }
                case 2: {
                    ++total;
                    if (child.isInitial()) {
                        ++check;
                    }
                    if (!child.isInitialEnabled()) break;
                    ++count;
                    break;
                }
                case 3: {
                    ++total;
                    if (child.isLibrary()) {
                        ++check;
                    }
                    if (!child.isLibraryEnabled()) break;
                    ++count;
                    break;
                }
                case 4: {
                    ++total;
                    if (child.isRefresh()) {
                        ++check;
                    }
                    if (!child.isRefreshEnabled()) break;
                    ++count;
                    break;
                }
                case 5: {
                    ++total;
                    if (child.isService()) {
                        ++check;
                    }
                    if (!child.isServiceEnabled()) break;
                    ++count;
                    break;
                }
                case 6: {
                    ++total;
                    if (child.isTesting()) {
                        ++check;
                    }
                    if (!child.isTestingEnabled()) break;
                    ++count;
                }
            }
        }
        Image image = count == 0 ? (check == 0 ? this.disabledNoneImage : (check == total ? this.disabledTickImage : this.disabledSomeImage)) : (check == 0 ? this.enabledNoneImage : (check == total ? this.enabledTickImage : this.enabledSomeImage));
        TreeItem treeItem = (TreeItem)event.item;
        Rectangle cellBounds = treeItem.getBounds(event.index);
        Rectangle imageBounds = image.getBounds();
        int x = cellBounds.x + (cellBounds.width - imageBounds.width) / 2;
        int y = cellBounds.y + (cellBounds.height - imageBounds.height) / 2;
        event.gc.drawImage(image, x, y);
        node.getImageMap().put(event.index, image);
    }
}

