/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors.pages;

import com.ibm.team.enterprise.systemdefinition.client.mapping.ISystemDefinitionMappingClient;
import com.ibm.team.enterprise.systemdefinition.common.mapping.ISystemDefinitionMapping;
import com.ibm.team.enterprise.systemdefinition.common.mapping.ISystemDefinitionMappingPair;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.editors.SystemDefinitionMappingEditorInput;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.util.SystemDefinitionMappingContentProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.TeamFormEditor;
import com.ibm.team.ui.editor.TeamFormPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class SystemDefinitionMappingPage
extends TeamFormPage {
    protected FormToolkit toolkit;
    protected IManagedForm managedForm;
    private TableViewer systemDefinitionViewer;
    protected IItemType type;
    private boolean isDirty;
    private Button editButton;
    private Button resetButton;

    public SystemDefinitionMappingPage(FormEditor editor, IItemType type, String title) {
        super(editor, type.getName(), title);
        this.type = type;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.managedForm = managedForm;
        this.toolkit = managedForm.getToolkit();
        managedForm.getToolkit().setBorderStyle(2048);
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)new TableWrapLayout());
        Composite container = managedForm.getToolkit().createComposite(managedForm.getForm().getBody());
        TableWrapData layoutData = new TableWrapData(256, 256);
        container.setLayoutData((Object)layoutData);
        container.setLayout((Layout)new FormLayout());
        this.createMappingSection(container);
    }

    private Composite createMappingSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 384);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100);
        section.setLayoutData((Object)formData);
        section.setLayout((Layout)new GridLayout(1, false));
        section.setText(Messages.SystemDefinitionMappingEditorPage_MAPPING_SECTION_LABEL);
        Composite container = this.toolkit.createComposite((Composite)section);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)container);
        Composite composite = this.toolkit.createComposite(container);
        GridDataFactory.fillDefaults().grab(true, true).hint(1, -1).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Composite viewerComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        viewerComposite.setLayoutData((Object)gridData);
        TableColumnLayout tableLayout = new TableColumnLayout();
        viewerComposite.setLayout((Layout)tableLayout);
        this.systemDefinitionViewer = new TableViewer(viewerComposite, 68354);
        this.systemDefinitionViewer.setContentProvider((IContentProvider)new SystemDefinitionMappingContentProvider());
        this.systemDefinitionViewer.getTable().setLinesVisible(true);
        this.systemDefinitionViewer.getTable().setHeaderVisible(true);
        TableViewerColumn col1 = this.createTableColumn(Messages.SystemDefinitionMappingEditorPage_MAPPING_TABLE_COL1_LABEL);
        tableLayout.setColumnData((Widget)col1.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ISystemDefinitionMappingPair)element).getSrcName();
            }
        });
        TableViewerColumn col2 = this.createTableColumn(Messages.SystemDefinitionMappingEditorPage_MAPPING_TABLE_COL2_LABEL);
        tableLayout.setColumnData((Widget)col2.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        col2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ISystemDefinitionMappingPair)element).getTargetName();
            }
        });
        this.systemDefinitionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SystemDefinitionMappingPage.this.updateButtonStates();
            }
        });
        Composite buttonComposite = new Composite(container, 0);
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().applyTo(buttonComposite);
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText(Messages.SystemDefinitionMappingEditorPage_EDIT_BUTTON_LABEL);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.editButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SystemDefinitionMappingPage.this.systemDefinitionViewer.getSelection();
                SystemDefinitionMappingPage.this.editMappings(selection);
            }
        });
        this.resetButton = new Button(buttonComposite, 8);
        this.resetButton.setText(Messages.SystemDefinitionMappingEditorPage_RESET_BUTTON_LABEL);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.resetButton);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SystemDefinitionMappingPage.this.systemDefinitionViewer.getSelection();
                SystemDefinitionMappingPage.this.resetMappings(selection);
            }
        });
        this.systemDefinitionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SystemDefinitionMappingPage.this.editMappings(selection);
            }
        });
        try {
            RetrieveSystemDefinitionMappingJob job = new RetrieveSystemDefinitionMappingJob();
            job.schedule();
            job.join();
            this.systemDefinitionViewer.setInput((Object)job.mapping);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateButtonStates();
        return container;
    }

    private TableViewerColumn createTableColumn(String title) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.systemDefinitionViewer, 16384);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void doSave(IProgressMonitor monitor) {
        ISystemDefinitionMapping mappings;
        super.doSave(monitor);
        if (this.isDirty && (mappings = (ISystemDefinitionMapping)this.systemDefinitionViewer.getInput()) != null) {
            try {
                ITeamRepository repository = ((SystemDefinitionMappingEditorInput)this.getEditorInput()).getRepository();
                ISystemDefinitionMappingClient client = (ISystemDefinitionMappingClient)repository.getClientLibrary(ISystemDefinitionMappingClient.class);
                client.save(mappings, null);
                this.isDirty = false;
                ((TeamFormEditor)this.getEditor()).editorDirtyStateChanged();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)Messages.System_Definitions_label, (String)e.getLocalizedMessage());
            }
        }
    }

    protected void resetMappings(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        for (ISystemDefinitionMappingPair pair : selection) {
            pair.setTargetName("");
            pair.setTargetUUID(null);
        }
        this.systemDefinitionViewer.refresh();
        if (!this.isDirty) {
            this.isDirty = true;
            ((TeamFormEditor)this.getEditor()).editorDirtyStateChanged();
        }
    }

    protected void editMappings(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            try {
                ISystemDefinition def;
                SystemDefinitionSelectionDialog dlg = new SystemDefinitionSelectionDialog(this.getSite().getShell(), ((SystemDefinitionMappingEditorInput)this.getEditorInput()).getRepository(), this.type);
                if (dlg.open() == 0 && (def = dlg.getSelectedSystemDefinition()) != null) {
                    for (ISystemDefinitionMappingPair pair : selection) {
                        pair.setTargetName(def.getName());
                        pair.setTargetUUID(def.getItemId());
                    }
                    this.systemDefinitionViewer.refresh();
                    if (!this.isDirty) {
                        this.isDirty = true;
                        ((TeamFormEditor)this.getEditor()).editorDirtyStateChanged();
                    }
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.SystemDefinitionMappingDialogSelection_ERROR_TITLE, (String)e.getLocalizedMessage());
            }
        }
    }

    protected void updateButtonStates() {
        boolean hasSelection = this.systemDefinitionViewer.getSelection() != null && !this.systemDefinitionViewer.getSelection().isEmpty();
        this.editButton.setEnabled(hasSelection);
        this.resetButton.setEnabled(hasSelection);
    }

    class RetrieveSystemDefinitionMappingJob
    extends Job {
        protected ISystemDefinitionMapping mapping;

        public RetrieveSystemDefinitionMappingJob() {
            super("");
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ITeamRepository repository = ((SystemDefinitionMappingEditorInput)SystemDefinitionMappingPage.this.getEditorInput()).getRepository();
                ISystemDefinitionMappingClient client = (ISystemDefinitionMappingClient)repository.getClientLibrary(ISystemDefinitionMappingClient.class);
                this.mapping = client.getSystemDefinitionMapping(SystemDefinitionMappingPage.this.type, null);
            }
            catch (TeamRepositoryException e) {
                return new Status(4, "com.ibm.team.enterprise.definitions.ui", e.getLocalizedMessage());
            }
            return Status.OK_STATUS;
        }
    }
}

