/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors.pages;

import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDTO;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDelta;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.ISysDefUIListener;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.enterprise.systemdefinition.ui.helper.SystemDefHistoryHelper;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.util.SysDefHistoryLogItem;
import com.ibm.team.feed.ui.internal.itemview.DefaultItemViewLabelProvider;
import com.ibm.team.feed.ui.internal.itemview.DefaultTimelineContentProvider;
import com.ibm.team.feed.ui.internal.itemview.ItemViewerContentProvider;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.internal.ItemViewAdvisorManager;
import com.ibm.team.jface.itemview.FullTextSearchFilter;
import com.ibm.team.jface.itemview.IItemViewListener;
import com.ibm.team.jface.itemview.IItemViewerLabelProvider;
import com.ibm.team.jface.itemview.ItemViewControl;
import com.ibm.team.jface.itemview.ItemViewUIConfigurer;
import com.ibm.team.jface.itemview.ItemViewer;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import com.ibm.team.jface.itemview.ItemViewerSorter;
import com.ibm.team.jface.itemview.TimelineFilter;
import com.ibm.team.jface.timeline.ITimelineContentProvider;
import com.ibm.team.jface.timeline.Range;
import com.ibm.team.jface.timeline.TimelineUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.UIJob;

public class SysDefHistoryPage {
    private static final int TIMELINE_FILTER_DELAY = 500;
    private UIJob fTimelineFilterJob;
    private TimelineFilter fTimelineFilter;
    private ItemViewer fViewer;
    private ItemViewerContentProvider fContentProvider;
    private IProgressMonitor fComputeMonitor;
    private FullTextSearchFilter fItemViewFilter;
    private ItemViewControl fItemViewControl;
    private ItemViewUIConfigurer fUIConfigurer;
    private IEditorInput editorInput;
    private IWorkbenchPartSite partSite;
    private final HistoryLogListener historyLogListener = new HistoryLogListener();
    private FormToolkit fToolkit;
    private ISystemDefinition fSysDef = null;
    private SystemDefHistoryHelper fHistoryHelper = null;

    public ISysDefUIListener getHistoryLogListener() {
        return this.historyLogListener;
    }

    public IWorkbenchPartSite getPartSite() {
        return this.partSite;
    }

    public void setPartSite(IWorkbenchPartSite partSite) {
        this.partSite = partSite;
    }

    public SysDefHistoryPage(String elementId, String title) {
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setEditoInput(input);
        this.loadContributions();
    }

    public void setWorkingCopy(ISystemDefinition sysDef) {
        this.fSysDef = sysDef;
    }

    public void createContent(Composite parent, FormToolkit toolkit, IWorkbenchPartSite partSite) {
        this.fToolkit = toolkit;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        parent.setLayout((Layout)layout);
        DefaultTimelineContentProvider timelineContentProvider = new DefaultTimelineContentProvider();
        this.fItemViewControl = new ItemViewControl(this.fUIConfigurer, (ITimelineContentProvider)timelineContentProvider);
        this.fItemViewControl.setSidebarHidden(true);
        this.fItemViewControl.create(parent, toolkit);
        this.fItemViewControl.addItemViewListener(new IItemViewListener(){

            public void quickSearched(String search) {
            }

            public void quickSearchCanceld() {
            }

            public void expandedAll() {
                SysDefHistoryPage.this.fViewer.expandAll();
            }

            public void collapsedAll() {
                SysDefHistoryPage.this.fViewer.collapseAll();
            }

            public void sideBarToggled(boolean visible) {
            }

            public void sorted(String id) {
                for (ItemViewerSorter sorter : SysDefHistoryPage.this.fUIConfigurer.getSorters()) {
                    if (!id.equals(sorter.getId())) continue;
                    if (sorter.equals((Object)SysDefHistoryPage.this.fViewer.getSorter())) break;
                    SysDefHistoryPage.this.fViewer.setSorter(sorter.getViewerSorter());
                    SysDefHistoryPage.this.fViewer.getControl().setFocus();
                    break;
                }
            }

            public void filtered(String id, boolean enabled) {
                for (ItemViewerFilter filter : SysDefHistoryPage.this.fUIConfigurer.getFilters()) {
                    if (!id.equals(filter.getId())) continue;
                    if (enabled) {
                        SysDefHistoryPage.this.fViewer.addFilter(filter.getViewerFilter());
                    } else {
                        SysDefHistoryPage.this.fViewer.removeFilter(filter.getViewerFilter());
                    }
                    SysDefHistoryPage.this.fViewer.getControl().setFocus();
                }
            }
        });
        this.fItemViewControl.getTimelineViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Range range = (Range)selection.getFirstElement();
                SysDefHistoryPage.this.performTimelineFilter(range, 500);
            }
        });
        ContextProvider contextProvider = (ContextProvider)partSite.getAdapter(ContextProvider.class);
        this.fViewer = new ItemViewer(this.fItemViewControl.getBrowserContainer(), contextProvider, 0, 1);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 700;
        data.widthHint = 64;
        data.heightHint = 64;
        this.fViewer.getControl().setLayoutData((Object)data);
        this.fContentProvider = new ItemViewerContentProvider();
        this.fViewer.setContentProvider((IStructuredContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IItemViewerLabelProvider)new DefaultItemViewLabelProvider());
        this.fViewer.setInput((Object)new Object[]{new SysDefHistoryLogItem(new Date(System.currentTimeMillis()), Messages.SysDef_History_COMPUTING_HISTORY_JOB, "", false)});
        this.fItemViewFilter = new FullTextSearchFilter();
        this.fViewer.addFilter((ViewerFilter)this.fItemViewFilter, false);
        this.fTimelineFilter = new TimelineFilter(timelineContentProvider.getDefaultRange());
        this.fViewer.addFilter((ViewerFilter)this.fTimelineFilter, false);
        if (this.fUIConfigurer.getDefaultSorter() != null) {
            this.fViewer.setSorter(this.fUIConfigurer.getDefaultSorter().getViewerSorter());
        }
        this.computeHistory();
    }

    private void computeHistory() {
        final AbstractEditorInput editorInput = (AbstractEditorInput)this.getEditorInput();
        if (editorInput == null) {
            return;
        }
        FoundationJob job = new FoundationJob(Messages.SysDef_History_COMPUTING_HISTORY_JOB){

            protected IStatus runProtected(IProgressMonitor monitor) {
                Object[] input;
                SysDefHistoryPage.this.fComputeMonitor = monitor;
                Range newrange = null;
                if (editorInput != null && SysDefHistoryPage.this.fSysDef != null && editorInput.isNewSystemDefinition()) {
                    input = new Object[]{new SysDefHistoryLogItem(new Date(System.currentTimeMillis()), Messages.SysDef_History_WORKITEM_NOT_YET_SAVED, "", false)};
                } else {
                    input = SysDefHistoryPage.this.getHistory(monitor);
                    newrange = this.computeNewRange((SysDefHistoryLogItem[])input);
                }
                final Range visibleRange = newrange;
                FoundationUIJob uijob = new FoundationUIJob(Messages.SysDef_History_DISPLAYING_HISTORY){

                    public IStatus runProtectedInUI(IProgressMonitor uimonitor) {
                        if (SysDefHistoryPage.this.fViewer != null && !SysDefHistoryPage.this.fViewer.getControl().isDisposed()) {
                            SysDefHistoryPage.this.fViewer.setInput(input);
                            SysDefHistoryPage.this.fViewer.expandAll();
                            SysDefHistoryPage.this.fItemViewControl.getTimelineViewer().setInput(input);
                            if (visibleRange != null) {
                                SysDefHistoryPage.this.fItemViewControl.getTimelineViewer().setVisibleRange(visibleRange);
                                boolean refreshed = SysDefHistoryPage.this.performTimelineFilter(visibleRange, 0);
                                if (!refreshed) {
                                    SysDefHistoryPage.this.fViewer.refresh();
                                }
                            } else {
                                SysDefHistoryPage.this.fViewer.refresh();
                                SysDefHistoryPage.this.fViewer.getControl().setFocus();
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                uijob.setSystem(true);
                uijob.schedule();
                SysDefHistoryPage.this.fComputeMonitor = null;
                return Status.OK_STATUS;
            }

            private Range computeNewRange(SysDefHistoryLogItem[] items) {
                Calendar end = Calendar.getInstance();
                end.set(10, 0);
                end.set(12, 0);
                end.set(13, 0);
                end.set(14, 0);
                Calendar start = Calendar.getInstance();
                start.setTimeInMillis(end.getTimeInMillis());
                end.add(6, 2);
                start.add(3, -1);
                long starttime = start.getTimeInMillis();
                int i = 0;
                while (i < items.length) {
                    long current = items[i].getDate().getTime();
                    if (current < starttime) {
                        starttime = current;
                    }
                    ++i;
                }
                start.setTimeInMillis(starttime);
                start.set(10, 0);
                start.set(12, 0);
                start.set(13, 0);
                start.set(14, 0);
                start.add(6, -1);
                Range range = new Range(start.getTimeInMillis(), end.getTimeInMillis());
                return range;
            }
        };
        job.schedule();
    }

    boolean performTimelineFilter(final Range range, int delay) {
        if (this.fTimelineFilterJob != null) {
            this.fTimelineFilterJob.cancel();
        }
        if (this.fTimelineFilter.getSelectedRange() != null) {
            Range oldRange = this.fTimelineFilter.getSelectedRange();
            Range newRange = range;
            Date oldDateFrom = new Date(TimelineUtils.trimToDay((long)oldRange.getStart()));
            Date oldDateTo = new Date(TimelineUtils.trimToDay((long)oldRange.getEnd()));
            Date newDateFrom = new Date(TimelineUtils.trimToDay((long)newRange.getStart()));
            Date newDateTo = new Date(TimelineUtils.trimToDay((long)newRange.getEnd()));
            if (oldDateFrom.equals(newDateFrom) && oldDateTo.equals(newDateTo)) {
                return false;
            }
        }
        this.fTimelineFilterJob = new FoundationUIJob(Messages.SysDef_History_FILTER_TIMELINE_ITEMS){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (!monitor.isCanceled() && SysDefHistoryPage.this.fViewer != null) {
                    SysDefHistoryPage.this.fTimelineFilter.setSelectedRange(range);
                    SysDefHistoryPage.this.fViewer.refresh();
                    SysDefHistoryPage.this.fViewer.getControl().setFocus();
                }
                return Status.OK_STATUS;
            }
        };
        this.fTimelineFilterJob.setSystem(true);
        this.fTimelineFilterJob.schedule((long)delay);
        return true;
    }

    private SysDefHistoryLogItem[] getHistory(IProgressMonitor monitor) {
        ArrayList<SysDefHistoryLogItem> logItems = new ArrayList<SysDefHistoryLogItem>();
        ITeamRepository repository = ((AbstractEditorInput)this.getEditorInput()).getTeamRepository();
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repository);
        try {
            List changeLogDTOs = client.computeHistory((ISystemDefinitionHandle)this.fSysDef, monitor);
            int size = changeLogDTOs.size();
            if (this.fHistoryHelper == null) {
                this.fHistoryHelper = new SystemDefHistoryHelper(null, repository);
            }
            boolean isLatest = true;
            if (this.editorInput != null && this.editorInput instanceof AbstractEditorInput) {
                isLatest = ((AbstractEditorInput)this.editorInput).isLatest();
            }
            Timestamp modifiedSince = null;
            if (!isLatest) {
                ISystemDefinition sysdef = ((AbstractEditorInput)this.editorInput).getSystemDefinition();
                modifiedSince = client.getModifiedDateByStateId((ISystemDefinitionHandle)sysdef, monitor);
            }
            StringBuilder titleBuilder = new StringBuilder();
            int i = 0;
            while (i < size) {
                ChangeLogDTO changeLogDTO = (ChangeLogDTO)changeLogDTOs.get(i);
                IContributorHandle contributorHandle = changeLogDTO.getModifiedBy();
                IContributor modifiedBy = (IContributor)repository.itemManager().fetchCompleteItem((IItemHandle)contributorHandle, 0, null);
                titleBuilder.delete(0, titleBuilder.length());
                titleBuilder.append(XMLString.createFromPlainText((String)modifiedBy.getName()).getXMLText());
                if (modifiedSince != null && changeLogDTO.getModifiedDate().after(modifiedSince)) {
                    titleBuilder.append("&nbsp;").append("(<span style=\"{background: #FFFF99;}\"><b>").append(Messages.SysDef_History_CHANGE_FROM_THIS_VERSION).append("</b></span>)");
                }
                logItems.add(new SysDefHistoryLogItem(changeLogDTO.getModifiedDate(), titleBuilder.toString(), this.fHistoryHelper.generateHTMLContent((List<ChangeLogDelta>)changeLogDTO.getChanges(), i == 0, modifiedSince, changeLogDTO.getModifiedDate()), i == 0));
                ++i;
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
            return new SysDefHistoryLogItem[]{new SysDefHistoryLogItem(new Timestamp(System.currentTimeMillis()), Messages.SysDef_History_ERROR_COMPUTING_HISTORY_MSG, "", false)};
        }
        return logItems.toArray(new SysDefHistoryLogItem[logItems.size()]);
    }

    public IEditorInput getEditorInput() {
        return this.editorInput;
    }

    public void setEditoInput(IEditorInput editorInput) {
        this.editorInput = editorInput;
    }

    public boolean validate() {
        return true;
    }

    public void dispose() {
        if (this.fComputeMonitor != null) {
            this.fComputeMonitor.setCanceled(true);
        }
        this.fViewer = null;
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
    }

    public void setHistoryHelper(SystemDefHistoryHelper historyHelper) {
        this.fHistoryHelper = historyHelper;
    }

    public FormToolkit getToolkit() {
        return this.fToolkit;
    }

    private void loadContributions() {
        this.fUIConfigurer = ItemViewAdvisorManager.getConfigurer();
    }

    private class HistoryLogListener
    implements ISysDefUIListener {
        private HistoryLogListener() {
        }

        @Override
        public void processEvent(ISystemDefinition sysDef) {
            SysDefHistoryPage.this.computeHistory();
        }
    }
}

