/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors.jobs;

import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJobContext;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJobHelper;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.repository.common.ItemNotFoundException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public abstract class BaseEditorJob
extends SystemDefinitionJob {
    private final AbstractSystemDefinitionEditor fEditor;
    private boolean fShouldMakeEditorBusy = true;
    private boolean fEditorSetBusyTrueWasCalled = false;

    public BaseEditorJob(String jobName, boolean isUserInitiated, AbstractSystemDefinitionEditor editor) {
        super(jobName, isUserInitiated, editor.getTeamRepository());
        this.fEditor = editor;
    }

    public BaseEditorJob(String jobName, boolean isUserInitiated, AbstractSystemDefinitionEditor editor, SystemDefinitionJobContext context) {
        super(jobName, isUserInitiated, editor.getTeamRepository(), context);
        this.fEditor = editor;
    }

    public void shouldMakeEditorBusy(boolean flag) {
        this.fShouldMakeEditorBusy = flag;
    }

    protected void setEditorBusy(boolean busy) {
        this.getEditor().setBusy(busy);
    }

    protected final IStatus runProtected(IProgressMonitor monitor) throws Exception {
        if (this.fShouldMakeEditorBusy) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!BaseEditorJob.this.getEditor().isDisposed()) {
                        BaseEditorJob.this.setEditorBusy(true);
                        BaseEditorJob.this.fEditorSetBusyTrueWasCalled = true;
                    }
                }
            });
        }
        this.internalRunProtected(monitor);
        return Status.OK_STATUS;
    }

    protected abstract void internalRunProtected(IProgressMonitor var1) throws Exception;

    public AbstractSystemDefinitionEditor getEditor() {
        return this.fEditor;
    }

    protected void internalJobFinished(IStatus status) {
    }

    protected String getHeaderMessageTitle(IStatus status) {
        return NLS.bind((String)Messages.BaseEditorJob_JOB_FAILED, (Object)this.getShortName());
    }

    protected void setHeaderMessage(IStatus status) {
        String title = this.getHeaderMessageTitle(status);
        this.getEditor().addLifecycleErrorMessage(title, title, status);
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    @Override
    protected final void jobFinished(final IStatus status) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!BaseEditorJob.this.getEditor().isDisposed()) {
                    try {
                        if (BaseEditorJob.this.isUserInitiated() && (status.getSeverity() == 4 || status.getSeverity() == 2)) {
                            IStatus headerStatus = status;
                            if (BaseEditorJob.this.isExpectedStatus(status) && !(status.getException() instanceof ItemNotFoundException)) {
                                headerStatus = SystemDefinitionJobHelper.convertToWarningStatus(status);
                            }
                            headerStatus = SystemDefinitionJobHelper.createDisplayableStatus(headerStatus);
                            BaseEditorJob.this.setHeaderMessage(headerStatus);
                        }
                        BaseEditorJob.this.internalJobFinished(status);
                    }
                    finally {
                        if (BaseEditorJob.this.fEditorSetBusyTrueWasCalled) {
                            BaseEditorJob.this.setEditorBusy(false);
                        }
                    }
                }
            }
        });
    }
}

