/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors.actions;

import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.helper.SystemDefUIHelper;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.node.AbstractEnterpriseExtensionsSystemDefinitionNode;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class UnArchiveSystemDefinitionAction
extends Action {
    private static IProjectAreaHandle fProjectAreaHandle;
    private final IWorkbenchPartSite fPartSite;
    private final IStructuredSelection fSelection;

    public UnArchiveSystemDefinitionAction(IWorkbenchPartSite site, IProjectAreaHandle projectAreaHandle, IStructuredSelection selection) {
        super(Messages.UnArchiveLanguageDefinitionAction_0);
        this.fPartSite = site;
        this.fSelection = selection;
        fProjectAreaHandle = projectAreaHandle;
    }

    public void run() {
        IWorkbenchWindow workbenchWindow = this.fPartSite.getWorkbenchWindow();
        IWorkbenchPage page = null;
        if (workbenchWindow != null) {
            page = workbenchWindow.getActivePage();
        }
        if (page != null && SystemDefUIHelper.showQueryDialog(Messages.AbstractRepositoryActionDelegate_0, Messages.UnArchiveLanguageDefinitionAction_2)) {
            for (Object object : this.fSelection) {
                if (!(object instanceof AbstractEnterpriseExtensionsSystemDefinitionNode)) continue;
                UnArchiveSystemDefinitionAction.unArchiveSystemDefinition(((AbstractEnterpriseExtensionsSystemDefinitionNode)((Object)object)).getSystemDefinition(), object);
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public static void unArchiveSystemDefinition(final ISystemDefinition systemDefinition, final Object object) {
        Job job = new Job(Messages.UnArchiveLanguageDefinitionAction_0){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.UnArchiveLanguageDefinitionAction_4, 2);
                    ITeamRepository repository = (ITeamRepository)fProjectAreaHandle.getOrigin();
                    ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repository);
                    ISystemDefinition fullSysDef = client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)systemDefinition, false, (IProgressMonitor)new NullProgressMonitor());
                    if (fullSysDef != null) {
                        fullSysDef = (ISystemDefinition)fullSysDef.getWorkingCopy();
                        fullSysDef.setArchived(false);
                        client.saveSystemDefinition(fullSysDef, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    }
                    if (object instanceof AbstractEnterpriseExtensionsSystemDefinitionNode) {
                        AbstractEnterpriseExtensionsSystemDefinitionNode.updateNode((AbstractEnterpriseExtensionsSystemDefinitionNode)((Object)object));
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamRepositoryException e) {
                    Status status = new Status(4, Activator.getUniqueIdentifier(), Messages.UnArchiveLanguageDefinitionAction_5, (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

