/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors.actions;

import com.ibm.team.enterprise.systemdefinition.common.helper.ValidationHelper;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractActionFormEditor;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class RefreshEditorAction
extends Action {
    private final AbstractActionFormEditor fEditor;
    private final Shell fEditorShell;

    public RefreshEditorAction(AbstractActionFormEditor editor, Shell editorShell) {
        super(Messages.RefreshEditorAction_RefreshButtonToolTip);
        ValidationHelper.validateNotNull((String)"editor", (Object)((Object)editor));
        ValidationHelper.validateNotNull((String)"editorShell", (Object)editorShell);
        this.fEditor = editor;
        this.fEditorShell = editorShell;
        this.setImageDescriptor(Activator.getImageDescriptor("icons/gen/refresh.gif"));
    }

    public void updateEnabledState() {
        if (this.fEditor.isBusy()) {
            this.setEnabled(false);
            return;
        }
        if (this.fEditor.isNewItem()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        if (this.fEditor.isDirty() && !this.confirmRefresh()) {
            return;
        }
        this.fEditor.refreshSystemDefinition();
    }

    protected boolean confirmRefresh() {
        String message = NLS.bind((String)Messages.RefreshEditorAction_RefreshConfirmDialogMessage, (Object)this.fEditor.getSystemDefinitionTypeName());
        return MessageDialog.openConfirm((Shell)this.fEditorShell, (String)Messages.RefreshEditorAction_RefreshConfirmDialogTitle, (String)message);
    }
}

