/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors.actions;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.DuplicateSystemDefinitionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.node.AbstractEnterpriseExtensionsSystemDefinitionNode;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.repository.common.model.Item;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;

public class DuplicateSystemDefinitionAction
extends Action {
    private final IWorkbenchPartSite fPartSite;
    private final AbstractEnterpriseExtensionsSystemDefinitionNode fSystemDef;
    private static IProjectAreaHandle fProjectAreaHandle;

    public DuplicateSystemDefinitionAction(IWorkbenchPartSite site, IProjectAreaHandle projectAreaHandle, AbstractEnterpriseExtensionsSystemDefinitionNode systemDef) {
        super(Messages.DuplicateSystemDefinitionAction_ACTION_LABEL);
        this.fPartSite = site;
        this.fSystemDef = systemDef;
        fProjectAreaHandle = projectAreaHandle;
    }

    public void run() {
        new DuplicateSystemDefinitionDialog(this.fSystemDef, this.fPartSite.getShell()).open();
    }

    public static void duplicateSystemDefinition(AbstractEnterpriseExtensionsSystemDefinitionNode systemDef, String newName) {
        DuplicateSystemDefinitionJob job = new DuplicateSystemDefinitionJob(systemDef, newName);
        job.scheduleAndUpdateUI();
    }

    static class DuplicateSystemDefinitionJob
    extends Job
    implements IJobChangeListener {
        AbstractEnterpriseExtensionsSystemDefinitionNode systemDef;
        String newName;

        public DuplicateSystemDefinitionJob(AbstractEnterpriseExtensionsSystemDefinitionNode systemDef, String newName) {
            super(Messages.DuplicateSystemDefinitionAction_JOB_LABEL);
            this.systemDef = systemDef;
            this.newName = newName;
            this.setUser(true);
        }

        public void scheduleAndUpdateUI() {
            this.addJobChangeListener(this);
            this.schedule();
        }

        protected IStatus run(IProgressMonitor monitor) {
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)((ITeamRepository)fProjectAreaHandle.getOrigin()));
            monitor.beginTask(Messages.DuplicateSystemDefinitionAction_JOB_LABEL, 2);
            try {
                ISystemDefinition resolvedSystemDef = client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)this.systemDef.getSystemDefinition(), true, monitor);
                ISystemDefinition workingCopy = (ISystemDefinition)resolvedSystemDef.getWorkingCopy();
                workingCopy.setName(this.newName);
                if (workingCopy instanceof Auditable) {
                    ((Auditable)workingCopy).setWorkingCopyPredecessor(null);
                }
                if (workingCopy instanceof ILanguageDefinition) {
                    ((ILanguageDefinition)workingCopy).getDefaultPatterns().clear();
                }
                if (workingCopy instanceof IZosLanguageDefinition) {
                    IZosLanguageDefinition zosLanguage = (IZosLanguageDefinition)workingCopy;
                    if (zosLanguage.hasSmpePackagingItem()) {
                        IPackagingItemDefinition oldpackagingItem = (IPackagingItemDefinition)zosLanguage.getSmpePackaging();
                        IPackagingItemDefinition newpackagingItem = PackagingFactory.copyLanguagePackagingItemDefinition((IPackagingItemDefinition)oldpackagingItem, (String)this.newName);
                        zosLanguage.setSmpePackaging((IPackagingItemDefinitionHandle)newpackagingItem);
                    } else {
                        zosLanguage.setSmpePackaging(null);
                    }
                }
                if (workingCopy instanceof Item) {
                    this.updateUUIDs((Item)workingCopy);
                }
                client.saveSystemDefinition(workingCopy, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (TeamRepositoryException e) {
                Status status = new Status(4, Activator.getUniqueIdentifier(), "", (Throwable)e);
                return status;
            }
            finally {
                monitor.done();
            }
        }

        private void updateUUIDs(Item item) {
            item.setItemId(UUID.generate());
            if (item instanceof EObject) {
                EObject eobject = (EObject)item;
                EClass eclass = eobject.eClass();
                for (EReference reference : eclass.getEAllContainments()) {
                    Object currentItem = eobject.eGet((EStructuralFeature)reference, true);
                    if (currentItem instanceof Helper) {
                        ((Helper)currentItem).setInternalId(UUID.generate());
                        continue;
                    }
                    if (!(currentItem instanceof Collection) || ((Collection)currentItem).isEmpty()) continue;
                    for (Object listItem : (Collection)currentItem) {
                        if (!(listItem instanceof Helper)) continue;
                        ((Helper)listItem).setInternalId(UUID.generate());
                    }
                }
            }
        }

        public void done(IJobChangeEvent event) {
            if (this.getResult().isOK()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((EnterpriseExtensionsDomainContentProvider)systemDef.getDomain().getContentProvider()).updateTreeViewer((AbstractEnterpriseExtensionsNode)systemDef.getParent());
                    }
                });
            }
            this.removeJobChangeListener(this);
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    }
}

