/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors.actions;

import com.ibm.team.enterprise.systemdefinition.ui.helper.SystemDefUIHelper;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJobContext;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class AbstractRepositoryActionDelegate
extends ActionDelegate {
    private boolean fActionConfirmed = false;
    private Shell fDialogParentShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();

    protected AbstractRepositoryActionDelegate() {
    }

    protected abstract String getConfirmationMessage();

    protected abstract void performAction(IProgressMonitor var1) throws TeamRepositoryException;

    protected ITeamRepository getRepositoryToValidate() {
        return null;
    }

    protected void showWarningDialog(String title, String message) {
        SystemDefUIHelper.showWarningDialog(this.getShell(), title, message);
    }

    protected abstract String getJobLabel();

    public void run(IAction action) {
        String confirmationMessage = this.getConfirmationMessage();
        if (confirmationMessage != null) {
            boolean proceed;
            this.fActionConfirmed = proceed = SystemDefUIHelper.showQueryDialog(Messages.AbstractRepositoryActionDelegate_0, confirmationMessage);
            if (!proceed) {
                return;
            }
        }
        SystemDefinitionJob job = this.createJob();
        job.setUser(true);
        job.schedule();
    }

    public boolean getActionConfirmed() {
        return this.fActionConfirmed;
    }

    protected Shell getShell() {
        return this.fDialogParentShell;
    }

    protected SystemDefinitionJob createJob() {
        SystemDefinitionJobContext context = new SystemDefinitionJobContext(){

            @Override
            public boolean isExpectedStatus(Job job, IStatus status) {
                return super.isExpectedStatus(job, status);
            }
        };
        return new SystemDefinitionJob(this.getJobLabel(), true, context){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                AbstractRepositoryActionDelegate.this.performAction(monitor);
                return Status.OK_STATUS;
            }

            @Override
            protected void jobFinished(IStatus status) {
                if (status.isOK() && AbstractRepositoryActionDelegate.this.fDialogParentShell != null) {
                    AbstractRepositoryActionDelegate.this.fDialogParentShell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractRepositoryActionDelegate.this.performUpdateUI();
                        }
                    });
                }
            }
        };
    }

    protected void performUpdateUI() {
    }
}

