/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors;

import com.ibm.team.enterprise.common.ui.editors.AbstractMessageFormEditor;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.ui.actions.SystemDefinitionMappingActionSave;
import com.ibm.team.enterprise.systemdefinition.ui.editors.SystemDefinitionMappingEditorInput;
import com.ibm.team.enterprise.systemdefinition.ui.editors.pages.SystemDefinitionMappingPage;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.Form;

public class SystemDefinitionMappingEditor
extends AbstractMessageFormEditor {
    protected SystemDefinitionMappingActionSave saveAction;
    protected int busyCount;
    protected boolean isDisposed = false;
    private SystemDefinitionMappingPage resourcedefPage;
    private SystemDefinitionMappingPage langdefPage;
    private SystemDefinitionMappingPage translatorPage;
    private SystemDefinitionMappingPage searchPathPage;

    protected void createHeaderContents(IManagedForm headerForm) {
        Form form = headerForm.getForm().getForm();
        form.setText(Messages.SystemDefinitionMappingEditor_HEADER_LABEL);
        form.setImage(null);
        IToolBarManager toolBarManager = form.getToolBarManager();
        this.saveAction = new SystemDefinitionMappingActionSave(this);
        toolBarManager.add((IContributionItem)this.saveAction);
        form.updateToolBar();
        this.addPropertyListener(new DirtyPropertyListener());
        this.fMessageManager = headerForm.getMessageManager();
        this.fMessageManager.setDecorationPosition(16512);
        Composite head = form.getHead();
        Composite headClient = new Composite(head, 0);
        headClient.setLayout((Layout)new GridLayout(2, false));
        headClient.setLayoutData((Object)new GridData());
        ITeamRepository repository = ((SystemDefinitionMappingEditorInput)this.getEditorInput()).getRepository();
        Label label = headerForm.getToolkit().createLabel(headClient, Messages.SystemDefinitionMappingEditor_REPOSITORY_LABEL);
        label.setBackground(null);
        Text text = headerForm.getToolkit().createText(headClient, repository.getRepositoryURI());
        text.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        headerForm.getForm().setHeadClient((Control)headClient);
    }

    protected void addPages() {
        try {
            this.resourcedefPage = new SystemDefinitionMappingPage((FormEditor)this, IResourceDefinition.ITEM_TYPE, Messages.SystemDefinitionMappingEditor_RESOURCE_DEFINITION_TAB);
            this.resourcedefPage.initialize((FormEditor)this);
            this.addPage((IFormPage)this.resourcedefPage);
            this.langdefPage = new SystemDefinitionMappingPage((FormEditor)this, ILanguageDefinition.ITEM_TYPE, Messages.SystemDefinitionMappingEditor_LANGUAGE_DEFINITION_TAB);
            this.langdefPage.initialize((FormEditor)this);
            this.addPage((IFormPage)this.langdefPage);
            this.translatorPage = new SystemDefinitionMappingPage((FormEditor)this, ITranslator.ITEM_TYPE, Messages.SystemDefinitionMappingEditor_TRANSLATOR_TAB);
            this.translatorPage.initialize((FormEditor)this);
            this.addPage((IFormPage)this.translatorPage);
            this.searchPathPage = new SystemDefinitionMappingPage((FormEditor)this, ISearchPath.ITEM_TYPE, Messages.SystemDefinitionMappingEditor_SEARCH_PATH_TAB);
            this.searchPathPage.initialize((FormEditor)this);
            this.addPage((IFormPage)this.searchPathPage);
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setBusy(boolean isBusy) {
        if (!this.isDisposed) {
            if (this.busyCount == 0 && isBusy) {
                this.getHeaderForm().getForm().setBusy(true);
            } else if (this.busyCount == 1 && !isBusy) {
                this.getHeaderForm().getForm().setBusy(false);
            }
            if (isBusy) {
                ++this.busyCount;
            } else if (this.busyCount > 0) {
                --this.busyCount;
            }
        }
        this.saveAction.updateEnabledState();
    }

    public boolean isBusy() {
        return this.busyCount > 0;
    }

    protected class DirtyPropertyListener
    implements IPropertyListener {
        protected DirtyPropertyListener() {
        }

        public void propertyChanged(Object source, int propertyId) {
            if (source instanceof IEditorPart && propertyId == 257) {
                SystemDefinitionMappingEditor.this.saveAction.updateEnabledState();
            }
        }
    }
}

