/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.ui.ILanguageExtensionHistoryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class LanguageExtensionHelperFactory {
    private static LanguageExtensionHelperFactory instance;
    private final Map<String, Map<String, IConfigurationElement>> languageExtensionHelperMap = new HashMap<String, Map<String, IConfigurationElement>>();

    private LanguageExtensionHelperFactory() {
    }

    public static LanguageExtensionHelperFactory getInstance() {
        if (instance == null) {
            instance = new LanguageExtensionHelperFactory();
            instance.init();
        }
        return instance;
    }

    public ILanguageExtensionHistoryHelper getLanguageExtensionHelper(String type, String platform) {
        IConfigurationElement configurationElement;
        if (this.languageExtensionHelperMap.containsKey(type) && (configurationElement = this.languageExtensionHelperMap.get(type).get(platform)) != null) {
            return this.createLanguageExtensionHelper(configurationElement);
        }
        return null;
    }

    public ILanguageExtensionHistoryHelper getLanguageExtensionHelper(IConfigurationElement configurationElement) {
        if (configurationElement != null) {
            return this.createLanguageExtensionHelper(configurationElement);
        }
        return null;
    }

    public List<ILanguageExtensionHistoryHelper> getLanguageExtensionHelpers(String target) {
        ArrayList<ILanguageExtensionHistoryHelper> result = new ArrayList<ILanguageExtensionHistoryHelper>();
        for (String type : this.languageExtensionHelperMap.keySet()) {
            for (String platform : this.languageExtensionHelperMap.get(type).keySet()) {
                IConfigurationElement configurationElement;
                if (!platform.equals(target) || (configurationElement = this.languageExtensionHelperMap.get(type).get(platform)) == null) continue;
                result.add(this.createLanguageExtensionHelper(configurationElement));
            }
        }
        return result;
    }

    private void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.getLanguageExtensionHelperExtensions(registry);
    }

    private void getLanguageExtensionHelperExtensions(IExtensionRegistry registry) {
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.ibm.team.enterprise.systemdefinition.languageExtensionHistoryHelpers");
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            String platform;
            String type;
            IConfigurationElement configurationElement = configurationElements[i];
            if (configurationElement.getName().equals("helper") && (type = configurationElement.getAttribute("type")) != null && !type.equals("") && (platform = configurationElement.getAttribute("platform")) != null && !platform.equals("")) {
                if (!this.languageExtensionHelperMap.containsKey(type)) {
                    this.languageExtensionHelperMap.put(type, new HashMap());
                }
                this.languageExtensionHelperMap.get(type).put(platform, configurationElement);
            }
            ++i;
        }
    }

    private ILanguageExtensionHistoryHelper createLanguageExtensionHelper(IConfigurationElement configurationElement) {
        try {
            Object object = configurationElement.createExecutableExtension("class");
            if (object instanceof ILanguageExtensionHistoryHelper) {
                ILanguageExtensionHistoryHelper historyHelper = (ILanguageExtensionHistoryHelper)object;
                return historyHelper;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }
}

