/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.ui.ILanguageExtensionEditorPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class LanguageExtensionEditorFactory {
    private static LanguageExtensionEditorFactory instance;
    private final Map<String, Map<String, IConfigurationElement>> languageExtensionEditorMap = new HashMap<String, Map<String, IConfigurationElement>>();

    private LanguageExtensionEditorFactory() {
    }

    public static LanguageExtensionEditorFactory getInstance() {
        if (instance == null) {
            instance = new LanguageExtensionEditorFactory();
            instance.init();
        }
        return instance;
    }

    public ILanguageExtensionEditorPage getLanguageExtensionEditor(String type, String platform) {
        IConfigurationElement configurationElement;
        if (this.languageExtensionEditorMap.containsKey(type) && (configurationElement = this.languageExtensionEditorMap.get(type).get(platform)) != null) {
            return this.createLanguageExtensionEditor(configurationElement);
        }
        return null;
    }

    public ILanguageExtensionEditorPage getLanguageExtensionEditor(IConfigurationElement configurationElement) {
        if (configurationElement != null) {
            return this.createLanguageExtensionEditor(configurationElement);
        }
        return null;
    }

    public List<ILanguageExtensionEditorPage> getLanguageExtensionEditors(String target) {
        ArrayList<ILanguageExtensionEditorPage> result = new ArrayList<ILanguageExtensionEditorPage>();
        for (String type : this.languageExtensionEditorMap.keySet()) {
            for (String platform : this.languageExtensionEditorMap.get(type).keySet()) {
                IConfigurationElement configurationElement;
                if (!platform.equals(target) || (configurationElement = this.languageExtensionEditorMap.get(type).get(platform)) == null) continue;
                result.add(this.createLanguageExtensionEditor(configurationElement));
            }
        }
        return result;
    }

    private void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.getLanguageExtensionEditorExtensions(registry);
    }

    private void getLanguageExtensionEditorExtensions(IExtensionRegistry registry) {
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.ibm.team.enterprise.systemdefinition.languageExtensionEditors");
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            String platform;
            String type;
            IConfigurationElement configurationElement = configurationElements[i];
            if (configurationElement.getName().equals("editor") && (type = configurationElement.getAttribute("type")) != null && !type.equals("") && (platform = configurationElement.getAttribute("platform")) != null && !platform.equals("")) {
                if (!this.languageExtensionEditorMap.containsKey(type)) {
                    this.languageExtensionEditorMap.put(type, new HashMap());
                }
                this.languageExtensionEditorMap.get(type).put(platform, configurationElement);
            }
            ++i;
        }
    }

    private ILanguageExtensionEditorPage createLanguageExtensionEditor(IConfigurationElement configurationElement) {
        try {
            Object object = configurationElement.createExecutableExtension("class");
            if (object instanceof ILanguageExtensionEditorPage) {
                ILanguageExtensionEditorPage editorPage = (ILanguageExtensionEditorPage)object;
                editorPage.setEditorPartName();
                return editorPage;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }
}

