/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors;

import com.ibm.team.enterprise.metadata.client.scanner.MetadataScannerUtil;
import com.ibm.team.enterprise.metadata.common.scanner.DependencyMetadataScannerFilter;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScannerFilter;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DependencyType;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.TranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.ui.IGenericListener;
import com.ibm.team.enterprise.systemdefinition.ui.ITranslatorEntryConsumer;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.DependencyTypeDialog;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.util.DependencyTypeLabelProvider;
import com.ibm.team.enterprise.systemdefinition.ui.util.ListContentProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.ui.editor.TeamFormPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.IProgressService;

public class DependencyTypesControl
implements ITranslatorEntryConsumer {
    private List<String> dependencyTypesResult = null;
    private final Shell fParentShell;
    private List<ITranslatorEntry> fTranslators;
    private List<IDependencyType> fDependencyTypes;
    private ILanguageDefinition fLanguageDefinition;
    private final Button fAddButton;
    private final Button fEditButton;
    private final Button fRemoveButton;
    private final Button fAddAllButton;
    private final TableViewer fTableViewer;
    private final ListenerList fListenerList = new ListenerList();
    private final Composite fComposite;
    private final ITeamRepository fTeamRepository;
    private final IProjectAreaHandle fProjectArea;
    private final DependencyTypeLabelProvider fLabelProvider;
    private final TeamFormPage fOwningEditorPage;
    private static final String COLUMN_TRANSLATORS = "translators";
    private static final String COLUMN_DEPENDENCY_TYPE = "dependencyType";
    private final FormToolkit fToolkit;

    public DependencyTypesControl(Composite parent, FormToolkit toolkit, ILanguageDefinition languageDefinition, ITeamRepository teamRepository, IProjectAreaHandle projectArea, TeamFormPage parentPage, boolean isEditable) {
        this.fOwningEditorPage = parentPage;
        this.fTranslators = languageDefinition.getTranslators();
        this.fDependencyTypes = languageDefinition.getDependencyTypes();
        this.fLanguageDefinition = languageDefinition;
        this.fParentShell = parent.getShell();
        this.fToolkit = toolkit;
        this.fTeamRepository = teamRepository;
        this.fProjectArea = projectArea;
        this.fComposite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)this.fComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fComposite);
        Composite tableComposite = this.fToolkit.createComposite(this.fComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        Table table = this.fToolkit.createTable(tableComposite, 68354);
        TableColumnLayout tcl = new TableColumnLayout();
        String[] columnProperties = new String[]{COLUMN_DEPENDENCY_TYPE, COLUMN_TRANSLATORS};
        String[] columnHeaders = new String[]{Messages.DependencyTypesControl_DEPENDENCY_TYPE, Messages.DependencyTypesControl_TRANSLATOR_NAME};
        int[] columnWeights = new int[]{50, 50};
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        ((GridData)tableComposite.getLayoutData()).heightHint = table.getItemHeight() * 10;
        tableComposite.setLayout((Layout)tcl);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Accessible a = (Accessible)e.getSource();
                if (a.getControl() instanceof Table && ((Table)a.getControl()).getItemCount() == 0) {
                    e.result = Messages.DependencyTypesSection_DESCRIPTION;
                }
            }
        });
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setColumnProperties(columnProperties);
        this.fTableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fLabelProvider = new DependencyTypeLabelProvider(this.fTableViewer, this.fTeamRepository, this.fProjectArea, this.fLanguageDefinition, this);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fTableViewer.setInput(this.fDependencyTypes);
        this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        Composite buttonBar = this.fToolkit.createComposite(this.fComposite);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 128).applyTo((Control)buttonBar);
        GridLayoutFactory.fillDefaults().applyTo(buttonBar);
        this.fAddButton = this.createButton(buttonBar, Messages.ADD_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fEditButton = this.createButton(buttonBar, Messages.EDIT_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fRemoveButton = this.createButton(buttonBar, Messages.REMOVE_BUTTON_LABEL, 8);
        this.fToolkit.createLabel(buttonBar, "");
        this.fAddAllButton = this.createButton(buttonBar, Messages.DependencyTypesControl_ADD_ALL_BUTTON_LABEL, 8);
        if (isEditable) {
            this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    DependencyTypesControl.this.handleDoubleClick(event);
                }
            });
            this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DependencyTypesControl.this.addDependencyType();
                }
            });
            this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IDependencyType dependencyType = DependencyTypesControl.this.getSelectedDependencyType();
                    if (dependencyType != null) {
                        DependencyTypesControl.this.editDependencyType(dependencyType);
                    }
                }
            });
            this.fAddAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DependencyTypesControl.this.addAllDependencyTypes();
                }
            });
            this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DependencyTypesControl.this.removeDependencyTypes();
                }
            });
        }
        this.updateButtonEnablement();
        this.setButtonLayoutData();
    }

    private IDependencyType getSelectedDependencyType() {
        IStructuredSelection selection = this.getCurrentSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IDependencyType) {
            return (IDependencyType)element;
        }
        return null;
    }

    protected IStructuredSelection getCurrentSelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    public List<ITranslatorEntry> getTranslators() {
        return this.fTranslators;
    }

    public void setTranslators(List<ITranslatorEntry> translators) {
        this.fTranslators = translators;
    }

    public List<IDependencyType> getDependencyTypes() {
        return this.fDependencyTypes;
    }

    public void setDependencyTypes(List<IDependencyType> dependencyTypes) {
        this.fDependencyTypes = dependencyTypes;
        this.updateDependencyTypes();
        this.fTableViewer.setInput(this.fDependencyTypes);
        this.fTableViewer.refresh();
        this.updateButtonEnablement();
    }

    public void setLanguageDefinitionWorkingCopy(ILanguageDefinition languageDefinition) {
        this.fLanguageDefinition = languageDefinition;
        this.setTranslators(this.fLanguageDefinition.getTranslators());
        this.setDependencyTypes(this.fLanguageDefinition.getDependencyTypes());
        this.fLabelProvider.setLanguageDefinitionWorkingCopy(this.fLanguageDefinition);
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DependencyTypesControl.this.updateButtonEnablement();
            }
        };
    }

    private void updateDependencyTypes() {
        for (IDependencyType depType : this.fDependencyTypes) {
            ArrayList<ITranslatorEntry> toRemove = new ArrayList<ITranslatorEntry>();
            for (ITranslatorEntry entry : depType.getTranslators()) {
                String value = entry.getValue();
                boolean found = false;
                for (ITranslatorEntry te : this.fLanguageDefinition.getTranslators()) {
                    if (!te.getValue().equals(value)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                toRemove.add(entry);
            }
            depType.getTranslators().removeAll(toRemove);
        }
    }

    public void addListener(IGenericListener listener) {
        this.fListenerList.add((Object)listener);
    }

    public void removeListener(IGenericListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    protected void notifyDependenciesModified() {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof IGenericListener) {
                IGenericListener listener = (IGenericListener)listeners[i];
                listener.contentsModified();
            }
            ++i;
        }
    }

    private DependencyTypeDialog getDependencyTypeDialog(IDependencyType dependencyType, String title) {
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DependencyTypesControl.this.setDependencyTypesResult(MetadataScannerUtil.getDependencyTypes((ITeamRepository)DependencyTypesControl.this.fTeamRepository, (ILanguageDefinition)DependencyTypesControl.this.fLanguageDefinition, (IFileMetadataScannerFilter)new DependencyMetadataScannerFilter(), (boolean)true));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DependencyTypeDialog(this.fParentShell, this.fToolkit, title, dependencyType, this.getDependencyTypesResult(), this.fTranslators, this.fLanguageDefinition.getDependencyTypes(), this.fTeamRepository, this.fProjectArea, this);
    }

    private List<String> getDependencyTypesResult() {
        return this.dependencyTypesResult;
    }

    private void setDependencyTypesResult(List<String> newTypeList) {
        if (this.dependencyTypesResult != null) {
            this.dependencyTypesResult.clear();
        }
        this.dependencyTypesResult = newTypeList;
    }

    private void editDependencyType(IDependencyType dependencyType) {
        DependencyTypeDialog dialog = this.getDependencyTypeDialog(dependencyType, Messages.DependencyTypesControl_EDIT_TITLE);
        if (dialog.open() == 0) {
            dependencyType.setLevel(dialog.getLevel());
            List translators = dependencyType.getTranslators();
            translators.clear();
            ITranslatorEntry[] iTranslatorEntryArray = dialog.getTranslators();
            int n = iTranslatorEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITranslatorEntry translator = iTranslatorEntryArray[n2];
                TranslatorEntry entry = ModelFactory.eINSTANCE.createTranslatorEntry();
                entry.setKind(translator.getKind());
                entry.setValue(translator.getValue());
                translators.add(entry);
                ++n2;
            }
            this.fTableViewer.refresh();
            this.notifyDependenciesModified();
        }
    }

    private void addDependencyType() {
        DependencyType dependencyType = ModelFactory.eINSTANCE.createDependencyType();
        DependencyTypeDialog dialog = this.getDependencyTypeDialog((IDependencyType)dependencyType, Messages.DependencyTypesControl_ADD_TITLE);
        if (dialog.open() == 0) {
            dependencyType.setName(dialog.getName());
            dependencyType.setLevel(dialog.getLevel());
            dependencyType.getTranslators().clear();
            List translators = dependencyType.getTranslators();
            ITranslatorEntry[] iTranslatorEntryArray = dialog.getTranslators();
            int n = iTranslatorEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITranslatorEntry translator = iTranslatorEntryArray[n2];
                TranslatorEntry entry = ModelFactory.eINSTANCE.createTranslatorEntry();
                entry.setKind(translator.getKind());
                entry.setValue(translator.getValue());
                translators.add(entry);
                ++n2;
            }
            this.fLanguageDefinition.getDependencyTypes().add(dependencyType);
            this.fTableViewer.refresh();
            this.notifyDependenciesModified();
        }
    }

    private void addAllDependencyTypes() {
        List<String> newDependencyTypes = Collections.emptyList();
        List types = this.fLanguageDefinition.getDependencyTypes();
        int sizeBefore = types.size();
        for (String typeString : newDependencyTypes) {
            boolean exists = false;
            for (IDependencyType type : types) {
                if (!type.getName().equals(typeString)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            DependencyType t = ModelFactory.eINSTANCE.createDependencyType();
            t.setLevel(0);
            t.setName(typeString);
            types.add(t);
        }
        this.fTableViewer.refresh();
        if (sizeBefore < types.size()) {
            this.notifyDependenciesModified();
        }
    }

    private void removeDependencyTypes() {
        boolean deleteConfirmed = MessageDialog.openQuestion((Shell)this.fParentShell, (String)Messages.DependencyTypesControl_DEPENDENCY_TYPE_DELETE_CONFIRM_TITLE, (String)Messages.DependencyTypesControl_DEPENDENCY_TYPE_DELETE_CONFIRM);
        if (deleteConfirmed) {
            IStructuredSelection structuredSelection = this.getCurrentDependencyTypeSelection();
            ArrayList<IDependencyType> entriesRemoved = new ArrayList<IDependencyType>();
            for (IDependencyType dependencyType : structuredSelection) {
                this.fDependencyTypes.remove(dependencyType);
                entriesRemoved.add(dependencyType);
            }
            if (!entriesRemoved.isEmpty()) {
                this.fTableViewer.refresh();
                this.notifyDependenciesModified();
                this.updateButtonEnablement();
            }
        }
    }

    private IStructuredSelection getCurrentDependencyTypeSelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    private void updateButtonEnablement() {
        IStructuredSelection selection = this.getCurrentDependencyTypeSelection();
        if (this.fEditButton != null) {
            this.fEditButton.setEnabled(selection.size() == 1);
        }
        if (this.fRemoveButton != null) {
            this.fRemoveButton.setEnabled(!selection.isEmpty());
        }
    }

    private Button createButton(Composite parent, String label, int style) {
        return this.fToolkit.createButton(parent, label, style);
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof IDependencyType) {
            IDependencyType dependencyType = (IDependencyType)element;
            this.editDependencyType(dependencyType);
        }
    }

    private void setButtonLayoutData() {
        GC gc = new GC((Drawable)this.fAddButton);
        gc.setFont(this.fAddButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fAddButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fEditButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fRemoveButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(4);
        gridData.widthHint = maxWidth;
        this.fAddButton.setLayoutData((Object)gridData);
        this.fEditButton.setLayoutData((Object)gridData);
        this.fRemoveButton.setLayoutData((Object)gridData);
        this.fAddAllButton.setLayoutData((Object)gridData);
    }

    public void setEnabled(boolean b) {
        if (!b) {
            this.fEditButton.setEnabled(false);
        } else {
            this.updateButtonEnablement();
        }
    }

    public Widget getComposite() {
        return this.fComposite;
    }

    public void refreshDependencyTypesViewer() {
        this.fTableViewer.refresh();
    }

    public TeamFormPage getOwningEditorPage() {
        return this.fOwningEditorPage;
    }

    @Override
    public Map<String, String> getTranslatorCache() {
        if (this.fOwningEditorPage != null && this.fOwningEditorPage instanceof ITranslatorEntryConsumer) {
            return ((ITranslatorEntryConsumer)this.fOwningEditorPage).getTranslatorCache();
        }
        return null;
    }
}

