/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public abstract class AbstractSystemDefinitionEditorInput
implements IEditorInput {
    private ISystemDefinition fSystemDefinition;
    private boolean fNewSystemDefinition;
    private ITeamRepository fTeamRepository;
    private final IProjectAreaHandle fProjectArea;

    public AbstractSystemDefinitionEditorInput(ISystemDefinition systemDefinition, IProjectAreaHandle projectArea) {
        if (projectArea != null) {
            this.fTeamRepository = (ITeamRepository)projectArea.getOrigin();
        }
        this.fProjectArea = projectArea;
        if (this.fSystemDefinition == null) {
            this.fNewSystemDefinition = true;
            this.fSystemDefinition = this.createSystemDefinition();
            this.fSystemDefinition.setProjectArea(this.fProjectArea);
            this.initializeSystemDefinition();
        } else {
            this.fNewSystemDefinition = false;
            this.fSystemDefinition = systemDefinition;
        }
    }

    public abstract ISystemDefinition createSystemDefinition();

    public abstract void initializeSystemDefinition();

    public boolean isNewSystemDefinition() {
        return this.fNewSystemDefinition;
    }

    public ISystemDefinition getSystemDefinition() {
        return this.fSystemDefinition;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fSystemDefinition.getName();
    }

    public String getToolTipText() {
        return this.fSystemDefinition.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractSystemDefinitionEditorInput)) {
            return false;
        }
        AbstractSystemDefinitionEditorInput input = (AbstractSystemDefinitionEditorInput)obj;
        return this.getSystemDefinition().sameItemId((IItemHandle)input.getSystemDefinition());
    }

    public int hashCode() {
        return this.getSystemDefinition().getItemId().hashCode();
    }
}

