/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors;

import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.common.ui.dialogs.MessagePromptDialog;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.client.EnterpriseConfigurationCache;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.EditorSystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.ISysDefUIObserver;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionEditor;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractActionFormEditor;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.enterprise.systemdefinition.ui.editors.SysDefUIObserverImpl;
import com.ibm.team.enterprise.systemdefinition.ui.editors.jobs.BaseEditorJob;
import com.ibm.team.enterprise.systemdefinition.ui.editors.jobs.RefreshLanguageDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJobContext;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.util.HeaderMessageHyperlinkListener;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractSystemDefinitionEditor
extends AbstractActionFormEditor
implements ISystemDefinitionEditor {
    protected boolean fDirty;
    protected IManagedForm headerForm;
    protected Text fSystemDefinitionIdText;
    protected boolean fIsNewSystemDefinition;
    protected boolean fNameChanged = false;
    protected ITeamRepository fTeamRepository;
    protected ISystemDefinition fSystemDefinition;
    protected IEnterpriseConfiguration configuration;
    protected ModifyListener fIdModifiedListener = this.getNameModifiedListener();
    protected ISysDefUIObserver sysDefUIObserver = new SysDefUIObserverImpl();
    private EditorSystemDefinitionCache fEditorCache;
    private RefreshLanguageDefinitionJob fRefreshLanguageDefinitionJob;

    public abstract void openLatestSysDefinition();

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        AbstractEditorInput fEditorInput = (AbstractEditorInput)input;
        this.fEditorCache = new EditorSystemDefinitionCache(fEditorInput.getTeamRepository());
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public ISystemDefinition getSystemDefinition() {
        return this.fSystemDefinition;
    }

    public IEnterpriseConfiguration getConfiguration() {
        return this.configuration != null ? this.configuration : this.fetchConfiguration();
    }

    private IEnterpriseConfiguration fetchConfiguration() {
        EnterpriseConfigurationCache instance = EnterpriseConfigurationCache.getInstance();
        IProjectAreaHandle projectArea = this.fSystemDefinition.getProjectArea();
        IEnterpriseConfiguration configuration = null;
        if (instance.has(this.fSystemDefinition.getProjectArea())) {
            this.configuration = configuration = instance.get(projectArea);
        } else {
            Job job = this.fetchConfigurationJob(this.fTeamRepository, projectArea, instance);
            try {
                job.join();
                this.configuration = configuration = instance.get(projectArea);
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
        }
        return configuration;
    }

    private Job fetchConfigurationJob(final ITeamRepository teamRepository, final IProjectAreaHandle projectArea, EnterpriseConfigurationCache instance) {
        Job fetchConfiguration = new Job(Messages.AbstractSystemDefinitionEditor_CONFIG){

            protected IStatus run(IProgressMonitor monitor) {
                EnterpriseConfigurationCache instance = EnterpriseConfigurationCache.getInstance();
                try {
                    if (!instance.has(projectArea)) {
                        instance.fetch(teamRepository, projectArea, monitor);
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        fetchConfiguration.schedule();
        return fetchConfiguration;
    }

    @Override
    public String getSystemDefinitionTypeName() {
        return Messages.BaseEditor_ITEM_NAME;
    }

    @Override
    public void refreshSystemDefinition() {
        this.removeLifecycleErrorMessages();
        this.removeAllErrorMessages();
        this.fRefreshLanguageDefinitionJob = new RefreshLanguageDefinitionJob(this);
        this.fRefreshLanguageDefinitionJob.schedule();
    }

    public abstract void refreshSystemDefinitionItem(IProgressMonitor var1);

    protected void refreshSystemDefinitionNode(final AbstractEnterpriseExtensionsNode node) {
        if (node != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((EnterpriseExtensionsDomainContentProvider)node.getDomain().getContentProvider()).updateTreeViewer(node);
                }
            });
        }
    }

    public Object getAdapter(Class adapter) {
        if (ISysDefUIObserver.class.equals((Object)adapter) && this.sysDefUIObserver != null) {
            return this.sysDefUIObserver;
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor monitor) {
        SystemDefinitionJobContext saveContext = new SystemDefinitionJobContext(){

            @Override
            protected String getStatusMessage(Throwable throwable) {
                if (throwable instanceof StaleDataException) {
                    return NLS.bind((String)Messages.BaseEditor_ERROR_MESSAGE_SAVE_CONFLICT, (Object)AbstractSystemDefinitionEditor.this.getSystemDefinitionTypeName());
                }
                return super.getStatusMessage(throwable);
            }
        };
        String jobName = NLS.bind((String)Messages.BaseEditor_SAVE_JOB_NAME, (Object)this.getSystemDefinitionTypeName());
        BaseEditorJob job = new BaseEditorJob(jobName, true, this, saveContext){

            @Override
            protected String getShortName() {
                return Messages.BaseEditor_SAVE_JOB_SHORT_NAME;
            }

            @Override
            protected String getHeaderMessageTitle(IStatus status) {
                if (status.getException() instanceof StaleDataException) {
                    return Messages.BaseEditor_ERROR_TITLE_SAVE_CONFLICT;
                }
                return super.getHeaderMessageTitle(status);
            }

            @Override
            protected void internalRunProtected(IProgressMonitor internalMonitor) throws Exception {
                final Exception[] saveException = new Exception[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractSystemDefinitionEditor.this.removeLifecycleErrorMessages();
                        IRunnableWithProgress runnable = AbstractSystemDefinitionEditor.this.createSaveItemRunnable();
                        try {
                            if (AbstractSystemDefinitionEditor.this.preSave()) {
                                AbstractSystemDefinitionEditor.this.invokeSaveRunnable(runnable);
                                AbstractSystemDefinitionEditor.this.postSave(true);
                                AbstractEditorInput editorInput = (AbstractEditorInput)AbstractSystemDefinitionEditor.this.getEditorInput();
                                editorInput.markSystemDefinitionSaved();
                                (this).AbstractSystemDefinitionEditor.this.sysDefUIObserver.notify((this).AbstractSystemDefinitionEditor.this.fSystemDefinition);
                            } else {
                                saveException[0] = new OperationCanceledException();
                            }
                        }
                        catch (InvocationTargetException exception) {
                            AbstractSystemDefinitionEditor.this.postSave(false);
                            saveException[0] = (Exception)exception.getCause();
                        }
                        catch (InterruptedException exception) {
                            saveException[0] = new OperationCanceledException();
                        }
                    }
                });
                if (saveException[0] != null) {
                    throw saveException[0];
                }
            }

            @Override
            protected void internalJobFinished(IStatus status) {
                super.internalJobFinished(status);
                AbstractSystemDefinitionEditor.this.handleSaveJobFinished(status);
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!job.getStatus().isOK()) {
            monitor.setCanceled(true);
        }
    }

    public void dispose() {
        this.fIsDisposed = true;
        if (this.fRefreshLanguageDefinitionJob != null) {
            this.fRefreshLanguageDefinitionJob.cancel();
        }
        if (this.fEditorCache != null) {
            this.fEditorCache.clear();
        }
        super.dispose();
    }

    @Override
    public void setPageImage(int pageIndex, Image image) {
        super.setPageImage(pageIndex, image);
    }

    @Override
    public IFormPage[] getPages() {
        return this.pages.toArray(new IFormPage[this.pages.size()]);
    }

    public void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
    }

    protected Composite createPageContainer(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpId());
        return super.createPageContainer(parent);
    }

    protected void createPages() {
        super.createPages();
        if (this.getPageCount() == 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
        }
    }

    protected abstract String getHelpId();

    public static String escapeAmpersands(String originalString) {
        StringBuffer newString = new StringBuffer(originalString.length());
        int i = 0;
        while (i < originalString.length()) {
            char c = originalString.charAt(i);
            newString.append(c);
            if (c == '&') {
                newString.append('&');
            }
            ++i;
        }
        return newString.toString();
    }

    public void setFocusInHeader() {
        if (this.fSystemDefinitionIdText != null) {
            this.fSystemDefinitionIdText.setFocus();
        }
    }

    public static boolean isValidBuildProperty(String prop) {
        return prop.startsWith("${") && prop.endsWith("}");
    }

    @Override
    protected HeaderMessageHyperlinkListener getMessageHyperlinkListener() {
        return new HeaderMessageHyperlinkListener(this);
    }

    public ISystemDefinitionCache getSystemDefinitionCache() {
        return this.fEditorCache;
    }

    private IProjectArea getProjectArea(IProjectAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = null;
        if (processArea != null) {
            projectArea = (IProjectArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)processArea, 0, monitor);
        }
        return projectArea != null ? projectArea : null;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.fDirty = isDirty;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    @Override
    protected void createHeaderContents(IManagedForm headerForm) {
        this.getToolkit().setBorderStyle(2048);
        super.createHeaderContents(headerForm);
        this.headerForm = headerForm;
        this.createHeaderSecondRow(headerForm);
        this.handleReadOnlyMode();
        headerForm.getForm().getForm().setImage(this.getHeaderTitleImage());
        this.handleArchived();
    }

    protected void handleReadOnlyMode() {
        AbstractEditorInput editorInput = (AbstractEditorInput)this.getEditorInput();
        if (!editorInput.isLatest()) {
            this.fSystemDefinitionIdText.setEnabled(false);
            this.getRefreshEditorAction().setEnabled(false);
            this.addInfoMessage("OPEN_LATEST_SYS_DEF", Messages.SysDef_OPEN_LATEST, editorInput);
        }
    }

    @Override
    public boolean isNewItem() {
        return this.fIsNewSystemDefinition;
    }

    protected void createHeaderSecondRow(IManagedForm headerForm) {
        FormToolkit toolkit = this.getToolkit();
        Composite head = headerForm.getForm().getForm().getHead();
        Composite headClient = new Composite(head, 0);
        GridLayout layout = new GridLayout(5, false);
        layout.horizontalSpacing = 7;
        headClient.setLayout((Layout)layout);
        GridData gridData = new GridData();
        headClient.setLayoutData((Object)gridData);
        Label label = toolkit.createLabel(headClient, Messages.AbstractSystemDefinitionEditor_SYSTEM_DEFINITION_NAME_LABEL);
        label.setBackground(null);
        label.setToolTipText(Messages.AbstractSystemDefinitionEditor_SYSTEM_DEFINITION_NAME_TOOLTIP);
        this.fSystemDefinitionIdText = toolkit.createText(headClient, this.fSystemDefinition.getName());
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this.fSystemDefinitionIdText.setLayoutData((Object)gridData);
        this.fSystemDefinitionIdText.addModifyListener(this.fIdModifiedListener);
        this.setPartName();
        label = toolkit.createLabel(headClient, "");
        gridData = new GridData();
        gridData.widthHint = 5;
        label.setLayoutData((Object)gridData);
        label.setBackground(null);
        label = toolkit.createLabel(headClient, Messages.AbstractSystemDefinitionEditor_PROJECT_AREA_LABEL);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setBackground(null);
        String projectAreaName = null;
        try {
            projectAreaName = this.getProjectAreaName();
        }
        catch (TeamRepositoryException e) {
            Activator.log(e);
        }
        Text paName = toolkit.createText(headClient, projectAreaName);
        paName.setLayoutData((Object)new GridData(768));
        paName.setEnabled(false);
        headerForm.getForm().setHeadClient((Control)headClient);
    }

    private String getProjectAreaName() throws TeamRepositoryException {
        String projectAreaName = Messages.AbstractSystemDefinitionEditor_MISSING;
        IEditorInput input = this.getEditorInput();
        if (input != null && input instanceof AbstractEditorInput) {
            String paName;
            AbstractEditorInput systemInput = (AbstractEditorInput)input;
            IProjectAreaHandle paHandle = systemInput.getProjectArea();
            IProjectArea pa = null;
            pa = paHandle != null ? (paHandle instanceof IProjectArea ? (IProjectArea)paHandle : this.getProjectArea(paHandle, (IProgressMonitor)new NullProgressMonitor())) : this.getProjectArea(this.fSystemDefinition.getProjectArea(), (IProgressMonitor)new NullProgressMonitor());
            if (pa != null && (paName = pa.getName()) != null) {
                projectAreaName = paName;
            }
        }
        return projectAreaName;
    }

    protected ModifyListener getNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractSystemDefinitionEditor.this.fSystemDefinition.setName(AbstractSystemDefinitionEditor.this.fSystemDefinitionIdText.getText().trim());
                AbstractSystemDefinitionEditor.this.setPartName();
                if (AbstractSystemDefinitionEditor.this.shouldValidate()) {
                    AbstractSystemDefinitionEditor.this.validate();
                }
                AbstractSystemDefinitionEditor.this.setDirty(true);
                AbstractSystemDefinitionEditor.this.fNameChanged = true;
            }
        };
    }

    protected boolean shouldValidate() {
        return !this.fIsNewSystemDefinition || this.fSaveAttempted;
    }

    public void setPartName() {
        String label = this.fSystemDefinition.getName();
        if (label == null || label.equals("")) {
            label = Messages.AbstractSystemDefinitionEditor_UNTITLED_LABEL;
        }
        this.setPartName(label);
    }

    protected abstract boolean validate();

    @Override
    protected boolean preSave() {
        this.fSaveAttempted = true;
        boolean isValid = this.validate();
        if (isValid && this.getSystemDefinition() != null && this.getSystemDefinition().isNonImpacting()) {
            String title = Messages.SystemDefUIHelper_NON_IMPACTING_DIALOG_TITLE;
            String message = Messages.SystemDefUIHelper_NON_IMPACTING_ON_WARNING;
            MessagePromptDialog.openWarning((Shell)this.getSite().getShell(), (String)title, (String)message, (String)"nonImpactSystemDefinitionWarningPreferenceId");
        }
        return isValid;
    }

    @Override
    protected void postSave(boolean saveSucceeded) {
        if (saveSucceeded) {
            this.setPartName();
            this.setDirty(false);
        }
    }

    public void setFocus() {
        int pageIndex = this.getActivePage();
        if (pageIndex != -1) {
            IFormPage page = (IFormPage)this.pages.get(pageIndex);
            page.setFocus();
        } else {
            super.setFocus();
        }
    }

    @Override
    protected void disposeEditorSections() {
    }

    protected void handleArchived() {
        if (this.fSystemDefinition.isArchived()) {
            this.fSystemDefinitionIdText.setEnabled(false);
            this.setTitleImage(this.getHeaderTitleImage());
            this.headerForm.getForm().getForm().setImage(this.getHeaderTitleImage());
        }
    }
}

