/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public abstract class AbstractEditorInput
implements IEditorInput {
    private ITeamRepository fTeamRepository;
    protected IProjectAreaHandle fProjectArea;
    protected boolean fIsNewSystemDefinition = true;
    private AbstractEnterpriseExtensionsNode fNode;
    private boolean isLatest = true;

    public boolean isLatest() {
        return this.isLatest;
    }

    public void setLatest(boolean isLatest) {
        this.isLatest = isLatest;
    }

    public abstract String getEditorId();

    public abstract ISystemDefinition getSystemDefinition();

    public abstract void initializeEditorInput(ISystemDefinition var1);

    public AbstractEditorInput(ISystemDefinition systemDefinition, IProjectAreaHandle projectArea) throws TeamRepositoryException {
        this(systemDefinition, projectArea, null);
    }

    public AbstractEditorInput(ISystemDefinition systemDefinition, IProjectAreaHandle projectArea, AbstractEnterpriseExtensionsNode node) throws TeamRepositoryException {
        if (projectArea != null) {
            this.fTeamRepository = (ITeamRepository)projectArea.getOrigin();
            if (!(projectArea instanceof IProjectArea) && this.fTeamRepository != null) {
                this.fProjectArea = (IProjectArea)this.fTeamRepository.itemManager().fetchPartialItem((IItemHandle)projectArea, 1, Arrays.asList("name"), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        this.fProjectArea = projectArea;
        this.fNode = node;
        this.initializeEditorInput(systemDefinition);
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public boolean exists() {
        return true;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public AbstractEnterpriseExtensionsNode getNode() {
        return this.fNode;
    }

    public String getName() {
        String partName = this.getSystemDefinition().getName();
        return partName != null ? partName : "";
    }

    public String getToolTipText() {
        String tooltipText = this.getSystemDefinition().getName();
        return tooltipText != null ? tooltipText : "";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractEditorInput)) {
            return false;
        }
        AbstractEditorInput input = (AbstractEditorInput)obj;
        if (this.getSystemDefinition().sameItemId((IItemHandle)input.getSystemDefinition())) {
            if (this.getSystemDefinition().getStateId() != null && input.getSystemDefinition().getStateId() != null) {
                return this.getSystemDefinition().getStateId().equals((Object)input.getSystemDefinition().getStateId());
            }
            if (this.getSystemDefinition().getStateId() == null && input.isLatest) {
                return true;
            }
            return (this.getSystemDefinition().getStateId() != null || input.getSystemDefinition().getStateId() == null) && (this.getSystemDefinition().getStateId() == null || input.getSystemDefinition().getStateId() != null);
        }
        return false;
    }

    public int hashCode() {
        String hashCodeString = String.valueOf(this.getSystemDefinition().getItemId().getUuidValue()) + (this.getSystemDefinition().getStateId() != null ? this.getSystemDefinition().getStateId().getUuidValue() : "");
        return hashCodeString.hashCode();
    }

    public boolean isNewSystemDefinition() {
        return this.fIsNewSystemDefinition;
    }

    public void markSystemDefinitionSaved() {
        if (this.fIsNewSystemDefinition) {
            this.fIsNewSystemDefinition = false;
        }
    }
}

