/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.editors;

import com.ibm.team.enterprise.common.ui.editors.AbstractMessageFormEditor;
import com.ibm.team.enterprise.systemdefinition.ui.editors.actions.RefreshEditorAction;
import com.ibm.team.enterprise.systemdefinition.ui.editors.actions.SaveEditorAction;
import com.ibm.team.enterprise.systemdefinition.ui.util.HeaderMessageHyperlinkListener;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;

public abstract class AbstractActionFormEditor
extends AbstractMessageFormEditor {
    private SaveEditorAction fSaveAction;
    protected RefreshEditorAction fRefreshAction;
    protected int fBusyCount;
    protected boolean fIsDisposed = false;
    protected boolean fSaveAttempted;

    public abstract boolean isNewItem();

    protected abstract String getHeaderTitleText();

    protected abstract Image getHeaderTitleImage();

    public abstract void refreshSystemDefinition();

    public abstract String getSystemDefinitionTypeName();

    protected abstract HeaderMessageHyperlinkListener getMessageHyperlinkListener();

    protected abstract IFormPage[] getPages();

    protected void createHeaderContents(IManagedForm headerForm) {
        Form form = headerForm.getForm().getForm();
        form.setText(this.getHeaderTitleText());
        form.setImage(this.getHeaderTitleImage());
        IToolBarManager toolBarManager = form.getToolBarManager();
        this.fRefreshAction = new RefreshEditorAction(this, form.getShell());
        if (this.isNewItem()) {
            this.fRefreshAction.setEnabled(false);
        }
        toolBarManager.add((IAction)this.fRefreshAction);
        this.fSaveAction = new SaveEditorAction(this);
        toolBarManager.add((IContributionItem)this.fSaveAction);
        this.updateToolBar(form);
        this.addPropertyListener(new DirtyPropertyListener());
        this.fMessageManager = headerForm.getMessageManager();
        this.fMessageManager.setDecorationPosition(16512);
        form.addMessageHyperlinkListener((IHyperlinkListener)this.getMessageHyperlinkListener());
    }

    protected RefreshEditorAction getRefreshEditorAction() {
        return this.fRefreshAction;
    }

    protected SaveEditorAction getSaveEditorAction() {
        return this.fSaveAction;
    }

    protected void updateToolBar(Form form) {
        form.updateToolBar();
    }

    protected abstract void disposeEditorSections();

    public void internalHandleRefreshComplete(IStatus refreshStatus) {
        if (refreshStatus.isOK()) {
            this.disposeEditorSections();
            this.handleRefreshComplete();
        }
    }

    protected abstract void handleRefreshComplete();

    public void setBusy(boolean isBusy) {
        if (!this.isDisposed()) {
            if (this.fBusyCount == 0 && isBusy) {
                this.getHeaderForm().getForm().setBusy(true);
            } else if (this.fBusyCount == 1 && !isBusy) {
                this.getHeaderForm().getForm().setBusy(false);
            }
            if (isBusy) {
                ++this.fBusyCount;
            } else if (this.fBusyCount > 0) {
                --this.fBusyCount;
            }
        }
        this.getSaveEditorAction().updateEnabledState();
        this.getRefreshEditorAction().updateEnabledState();
    }

    public boolean isBusy() {
        return this.fBusyCount > 0;
    }

    protected abstract void performSave(IProgressMonitor var1) throws TeamRepositoryException, OperationCanceledException;

    protected void invokeSaveRunnable(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.getSite().getWorkbenchWindow().run(true, true, runnable);
    }

    protected boolean preSave() {
        return true;
    }

    protected void postSave(boolean saveSucceeded) {
    }

    protected IRunnableWithProgress createSaveItemRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    AbstractActionFormEditor.this.performSave(monitor);
                }
                catch (TeamRepositoryException exception) {
                    throw new InvocationTargetException(exception);
                }
            }
        };
    }

    protected void handleSaveJobFinished(IStatus status) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    protected void addPages() {
    }

    public boolean isDisposed() {
        return this.fIsDisposed;
    }

    public abstract void setDirty(boolean var1);

    public void fireDirtyPropertyChangeEvent() {
        this.firePropertyChange(257);
    }

    public boolean isSaveAttempted() {
        return this.fSaveAttempted;
    }

    protected class DirtyPropertyListener
    implements IPropertyListener {
        protected DirtyPropertyListener() {
        }

        public void propertyChanged(Object source, int propertyId) {
            if (source instanceof IEditorPart && propertyId == 257) {
                AbstractActionFormEditor.this.getSaveEditorAction().updateEnabledState();
            }
        }
    }
}

