/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.domain;

import com.ibm.team.enterprise.common.ui.IMenuAction;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainActionHelper;
import com.ibm.team.enterprise.systemdefinition.ui.ActionsContributionsRegistry;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractSystemDefDomainActionHelper
extends EnterpriseExtensionsDomainActionHelper {
    private final IMenuManager fMenuManager;
    protected IStructuredSelection fSelection;
    protected IWorkbenchPartSite fPartSite;

    public AbstractSystemDefDomainActionHelper(IMenuManager manager, IStructuredSelection selection, IWorkbenchPartSite site) {
        super(manager, selection, site);
        this.fMenuManager = manager;
        this.fSelection = selection;
        this.fPartSite = site;
    }

    public void contributeActions() {
        super.contributeActions();
        if (this.fSelection.isEmpty()) {
            return;
        }
        Object element = this.fSelection.getFirstElement();
        if (this.fSelection.size() == 1 && element instanceof AbstractEnterpriseExtensionsNode) {
            this.contributeSystemDefinitionsNodeActions((AbstractEnterpriseExtensionsNode)element);
            this.addContributedActions(element);
        }
    }

    private void addContributedActions(Object element) {
        String id = ((AbstractEnterpriseExtensionsNode)element).getId();
        ActionsContributionsRegistry registry = ActionsContributionsRegistry.singleton;
        List<IConfigurationElement> contributions = registry.getContributionsFor(id);
        for (IConfigurationElement configurationElement : contributions) {
            IMenuAction action = registry.getAction(configurationElement);
            action.setPartSite(this.fPartSite);
            if (configurationElement.getAttribute("group").compareTo("NEW") == 0) {
                this.fMenuManager.appendToGroup("jazz.new.group", (IAction)action);
                continue;
            }
            if (configurationElement.getAttribute("group").compareTo("OPEN") == 0) {
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)action);
                continue;
            }
            if (configurationElement.getAttribute("group").compareTo("REFACTORING") == 0) {
                this.fMenuManager.appendToGroup("jazz.refactoring.group", (IAction)action);
                continue;
            }
            if (configurationElement.getAttribute("group").compareTo("PROPERTIES") == 0) {
                this.fMenuManager.appendToGroup("jazz.properties.group", (IAction)action);
                continue;
            }
            if (configurationElement.getAttribute("group").compareTo("ADDITIONS") == 0) {
                this.fMenuManager.appendToGroup("additions", (IAction)action);
                continue;
            }
            if (configurationElement.getAttribute("group").compareTo("NAVIGATE") == 0) {
                this.fMenuManager.appendToGroup("jazz.navigate.group", (IAction)action);
                continue;
            }
            if (configurationElement.getAttribute("group").compareTo("COMPARE") != 0) continue;
            this.fMenuManager.appendToGroup("jazz.compare.group", (IAction)action);
        }
    }

    private void contributeSystemDefinitionsNodeActions(AbstractEnterpriseExtensionsNode node) {
        Object category = node.getDomainSubtreeRoot().getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        if (node.hasChildren()) {
            this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getNewSystemDefinitionAction(projectAreaHandle, node));
        } else {
            this.fMenuManager.appendToGroup("jazz.refactoring.group", (IAction)this.getDuplicateSystemDefinitionAction(projectAreaHandle, node));
            if (this.archivingIsActive()) {
                Action restoreAction;
                Action archiveAction = this.getArchiveSystemDefinitionAction(projectAreaHandle, node);
                if (archiveAction != null) {
                    this.fMenuManager.appendToGroup("jazz.refactoring.group", (IAction)archiveAction);
                }
                if ((restoreAction = this.getRestoreSystemDefinitionAction(projectAreaHandle, node)) != null) {
                    this.fMenuManager.appendToGroup("jazz.refactoring.group", (IAction)restoreAction);
                }
            }
        }
    }

    private boolean archivingIsActive() {
        if (this.fSelection.size() > 0) {
            Class<?> objectClass = this.fSelection.getFirstElement().getClass();
            for (Object object : this.fSelection) {
                if (object.getClass().equals(objectClass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract Action getNewSystemDefinitionAction(IProjectAreaHandle var1, AbstractEnterpriseExtensionsNode var2);

    protected abstract Action getDuplicateSystemDefinitionAction(IProjectAreaHandle var1, AbstractEnterpriseExtensionsNode var2);

    protected abstract Action getArchiveSystemDefinitionAction(IProjectAreaHandle var1, AbstractEnterpriseExtensionsNode var2);

    protected abstract Action getRestoreSystemDefinitionAction(IProjectAreaHandle var1, AbstractEnterpriseExtensionsNode var2);
}

