/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.common.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.helper.ValidationHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.ui.IModeledTranslatorEntryContext;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.TranslatorSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.enterprise.systemdefinition.ui.helper.ConditionValidator;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TranslatorEntryDialog
extends TitleAreaDialog {
    protected String fTitle;
    protected Text fTranslatorText;
    protected Text fPropertyText;
    protected Text fConditionalText;
    protected Text fStepNameText;
    private Button fBrowseButton;
    protected Button fTranslatorEntryKindButtonTranslator;
    protected Button fTranslatorEntryKindButtonProperty;
    protected com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry fTranslatorEntry;
    protected ITeamRepository fTeamRepository;
    protected IProjectAreaHandle fProjectArea;
    protected boolean fIsNew;
    protected Shell fParentShell;
    protected Composite fComposite;
    protected IItemType fTranslatorType;
    private String fTranslatorEntryName;
    private final Map<String, String> fTranslatorCache;

    public TranslatorEntryDialog(Shell parentShell, String title, com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry translatorEntry, boolean isNew, IItemType translatorType, ITeamRepository repo, IProjectAreaHandle projectArea, Map<String, String> existingTranslators) {
        super(parentShell);
        ValidationHelper.validateNotNull((String)"title", (Object)title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fParentShell = parentShell;
        this.fTranslatorEntry = ModelFactory.eINSTANCE.createTranslatorEntry();
        this.fTranslatorEntry.setKind(translatorEntry.getKind());
        this.fTranslatorEntry.setValue(translatorEntry.getValue());
        this.fTranslatorEntry.setCondition(translatorEntry.getCondition());
        this.fTranslatorEntry.setStepName(translatorEntry.getStepName());
        this.fIsNew = isNew;
        this.fTeamRepository = repo;
        this.fProjectArea = projectArea;
        this.fTranslatorType = translatorType;
        this.fTranslatorCache = existingTranslators;
    }

    protected void validate(boolean suppressErrorMessage) {
        MappingValidation fValidator;
        String stepName;
        String con;
        String value;
        String errorMessage = null;
        String warningMessage = null;
        if (this.fTranslatorEntryKindButtonTranslator.getSelection()) {
            value = this.fTranslatorText.getText().trim();
            if (value == null || value.equals("")) {
                errorMessage = Messages.TranslatorEntryDialog_TRANSLATOR_REQUIRED;
            }
        } else if (this.fTranslatorEntryKindButtonProperty.getSelection()) {
            value = this.fPropertyText.getText().trim();
            if (value == null || value.equals("")) {
                errorMessage = Messages.TranslatorEntryDialog_PROPERTY_REQUIRED;
            } else if (value.indexOf(32) > -1) {
                errorMessage = Messages.Common_NO_SPACES_IN_BUILD_PROPERTY;
            } else if (!AbstractSystemDefinitionEditor.isValidBuildProperty(value)) {
                errorMessage = Messages.Common_INVALID_BUILD_PROPERTY_NAME;
            }
        }
        if ((con = this.fConditionalText.getText()) != null && !con.isEmpty()) {
            IStatus error = ConditionValidator.validate(con);
            if (error != null && error.matches(4)) {
                errorMessage = error.getMessage();
            } else if (error != null && error.matches(2)) {
                warningMessage = error.getMessage();
            }
        }
        if ((stepName = this.fStepNameText.getText().trim()) != null && !stepName.isEmpty() && (fValidator = new MappingValidation()).isValidDSName(stepName) != 0) {
            errorMessage = Messages.Translator_INVALID_STEP_NAME;
        }
        if (suppressErrorMessage) {
            this.setMessage(Messages.TranslatorEntryDialog_HEADER);
            this.setErrorMessage(null);
        } else if (errorMessage == null) {
            this.setErrorMessage(null);
            if (warningMessage != null) {
                this.setMessage(warningMessage, 2);
            } else {
                this.setMessage(Messages.TranslatorEntryDialog_HEADER);
            }
        } else {
            this.setErrorMessage(errorMessage);
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled((this.fTranslatorEntryKindButtonTranslator.getSelection() || this.fTranslatorEntryKindButtonProperty.getSelection()) && errorMessage == null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        int nbGridCols = 2;
        GridData gridData = null;
        this.fComposite = new Composite(dialogAreaComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fComposite);
        this.fComposite.setLayout((Layout)new GridLayout(nbGridCols, false));
        this.setTitle(this.fTitle);
        this.setMessage(Messages.TranslatorEntryDialog_HEADER);
        this.fTranslatorEntryKindButtonTranslator = this.createKindRadioButton(this.fComposite, Messages.TranslatorEntryDialog_KIND_DATA_DEF, 16400);
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = nbGridCols;
        this.fTranslatorEntryKindButtonTranslator.setLayoutData((Object)gridData);
        this.fTranslatorText = new Text(this.fComposite, 2052);
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = nbGridCols - 1;
        this.fTranslatorText.setLayoutData((Object)gridData);
        this.fTranslatorText.setEditable(false);
        this.fBrowseButton = new Button(this.fComposite, 0x1000008);
        this.fBrowseButton.setText(Messages.TranslatorEntryDialog_BROWSE_BUTTON_WITH_ELLIPSIS);
        this.fBrowseButton.addSelectionListener(this.getBrowseButtonSelectionListener());
        this.fBrowseButton.setEnabled(false);
        gridData = new GridData(4, 1, false, false);
        this.fBrowseButton.setLayoutData((Object)gridData);
        this.fTranslatorEntryKindButtonProperty = this.createKindRadioButton(this.fComposite, Messages.TranslatorEntryDialog_KIND_SUB_PARAM, 16400);
        gridData = new GridData(4, 1, true, false);
        this.fTranslatorEntryKindButtonProperty.setLayoutData((Object)gridData);
        this.fPropertyText = new Text(this.fComposite, 2052);
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = nbGridCols;
        this.fPropertyText.setLayoutData((Object)gridData);
        this.fPropertyText.setEnabled(false);
        this.fPropertyText.setEditable(false);
        this.updateEntryKindRadioButtonValues();
        this.fPropertyText.addModifyListener(this.getPropertyModifiedListener());
        Label conditionalLabel = new Label(this.fComposite, 0);
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = nbGridCols;
        conditionalLabel.setText(Messages.TranslatorEntryDialog_CONDITION);
        conditionalLabel.setLayoutData((Object)gridData);
        this.fConditionalText = new Text(this.fComposite, 2818);
        gridData = new GridData(1808);
        gridData.horizontalSpan = nbGridCols;
        gridData.heightHint = gridData.minimumHeight = this.fConditionalText.getLineHeight() * 5;
        gridData.grabExcessVerticalSpace = true;
        this.fConditionalText.setLayoutData((Object)gridData);
        this.updateCondition();
        this.fConditionalText.addModifyListener(this.getConditionModifiedListener());
        Label conditionalInfo = new Label(this.fComposite, 64);
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = nbGridCols;
        gridData.widthHint = 100;
        conditionalInfo.setText(Messages.Common_CONDITION_INFORMATIONAL);
        conditionalInfo.setForeground(Display.getCurrent().getSystemColor(16));
        conditionalInfo.setLayoutData((Object)gridData);
        Label stepNameLabel = new Label(this.fComposite, 0);
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = nbGridCols;
        stepNameLabel.setText(Messages.TranslatorEntryDialog_STEPNAME);
        stepNameLabel.setLayoutData((Object)gridData);
        this.fStepNameText = new Text(this.fComposite, 2052);
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = nbGridCols;
        this.fStepNameText.setTextLimit(8);
        this.fStepNameText.setLayoutData((Object)gridData);
        this.updateStepName();
        this.fStepNameText.addModifyListener(this.getStepNameModifiedListener());
        TranslatorEntryDialog.applyDialogFont((Control)this.fComposite);
        if (this.fTranslatorEntryKindButtonTranslator.getSelection()) {
            this.fBrowseButton.setFocus();
        } else if (this.fTranslatorEntryKindButtonProperty.getSelection()) {
            this.fPropertyText.setFocus();
            this.fPropertyText.selectAll();
        } else {
            this.fTranslatorEntryKindButtonTranslator.setFocus();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.enterprise.systemdefinition.ui.dialog_translator_selection");
        return this.fComposite;
    }

    private Button createKindRadioButton(Composite parent, String text, int style) {
        Button radioButton = new Button(parent, style);
        radioButton.setText(text);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorEntryDialog.this.handleKindUpdate();
            }
        });
        return radioButton;
    }

    protected void handleKindUpdate() {
        if (this.fTranslatorEntryKindButtonTranslator.getSelection()) {
            this.fTranslatorEntry.setKind("com.ibm.team.enterprise.systemdefinition.entry.translator");
            this.fTranslatorEntry.setValue("");
        } else if (this.fTranslatorEntryKindButtonProperty.getSelection()) {
            this.fTranslatorEntry.setKind("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable");
            this.fTranslatorEntry.setValue("");
        }
        this.updateEntryKindEnablement();
        this.validate(false);
    }

    protected void updateEntryKindRadioButtonValues() {
        this.updateEntryKindEnablement();
        if (this.fTranslatorEntry.getKind() == null || this.fTranslatorEntry.getKind().equals("")) {
            return;
        }
        if (this.fTranslatorEntry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.translator")) {
            this.fTranslatorEntryKindButtonTranslator.setSelection(true);
            String value = this.fTranslatorEntry.getValue();
            if (value != null && !value.equals("")) {
                value = this.fTranslatorCache.get(value);
                if (!this.fTranslatorText.isDisposed()) {
                    this.fTranslatorText.setText(value);
                    this.fTranslatorEntryName = value;
                }
            }
        } else if (this.fTranslatorEntry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
            this.fTranslatorEntryKindButtonProperty.setSelection(true);
            this.fPropertyText.setText(this.fTranslatorEntry.getValue() == null ? "" : this.fTranslatorEntry.getValue());
        }
    }

    protected void updateCondition() {
        String text = "";
        if (this.fTranslatorEntry.getCondition() != null) {
            text = this.fTranslatorEntry.getCondition();
        }
        this.fConditionalText.setText(text);
    }

    protected void updateStepName() {
        String text = "";
        if (this.fTranslatorEntry.getStepName() != null) {
            text = this.fTranslatorEntry.getStepName();
        }
        this.fStepNameText.setText(text);
    }

    protected void updateEntryKindEnablement() {
        if (this.fTranslatorEntry.getKind() == null || this.fTranslatorEntry.getKind().equals("")) {
            this.fBrowseButton.setEnabled(false);
            this.fPropertyText.setEnabled(false);
            this.fPropertyText.setEditable(false);
            this.fPropertyText.setText("");
            this.fTranslatorText.setText("");
            this.fTranslatorEntryName = "";
        } else if (this.fTranslatorEntry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.translator")) {
            this.fBrowseButton.setEnabled(true);
            this.fPropertyText.setEnabled(false);
            this.fPropertyText.setEditable(false);
            this.fPropertyText.setText("");
        } else if (this.fTranslatorEntry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
            this.fPropertyText.setEnabled(true);
            this.fPropertyText.setEditable(true);
            this.fBrowseButton.setEnabled(false);
            this.fTranslatorText.setText("");
            this.fTranslatorEntryName = "";
        }
    }

    private ModifyListener getPropertyModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TranslatorEntryDialog.this.validate(false);
                if (TranslatorEntryDialog.this.fTranslatorEntry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
                    TranslatorEntryDialog.this.fTranslatorEntry.setValue(TranslatorEntryDialog.this.fPropertyText.getText().trim());
                }
            }
        };
    }

    private ModifyListener getConditionModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TranslatorEntryDialog.this.validate(false);
                TranslatorEntryDialog.this.fTranslatorEntry.setCondition(TranslatorEntryDialog.this.fConditionalText.getText().trim());
            }
        };
    }

    private ModifyListener getStepNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TranslatorEntryDialog.this.validate(false);
                TranslatorEntryDialog.this.fTranslatorEntry.setStepName(TranslatorEntryDialog.this.fStepNameText.getText().trim());
            }
        };
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    public void create() {
        super.create();
        this.validate(true);
    }

    private SelectionListener getBrowseButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorEntryDialog.this.editTranslator();
                TranslatorEntryDialog.this.validate(false);
            }
        };
    }

    private void editTranslator() {
        try {
            ISystemDefinition translator;
            TranslatorSelectionDialog dialog = new TranslatorSelectionDialog(this.fComposite.getShell(), this.fTeamRepository, null, this.fTranslatorType);
            if (dialog.open() == 0 && (translator = dialog.getSelectedSystemDefinition()) != null) {
                this.fTranslatorEntry.setValue(translator.getItemId().getUuidValue());
                this.fTranslatorText.setText(translator.getName());
                this.fTranslatorEntryName = translator.getName();
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    protected IModeledTranslatorEntryContext getTranslatorEntryContext(final com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry entry) {
        return new IModeledTranslatorEntryContext(){

            @Override
            public com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry getModeledTranslatorEntry() {
                return entry;
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return TranslatorEntryDialog.this.fTeamRepository;
            }

            @Override
            public IProjectAreaHandle getProjectArea() {
                return TranslatorEntryDialog.this.fProjectArea;
            }

            @Override
            public ITranslatorEntry getTranslatorEntry() {
                return null;
            }
        };
    }

    public String getTranslatorEntryKind() {
        return this.fTranslatorEntry.getKind();
    }

    public String getTranslatorEntryValue() {
        return this.fTranslatorEntry.getValue();
    }

    public String getTranslatorEntryName() {
        return this.fTranslatorEntryName;
    }

    public String getTranslatorEntryCondition() {
        return this.fTranslatorEntry.getCondition();
    }

    public String getTranslatorEntryStepName() {
        return this.fTranslatorEntry.getStepName();
    }
}

