/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.DefaultLabelProvider;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.FilteredSystemDefinitionTree;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionDeferredContentProvider;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionErrorNode;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class SystemDefinitionSelectionDialog
extends ElementTreeSelectionDialog {
    private IStatus ERROR_STATUS;
    private IStatus OK_STATUS;
    protected final ITeamRepository repository;
    protected final ViewerFilter filter;
    protected final IItemType type;
    protected Text descriptionText;
    protected FilteredSystemDefinitionTree tree;

    public SystemDefinitionSelectionDialog(Shell parent, ITeamRepository repository, IItemType type) {
        this(parent, repository, type, false);
    }

    public SystemDefinitionSelectionDialog(Shell parent, ITeamRepository repository, IItemType type, boolean doFullResolution) {
        this(parent, repository, null, type, null, false, new DefaultLabelProvider(), new SystemDefinitionDeferredContentProvider(repository, type, doFullResolution));
    }

    public SystemDefinitionSelectionDialog(Shell parent, ITeamRepository repository, IItemType type, ViewerFilter filter, String[] propertiesToFetch) {
        this(parent, repository, null, type, filter, false, new DefaultLabelProvider(), new SystemDefinitionDeferredContentProvider(repository, type, propertiesToFetch));
    }

    public SystemDefinitionSelectionDialog(Shell parent, ITeamRepository repository, IProjectAreaHandle projectArea, IItemType type, ViewerFilter filter, boolean allowMultipleSelection, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.repository = repository;
        this.type = type;
        this.filter = filter;
        this.setTitleMessage(type);
        this.setAllowMultiple(allowMultipleSelection);
        this.setValidator(this.getSelectionValidator());
        if (projectArea != null) {
            this.setInput(projectArea);
        } else {
            this.setInput(repository);
        }
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        this.tree = new FilteredSystemDefinitionTree(parent, style | 0x10000000, false, this.filter);
        this.tree.setLayoutData(new GridData(1808));
        SystemDefinitionSelectionDialog.applyDialogFont((Control)this.tree);
        if (this.filter != null) {
            this.tree.getViewer().addFilter(this.filter);
        }
        return this.tree.getViewer();
    }

    protected ISelectionStatusValidator getSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IStatus status = null;
                if (selection == null || selection.length == 0 || !(selection[0] instanceof ISystemDefinitionHandle) && !(selection[0] instanceof ISystemDefinition)) {
                    if (SystemDefinitionSelectionDialog.this.ERROR_STATUS == null) {
                        SystemDefinitionSelectionDialog.this.ERROR_STATUS = (IStatus)new Status(4, "com.ibm.team.enterprise.systemdefinition.ui", "");
                    }
                    status = SystemDefinitionSelectionDialog.this.ERROR_STATUS;
                }
                if (status == null) {
                    if (SystemDefinitionSelectionDialog.this.OK_STATUS == null) {
                        SystemDefinitionSelectionDialog.this.OK_STATUS = (IStatus)new Status(0, "com.ibm.team.enterprise.systemdefinition.ui", "");
                    }
                    status = SystemDefinitionSelectionDialog.this.OK_STATUS;
                }
                SystemDefinitionSelectionDialog.this.updateDescription(selection, status);
                return status;
            }
        };
    }

    protected void setTitleMessage(IItemType type) {
        if (SystemDefinitionUtil.isTypeOf((IItemType)type, (IItemType)ILanguageDefinition.ITEM_TYPE)) {
            this.setTitle(Messages.SystemDefinitionSelectionDialog_LANGUAGE_DEFINITION_DIALOG_LABEL);
            this.setMessage(Messages.SystemDefinitionSelectionDialog_LANGUAGE_DEFINITION_DIALOG_DESC);
        } else if (SystemDefinitionUtil.isTypeOf((IItemType)type, (IItemType)ITranslator.ITEM_TYPE)) {
            this.setTitle(Messages.SystemDefinitionSelectionDialog_TRANSLATOR_DIALOG_LABEL);
            this.setMessage(Messages.SystemDefinitionSelectionDialog_TRANSLATOR_DIALOG_DESC);
        } else if (SystemDefinitionUtil.isTypeOf((IItemType)type, (IItemType)IResourceDefinition.ITEM_TYPE)) {
            this.setTitle(Messages.SystemDefinitionSelectionDialog_RESOURCE_DEFINITION_DIALOG_LABEL);
            this.setMessage(Messages.SystemDefinitionSelectionDialog_RESOURCE_DEFINITION_DIALOG_DESC);
        } else if (SystemDefinitionUtil.isTypeOf((IItemType)type, (IItemType)ISearchPath.ITEM_TYPE)) {
            this.setTitle(Messages.SystemDefinitionSelectionDialog_SEARCH_PATH_DIALOG_LABEL);
            this.setMessage(Messages.SystemDefinitionSelectionDialog_SEARCH_PATH_DIALOG_DESC);
        } else if (SystemDefinitionUtil.isTypeOf((IItemType)type, (IItemType)IFunctionDefinition.ITEM_TYPE)) {
            this.setTitle(Messages.SystemDefinitionSelectionDialog2_FUNCTION_DEFINITION_DIALOG_LABEL);
            this.setMessage(Messages.SystemDefinitionSelectionDialog2_FUNCTION_DEFINITION_DIALOG_DESC);
        } else if (SystemDefinitionUtil.isTypeOf((IItemType)type, (IItemType)IVersionDefinition.ITEM_TYPE)) {
            this.setTitle(Messages.SystemDefinitionSelectionDialog2_VERSION_DEFINITION_DIALOG_LABEL);
            this.setMessage(Messages.SystemDefinitionSelectionDialog2_VERSION_DEFINITION_DIALOG_DESC);
        } else {
            this.setTitle(Messages.SystemDefinitionSelectionDialog_SYSTEM_DEFINITION_DIALOG_LABEL);
            this.setMessage(Messages.SystemDefinitionSelectionDialog_SYSTEM_DEFINITION_DIALOG_DESC);
        }
    }

    protected void updateDescription(Object[] selection, IStatus status) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        if (selection == null || selection.length == 0) {
            this.descriptionText.setText("");
            return;
        }
        if (selection[0] instanceof SystemDefinitionErrorNode) {
            this.descriptionText.setText(((SystemDefinitionErrorNode)selection[0]).getDescription());
            return;
        }
        if (selection.length > 1) {
            this.descriptionText.setText(Messages.SystemDefinitionSelectionDialog2_MULTIPLE_SELECTED);
            return;
        }
        if (!status.isOK()) {
            this.descriptionText.setText("");
            return;
        }
        if (selection[0] instanceof ISystemDefinition) {
            String desc = ((ISystemDefinition)selection[0]).getDescription();
            if (desc == null || desc.trim().isEmpty()) {
                desc = Messages.SystemDefinitionSelectionDialog2_NO_DESCRIPTION;
            }
            this.descriptionText.setText(desc);
            return;
        }
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        GridData data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        return label;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.getContextHelpId() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createAdditionalDialogContents(composite);
        return composite;
    }

    protected void createAdditionalDialogContents(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.SystemDefinitionSelectionDialog2_DESCRIPTION_LABEL);
        this.descriptionText = new Text(composite, 2634);
        GridData data = new GridData(768);
        data.heightHint = this.descriptionText.getLineHeight() * 2;
        this.descriptionText.setLayoutData((Object)data);
        new TooltipSupport((Control)this.descriptionText, false, false){

            protected String getMarkup(Object element, boolean isFocus) {
                return XMLString.createFromPlainText((String)SystemDefinitionSelectionDialog.this.descriptionText.getText()).getXMLText();
            }

            public Object getElement(Control control, int x, int y) {
                return SystemDefinitionSelectionDialog.this.descriptionText;
            }
        };
    }

    protected String getContextHelpId() {
        return null;
    }

    public ISystemDefinition getSelectedSystemDefinition() {
        Object rawResult = this.getFirstResult();
        if (rawResult instanceof ISystemDefinition) {
            return (ISystemDefinition)rawResult;
        }
        return null;
    }

    public String getSelectedSystemDefinitionName() {
        ISystemDefinition sysDef = this.getSelectedSystemDefinition();
        if (sysDef != null) {
            return sysDef.getName();
        }
        return null;
    }

    public String[] getSelectedSystemDefinitionNames() {
        Object[] defs = this.getSelectedSystemDefinitions();
        ArrayList<String> names = new ArrayList<String>(defs.length);
        Object[] objectArray = defs;
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ISystemDefinition) {
                names.add(((ISystemDefinition)o).getName());
            }
            ++n2;
        }
        return names.toArray(new String[names.size()]);
    }

    public Object[] getSelectedSystemDefinitions() {
        Object[] results = this.getResult();
        ArrayList<Object> handles = new ArrayList<Object>(results.length);
        Object[] objectArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            Object result = objectArray[n2];
            if (result instanceof ISystemDefinition) {
                handles.add(result);
            }
            ++n2;
        }
        return handles.toArray();
    }
}

