/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiSearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.util.SearchPathUtils;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.ResourceDefinitionTableContentProvider;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.ResourceDefinitionTableLabelProvider;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionDeferredContentProvider;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionLabelProvider;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class SearchPathSelectionDialog
extends SystemDefinitionSelectionDialog {
    private final Map<String, ISystemDefinition> fSysDefCache = new HashMap<String, ISystemDefinition>();
    private TableViewer fTableViewer;
    private Section fSection;

    public SearchPathSelectionDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea) throws TeamRepositoryException {
        this(parentShell, teamRepository, projectArea, null, false);
    }

    public SearchPathSelectionDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea, boolean allowMultipleSelection) throws TeamRepositoryException {
        this(parentShell, teamRepository, projectArea, null, allowMultipleSelection);
    }

    public SearchPathSelectionDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea, ViewerFilter filter) throws TeamRepositoryException {
        this(parentShell, teamRepository, projectArea, filter, false);
    }

    public SearchPathSelectionDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea, ViewerFilter filter, boolean allowMultipleSelection) throws TeamRepositoryException {
        super(parentShell, teamRepository, (IProjectAreaHandle)projectArea, IIBMiSearchPath.ITEM_TYPE, filter, allowMultipleSelection, (ILabelProvider)new SystemDefinitionLabelProvider(), new SystemDefinitionDeferredContentProvider(teamRepository, IIBMiSearchPath.ITEM_TYPE));
    }

    @Override
    protected void createAdditionalDialogContents(Composite composite) {
        this.createSearchPathPreviewSection(composite);
        this.addTreeSelectionChangedListener(this.getTreeViewer());
        super.createAdditionalDialogContents(composite);
    }

    private void createSearchPathPreviewSection(Composite parent) {
        this.fSection = new Section(parent, 2);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fSection);
        this.fSection.setExpanded(false);
        this.fSection.setText(Messages.SearchPathSelectionDialog_SearchPathSectionTitle);
        this.fSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent event) {
                SearchPathSelectionDialog.this.getShell().pack(true);
                if (SearchPathSelectionDialog.this.fSection.isExpanded()) {
                    SearchPathSelectionDialog.this.fetchResourceDefinitionsInBackground();
                }
            }
        });
        Composite fComposite = new Composite((Composite)this.fSection, 0);
        GridDataFactory.fillDefaults().applyTo((Control)fComposite);
        GridLayoutFactory.fillDefaults().applyTo(fComposite);
        this.fSection.setClient((Control)fComposite);
        Composite tableComposite = new Composite(fComposite, 0);
        Table table = new Table(tableComposite, 68354);
        GridDataFactory.fillDefaults().hint(200, table.getItemHeight() * 5).grab(true, true).span(1, 1).applyTo((Control)tableComposite);
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn column = new TableColumn(table, 0);
        column.setText(Messages.SearchPathSelectionDialog_ResourceDefColumnTitle);
        tableLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(10));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.SearchPathSelectionDialog_LibraryColumnTitle);
        tableLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(10));
        tableComposite.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setColumnProperties(new String[]{"resourceDefinition"});
        this.fTableViewer.setContentProvider((IContentProvider)new ResourceDefinitionTableContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ResourceDefinitionTableLabelProvider(this.fTableViewer, this.repository));
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.enterprise.systemdefinition.ui.dialog_searchpath_selection";
    }

    private void addTreeSelectionChangedListener(TreeViewer treeViewer) {
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SearchPathSelectionDialog.this.fSection.isExpanded()) {
                    SearchPathSelectionDialog.this.fetchResourceDefinitionsInBackground();
                }
            }
        });
    }

    private void fetchResourceDefinitionsInBackground() {
        if (this.fSection.isExpanded()) {
            SystemDefinitionJob job = new SystemDefinitionJob(Messages.SearchPathSelectionDialog_JobFetchingResourceDefinitions, false){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    ISearchPath searchPath = (ISearchPath)SearchPathSelectionDialog.this.getSelectedSystemDefinition();
                    if (searchPath != null) {
                        IResourceDefinition lib;
                        final ArrayList<IResourceDefinition> pending = new ArrayList<IResourceDefinition>();
                        IResourceDefinition dummy = (IResourceDefinition)IResourceDefinition.ITEM_TYPE.createItem();
                        dummy.setName(Messages.SearchPathSelectionDialog_Pending);
                        pending.add(dummy);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                SearchPathSelectionDialog.this.fTableViewer.setInput((Object)pending);
                            }
                        });
                        final ArrayList<IResourceDefinition> libraries = new ArrayList<IResourceDefinition>();
                        String objLibUuid = SearchPathUtils.getObjectLibraryUUID((ISearchPath)searchPath);
                        String srcLibUuid = SearchPathUtils.getSourceLibraryUUID((ISearchPath)searchPath);
                        List refLibs = SearchPathUtils.getReferencedLibrariesUUIDs((ISearchPath)searchPath, (boolean)false);
                        if (objLibUuid == null || objLibUuid.isEmpty()) {
                            IResourceDefinition objLib = (IResourceDefinition)IIBMiResourceDefinition.ITEM_TYPE.createItem();
                            objLib.setUsageType(0);
                            objLib.setName(Messages.SearchPathSelectionDialog_defaultObjectLibrary);
                            libraries.add(objLib);
                        } else {
                            lib = (IResourceDefinition)this.getSystemDefinition(objLibUuid, IIBMiResourceDefinition.ITEM_TYPE);
                            if (lib != null) {
                                libraries.add(lib);
                            }
                        }
                        if (srcLibUuid == null || srcLibUuid.isEmpty()) {
                            IResourceDefinition srcLib = (IResourceDefinition)IIBMiResourceDefinition.ITEM_TYPE.createItem();
                            srcLib.setUsageType(0);
                            srcLib.setName(Messages.SearchPathSelectionDialog_defaultSourceLibrary);
                            libraries.add(srcLib);
                        } else {
                            lib = (IResourceDefinition)this.getSystemDefinition(srcLibUuid, IIBMiResourceDefinition.ITEM_TYPE);
                            if (lib != null) {
                                libraries.add(lib);
                            }
                        }
                        for (String libraryUuid : refLibs) {
                            IResourceDefinition lib2 = (IResourceDefinition)this.getSystemDefinition(libraryUuid, IIBMiResourceDefinition.ITEM_TYPE);
                            if (lib2 == null) continue;
                            libraries.add(lib2);
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SearchPathSelectionDialog.this.fTableViewer.setInput((Object)libraries);
                            }
                        });
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SearchPathSelectionDialog.this.fTableViewer.setInput(null);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }

                private ISystemDefinition getSystemDefinition(String uuid, IItemType type) {
                    if (SearchPathSelectionDialog.this.fSysDefCache.containsKey(uuid)) {
                        return (ISystemDefinition)SearchPathSelectionDialog.this.fSysDefCache.get(uuid);
                    }
                    try {
                        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)SearchPathSelectionDialog.this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
                        ISystemDefinition sysdef = client.findSystemDefinitionComplete(uuid, null, type, null);
                        SearchPathSelectionDialog.this.fSysDefCache.put(uuid, sysdef);
                        return sysdef;
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                        return null;
                    }
                }

                @Override
                protected void jobFinished(IStatus status) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!SearchPathSelectionDialog.this.fTableViewer.getTable().isDisposed()) {
                                SearchPathSelectionDialog.this.fTableViewer.refresh();
                            }
                        }
                    });
                }
            };
            job.schedule();
        }
    }
}

