/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.common.model.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.enterprise.systemdefinition.ui.helper.ConditionValidator;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScopedPropertyDialog
extends TitleAreaDialog {
    protected String fTitle;
    protected IScopedProperty fProp;
    protected Composite fComposite;
    protected Text fNameText;
    protected Text fValueText;
    protected Text fConditionalText;
    protected List<IScopedProperty> fScopedProperties;
    private final boolean fIsNew;
    private String fOriginalName;

    public ScopedPropertyDialog(Shell parentShell, IScopedProperty prop, String title) {
        this(parentShell, prop, title, null);
    }

    public ScopedPropertyDialog(Shell parentShell, IScopedProperty prop, String title, List<IScopedProperty> scopedProperties) {
        super(parentShell);
        this.fProp = prop;
        boolean bl = this.fIsNew = prop == null || prop.getName() == null || prop.getName().isEmpty();
        if (!this.fIsNew) {
            this.fOriginalName = prop.getName();
        }
        this.fTitle = title;
        this.fScopedProperties = scopedProperties;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.fComposite = (Composite)super.createDialogArea(parent);
        this.fComposite.setLayout((Layout)new GridLayout(1, false));
        this.setTitle(this.fTitle);
        this.setMessage(Messages.ScopedPropertyDialog_HEADER);
        Label l = new Label(this.fComposite, 0);
        l.setText(Messages.ScopedPropertyDialog_NAME);
        GridData gridData = new GridData(768);
        l.setLayoutData((Object)gridData);
        this.fNameText = new Text(this.fComposite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fNameText.setLayoutData((Object)gridData);
        this.fNameText.setEditable(true);
        this.fNameText.setText(this.fProp.getName() == null ? "" : this.fProp.getName());
        this.fNameText.addModifyListener(this.getNameModifiedListener());
        l = new Label(this.fComposite, 0);
        l.setText(Messages.ScopedPropertyDialog_VALUE);
        gridData = new GridData(768);
        l.setLayoutData((Object)gridData);
        this.fValueText = new Text(this.fComposite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fValueText.setLayoutData((Object)gridData);
        this.fValueText.setEditable(true);
        this.fValueText.setText(this.fProp.getValue() == null ? "" : this.fProp.getValue());
        this.fValueText.addModifyListener(this.getValueModifiedListener());
        Label conditionalLabel = new Label(this.fComposite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        conditionalLabel.setText(Messages.ScopedPropertyDialog_CONDITION);
        conditionalLabel.setLayoutData((Object)gridData);
        this.fConditionalText = new Text(this.fComposite, 2818);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = this.fConditionalText.getLineHeight() * 5;
        gridData.grabExcessVerticalSpace = true;
        this.fConditionalText.setLayoutData((Object)gridData);
        this.fConditionalText.setText(this.fProp.getCondition() == null ? "" : this.fProp.getCondition());
        this.fConditionalText.addModifyListener(this.getConditionModifiedListener());
        Label conditionalInfo = new Label(this.fComposite, 64);
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 100;
        conditionalInfo.setText(Messages.Common_CONDITION_INFORMATIONAL);
        conditionalInfo.setForeground(Display.getCurrent().getSystemColor(16));
        conditionalInfo.setLayoutData((Object)gridData);
        ScopedPropertyDialog.applyDialogFont((Control)this.fComposite);
        return this.fComposite;
    }

    private ModifyListener getConditionModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScopedPropertyDialog.this.validate(false);
                ScopedPropertyDialog.this.fProp.setCondition(ScopedPropertyDialog.this.fConditionalText.getText().trim());
            }
        };
    }

    private ModifyListener getNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScopedPropertyDialog.this.validate(false);
                ScopedPropertyDialog.this.fProp.setName(ScopedPropertyDialog.this.fNameText.getText().trim());
            }
        };
    }

    private ModifyListener getValueModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScopedPropertyDialog.this.validate(false);
                ScopedPropertyDialog.this.fProp.setValue(ScopedPropertyDialog.this.fValueText.getText().trim());
            }
        };
    }

    public void create() {
        super.create();
        this.validate(true);
    }

    protected void validate(boolean suppressErrorMessage) {
        String con;
        String name;
        String errorMessage = null;
        String warningMessage = null;
        String value = this.fValueText.getText().trim();
        if (value != null && value.isEmpty()) {
            errorMessage = Messages.ScopedPropertyDialog_VALUE_REQUIRED;
        }
        if ((errorMessage = (name = this.fNameText.getText().trim()) != null && name.isEmpty() ? Messages.TranslatorEntryDialog_PROPERTY_REQUIRED : (name.indexOf(32) > -1 ? Messages.Common_NO_SPACES_IN_BUILD_PROPERTY : this.nameConflict(name))) == null && (con = this.fConditionalText.getText()) != null && !con.isEmpty()) {
            IStatus error = ConditionValidator.validate(con);
            if (error != null && error.matches(4)) {
                errorMessage = error.getMessage();
            } else if (error != null && error.matches(2)) {
                warningMessage = error.getMessage();
            }
        }
        if (suppressErrorMessage) {
            this.setMessage(Messages.ScopedPropertyDialog_HEADER);
            this.setErrorMessage(null);
        } else if (errorMessage == null) {
            this.setErrorMessage(null);
            if (warningMessage != null) {
                this.setMessage(warningMessage, 2);
            } else {
                this.setMessage(Messages.ScopedPropertyDialog_HEADER);
            }
        } else {
            this.setErrorMessage(errorMessage);
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled(errorMessage == null);
    }

    protected String nameConflict(String proposedName) {
        String message = null;
        if (this.fScopedProperties != null) {
            boolean alreadyMatchedSelf = false;
            for (IScopedProperty existingProperty : this.fScopedProperties) {
                boolean otherHasCondition;
                if (!existingProperty.getName().equals(proposedName)) continue;
                if (!this.fIsNew && proposedName.equals(this.fOriginalName) && !alreadyMatchedSelf) {
                    alreadyMatchedSelf = true;
                    continue;
                }
                boolean thisHasCondition = !this.fConditionalText.getText().trim().isEmpty();
                boolean bl = otherHasCondition = existingProperty.getCondition() != null && !existingProperty.getCondition().isEmpty();
                if (thisHasCondition && otherHasCondition) continue;
                if (!otherHasCondition) {
                    message = NLS.bind((String)Messages.ScopedPropertyDialog_NameAlreadyExists, (Object)AbstractSystemDefinitionEditor.escapeAmpersands(proposedName));
                    continue;
                }
                if (thisHasCondition) continue;
                message = NLS.bind((String)Messages.ScopedPropertyDialog_NameAlreadyExistsWithCondition, (Object)AbstractSystemDefinitionEditor.escapeAmpersands(proposedName));
            }
        }
        return message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }
}

