/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.elements.SystemDefinitionHandleDeferredContentProvider;
import com.ibm.team.enterprise.systemdefinition.ui.elements.VersionDefinitionLabelProvider;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PackagingVersionSelectionDialog
extends SystemDefinitionSelectionDialog {
    private final ITeamRepository repository;
    private final IProjectArea projectArea;

    public PackagingVersionSelectionDialog(Shell parent, ITeamRepository repository, IProjectArea projectArea) throws TeamRepositoryException {
        this(parent, repository, projectArea, null, null, null, false, null);
    }

    public PackagingVersionSelectionDialog(Shell parent, ITeamRepository repository, IProjectArea projectArea, ViewerFilter filter, String extraHelp) throws TeamRepositoryException {
        this(parent, repository, projectArea, filter, extraHelp, null, false, null);
    }

    public PackagingVersionSelectionDialog(Shell parent, ITeamRepository repository, IProjectArea projectArea, ViewerFilter filter, String extraHelp, List<Integer> usages, boolean fullResolution, ISystemDefinitionCache cache) throws TeamRepositoryException {
        super(parent, repository, (IProjectAreaHandle)projectArea, IVersionDefinition.ITEM_TYPE, filter, false, (ILabelProvider)new VersionDefinitionLabelProvider(), new SystemDefinitionHandleDeferredContentProvider(repository, ISystemDefinition.Platform.zos, IVersionDefinition.ITEM_TYPE, usages, fullResolution, cache));
        this.repository = repository;
        this.projectArea = projectArea;
        this.setHelpAvailable(false);
        this.setTitle(Messages.PackagingVersionSelectionDialog_Title);
        if (extraHelp != null) {
            String lineSeparator = System.getProperty("line.separator", "\r");
            this.setMessage(String.valueOf(Messages.PackagingVersionSelectionDialog_Description) + lineSeparator + lineSeparator + extraHelp);
        } else {
            this.setMessage(Messages.PackagingVersionSelectionDialog_Description);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        super.createButtonsForButtonBar(parent);
        Button refresh = new Button(parent, 0x800008);
        refresh.setImage(Activator.getImage("icons/gen/refresh.gif"));
        refresh.setToolTipText(Messages.PackagingVersionSelectionDialog_Tooltip_Refresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IContentProvider contentProvider = PackagingVersionSelectionDialog.this.getTreeViewer().getContentProvider();
                if (contentProvider instanceof SystemDefinitionHandleDeferredContentProvider) {
                    ItemCacheFactory.clearVersion((ITeamRepository)PackagingVersionSelectionDialog.this.repository, (IProjectAreaHandle)PackagingVersionSelectionDialog.this.projectArea);
                    ItemCacheFactory.clearVersionHandle((ITeamRepository)PackagingVersionSelectionDialog.this.repository, (IProjectAreaHandle)PackagingVersionSelectionDialog.this.projectArea);
                    ((SystemDefinitionHandleDeferredContentProvider)contentProvider).refresh();
                }
                PackagingVersionSelectionDialog.this.getTreeViewer().refresh();
            }
        });
    }

    @Override
    protected void setTitleMessage(IItemType type) {
    }

    public IVersionDefinition getSelectedDefinition() {
        return (IVersionDefinition)super.getSelectedSystemDefinition();
    }

    public List<?> getSelectedDefinitions() {
        return Arrays.asList(super.getSelectedSystemDefinitions());
    }
}

