/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionContext;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class LanguageDefinitionLabelHelper {
    public void labelAvailable(String label, String dataSetDefUUID) {
    }

    public void getLanguageDefinitionLabelInBackground(final ISystemDefinitionContext context) {
        SystemDefinitionJob job = new SystemDefinitionJob(Messages.LanguageDefinitionLabelHelper_JOB_LABEL, false){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                String langDefUuid;
                String label = langDefUuid = context.getSystemDefinitionUUID();
                if (langDefUuid.length() > 0) {
                    ISystemDefinitionModelClient langdefClient = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)context.getTeamRepository());
                    ILanguageDefinition langDef = (ILanguageDefinition)langdefClient.findSystemDefinition(langDefUuid, null, ILanguageDefinition.ITEM_TYPE, monitor);
                    label = langDef == null ? Messages.LabelHelper_ITEM_NOT_FOUND : langDef.getName();
                }
                LanguageDefinitionLabelHelper.this.asyncLabelAvailable(label, context.getSystemDefinitionUUID());
                return Status.OK_STATUS;
            }

            @Override
            protected void jobFinished(IStatus status) {
                if (status.getException() instanceof ItemNotFoundException) {
                    LanguageDefinitionLabelHelper.this.asyncLabelAvailable(Messages.LabelHelper_ITEM_NOT_FOUND, context.getSystemDefinitionUUID());
                } else if (status.getSeverity() == 4) {
                    LanguageDefinitionLabelHelper.this.asyncLabelAvailable(Messages.LabelHelper_EXCEPTION_OCCURRED, context.getSystemDefinitionUUID());
                }
            }
        };
        job.schedule();
    }

    protected void asyncLabelAvailable(final String label, final String langdefUUID) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LanguageDefinitionLabelHelper.this.labelAvailable(label, langdefUUID);
            }
        });
    }
}

