/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.common.ui.elements.DialogButtonItem;
import com.ibm.team.enterprise.common.ui.elements.DialogTextItem;
import com.ibm.team.enterprise.common.ui.util.GridTools;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterDataset;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.NarrowTitleAreaDialog;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.util.DatasetTools;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LanguageDatasetDialog
extends NarrowTitleAreaDialog {
    private static final int MinimumDialogW = 320;
    private static final int MinimumDialogH = 80;
    private static final int SWG_WIDTH_FIELD = 320;
    private static final int SWG_WIDTH_LABEL = 140;
    private static final String zFolderLabel = Messages.LanguageDataset_Dialog_Label_ZFolder;
    private static final String datasetLabel = Messages.LanguageDataset_Dialog_Label_Dataset;
    private static final String existingLabel = Messages.LanguageDataset_Dialog_Label_Existing;
    private final boolean zFolderSupported;
    private final IImporterDataset languageDataset;
    private final List<IImporterDataset> languageDatasets;
    private final Shell parentShell;
    private final String title;
    private final DialogTextItem dataset = new DialogTextItem();
    private final DialogButtonItem zFolder = new DialogButtonItem();
    private final DialogButtonItem existing = new DialogButtonItem();

    public LanguageDatasetDialog(Shell parentShell, IImporterDataset original, List<IImporterDataset> languageDatasets, String title) {
        this(parentShell, original, languageDatasets, title, true);
    }

    public LanguageDatasetDialog(Shell parentShell, IImporterDataset original, List<IImporterDataset> languageDatasets, String title, boolean zFolderSupported) {
        super(parentShell, 320, 80);
        this.parentShell = parentShell;
        this.languageDataset = original.copy(original);
        this.languageDatasets = languageDatasets.stream().filter(langDef -> !langDef.equals(original)).collect(Collectors.toList());
        this.title = title;
        this.zFolderSupported = zFolderSupported;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        FormToolkit toolkit = new FormToolkit(Display.getDefault());
        toolkit.setBackground(null);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.setTitle(this.title);
        if (this.zFolderSupported) {
            this.setMessage(Messages.LanguageDataset_Dialog_Title_Message);
        } else {
            this.setMessage(Messages.LanguageDataset_Dialog_Title_Message_NoZ);
        }
        Composite itemComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = 5;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 8;
        itemComposite.setLayout((Layout)gridLayout);
        itemComposite.setLayoutData((Object)new GridData(1808));
        this.dataset.create(itemComposite, datasetLabel, (Object)this.languageDataset.getDataset(), 140, 320);
        this.dataset.item.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String current = ((LanguageDatasetDialog)LanguageDatasetDialog.this).dataset.item.getText();
                event.text = DatasetTools.getFormattedName(String.valueOf(current) + event.text).substring(current.length());
            }
        });
        this.dataset.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                LanguageDatasetDialog.this.languageDataset.setDataset(((LanguageDatasetDialog)LanguageDatasetDialog.this).dataset.item.getText().trim());
                LanguageDatasetDialog.this.setItemMessage(((LanguageDatasetDialog)LanguageDatasetDialog.this).dataset.deco, null);
            }
        });
        this.dataset.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(LanguageDatasetDialog.this.parentShell, 36);
                helpDialog.setText(Messages.LanguageDataset_Dialog_HelpLbl_Dataset);
                helpDialog.setMessage(Messages.LanguageDataset_Dialog_HelpTxt_Dataset);
                helpDialog.open();
            }
        });
        if (this.zFolderSupported) {
            this.zFolder.create(itemComposite, zFolderLabel, (Object)this.languageDataset.iszFolder(), 140, 1);
            this.zFolder.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LanguageDatasetDialog.this.languageDataset.setzFolder(((LanguageDatasetDialog)LanguageDatasetDialog.this).zFolder.item.getSelection());
                    LanguageDatasetDialog.this.languageDataset.setExisting(!((LanguageDatasetDialog)LanguageDatasetDialog.this).zFolder.item.getSelection());
                    ((LanguageDatasetDialog)LanguageDatasetDialog.this).existing.item.setSelection(LanguageDatasetDialog.this.languageDataset.isExisting());
                    LanguageDatasetDialog.this.setItemMessage(((LanguageDatasetDialog)LanguageDatasetDialog.this).zFolder.deco, null);
                }
            });
            this.zFolder.item.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent event) {
                    MessageBox helpDialog = new MessageBox(LanguageDatasetDialog.this.parentShell, 36);
                    helpDialog.setText(Messages.LanguageDataset_Dialog_HelpLbl_ZFolder);
                    helpDialog.setMessage(Messages.LanguageDataset_Dialog_HelpTxt_ZFolder);
                    helpDialog.open();
                }
            });
            GridTools.createPlaceholder((Composite)itemComposite);
            this.existing.create(itemComposite, existingLabel, (Object)this.languageDataset.isExisting(), 140, 1);
            this.existing.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LanguageDatasetDialog.this.languageDataset.setzFolder(!((LanguageDatasetDialog)LanguageDatasetDialog.this).existing.item.getSelection());
                    LanguageDatasetDialog.this.languageDataset.setExisting(((LanguageDatasetDialog)LanguageDatasetDialog.this).existing.item.getSelection());
                    ((LanguageDatasetDialog)LanguageDatasetDialog.this).zFolder.item.setSelection(LanguageDatasetDialog.this.languageDataset.iszFolder());
                    LanguageDatasetDialog.this.setItemMessage(((LanguageDatasetDialog)LanguageDatasetDialog.this).existing.deco, null);
                }
            });
            this.existing.item.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent event) {
                    MessageBox helpDialog = new MessageBox(LanguageDatasetDialog.this.parentShell, 36);
                    helpDialog.setText(Messages.LanguageDataset_Dialog_HelpLbl_Existing);
                    helpDialog.setMessage(Messages.LanguageDataset_Dialog_HelpTxt_Existing);
                    helpDialog.open();
                }
            });
        }
        LanguageDatasetDialog.applyDialogFont((Control)itemComposite);
        return composite;
    }

    private boolean isDuplicateDataset(String dataset) {
        for (IImporterDataset languageDataset : this.languageDatasets) {
            if (!languageDataset.getDataset().equals(dataset)) continue;
            return true;
        }
        return false;
    }

    protected void okPressed() {
        boolean ok = true;
        if (!Verification.isNonBlank((String)this.languageDataset.getDataset())) {
            this.setItemMessage(this.dataset.deco, Messages.LanguageDataset_Dialog_Error_Required_Dataset);
            ok = false;
        } else if (!Verification.isDatasetName((String)this.languageDataset.getDataset())) {
            this.setItemMessage(this.dataset.deco, Messages.LanguageDataset_Dialog_Error_ZDataset_Dataset);
            ok = false;
        } else if (this.isDuplicateDataset(this.languageDataset.getDataset())) {
            this.setItemMessage(this.dataset.deco, Messages.LanguageDataset_Dialog_Error_Original_Dataset);
            ok = false;
        } else {
            this.setItemMessage(this.dataset.deco, null);
        }
        if (ok) {
            super.okPressed();
        }
    }

    private void setItemMessage(ControlDecoration controlDecoration, String message) {
        if (controlDecoration != null) {
            if (message != null) {
                controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                controlDecoration.setDescriptionText(message);
            } else {
                controlDecoration.hide();
                controlDecoration.setImage(null);
                controlDecoration.show();
            }
        }
    }

    public final IImporterDataset getDialogObject() {
        return this.languageDataset;
    }
}

