/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.content.DataSetDefinitionCommon;
import com.ibm.team.enterprise.systemdefinition.ui.content.DataSetDefinitionDetails;
import com.ibm.team.enterprise.systemdefinition.ui.content.DataSetDefinitionGeneral;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.NarrowTitleAreaDialog;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ImporterDatasetDefinitionDialog
extends NarrowTitleAreaDialog
implements ISystemDefinitionDialog {
    private static final int MinimumDialogW = 320;
    private static final int MinimumDialogH = 80;
    private final IDataSetDefinition dataSetDefintion;
    private final IEnterpriseConfiguration configuration;
    private final String title;
    private DataSetDefinitionCommon common;
    private Hyperlink displayAll;
    private boolean okPressed;
    private final Map<Control, ControlDecoration> decorations = new HashMap<Control, ControlDecoration>();
    private final LinkedHashMap<Control, ErrorMessage> messages = new LinkedHashMap();

    public ImporterDatasetDefinitionDialog(Shell parentShell, String title, IDataSetDefinition dataSetDefintion, IEnterpriseConfiguration configuration) {
        super(parentShell, 320, 80);
        this.title = title;
        this.dataSetDefintion = dataSetDefintion;
        this.configuration = configuration;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(final Composite parent) {
        FormToolkit toolkit = new FormToolkit(Display.getDefault());
        toolkit.setBackground(null);
        this.displayAll = toolkit.createHyperlink(parent, Messages.ImporterDatasetDefinitionDialog_DisplayAll, 64);
        this.displayAll.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                StringBuilder sb = new StringBuilder();
                ImporterDatasetDefinitionDialog.this.messages.forEach((k, v) -> {
                    StringBuilder stringBuilder2 = sb.append("\u2022").append(" ").append(v.message).append("\n");
                });
                sb.setLength(sb.length() - 1);
                MessageDialog dialog = new MessageDialog(parent.getShell(), Messages.ImporterDatasetDefinitionDialog_Errors, null, sb.toString(), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.setBlockOnOpen(true);
                dialog.open();
            }
        });
        this.displayAll.setLayoutData((Object)new GridData(1));
        this.displayAll.setEnabled(false);
        this.displayAll.setVisible(false);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle(this.title);
        this.setMessage(Messages.LanguageDataset_Dialog_Title_Message);
        this.setTitleImage(Activator.getImage("icons/wizban/dsdefban_wiz.gif"));
        Composite itemComposite = new Composite(composite, 0);
        itemComposite.setLayout((Layout)new FormLayout());
        this.common = new DataSetDefinitionCommon(this.dataSetDefintion, this.configuration, toolkit, this, null, true, true, 400);
        DataSetDefinitionGeneral general = new DataSetDefinitionGeneral(this.common);
        general.createContent(itemComposite);
        FormData generalData = new FormData();
        generalData.top = new FormAttachment(0, 0);
        generalData.bottom = new FormAttachment(50, 0);
        generalData.left = new FormAttachment(0, 0);
        generalData.right = new FormAttachment(100, 0);
        general.getSection().setLayoutData((Object)generalData);
        general.getSection().setBackground(null);
        DataSetDefinitionDetails details = new DataSetDefinitionDetails(this.common);
        details.createContent(itemComposite);
        FormData detailsData = new FormData();
        detailsData.top = new FormAttachment((Control)general.getSection());
        detailsData.left = new FormAttachment(0, 0);
        detailsData.right = new FormAttachment(100, 0);
        details.getSection().setLayoutData((Object)detailsData);
        details.getSection().setBackground(null);
        ImporterDatasetDefinitionDialog.applyDialogFont((Control)itemComposite);
        return composite;
    }

    protected void okPressed() {
        this.okPressed = true;
        boolean ok = this.common.validate();
        if (ok) {
            super.okPressed();
        }
    }

    @Override
    public final boolean isOkPressed() {
        return this.okPressed;
    }

    private void setItemMessage(Control control, String message) {
        ErrorMessage errorMessage = new ErrorMessage(control, message);
        ControlDecoration decoration = this.decorations.get(control);
        if (decoration == null) {
            decoration = new ControlDecoration(control, 16512);
            this.decorations.put(control, decoration);
        }
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        decoration.setDescriptionText(message);
        decoration.show();
        this.messages.put(control, errorMessage);
        this.setErrorMessage(this.messages.entrySet().iterator().next().getValue().message);
        if (this.messages.size() > 1) {
            this.displayAll.setEnabled(true);
            this.displayAll.setVisible(true);
        } else {
            this.displayAll.setEnabled(false);
            this.displayAll.setVisible(false);
        }
    }

    private void removeItemMessage(Control control) {
        ControlDecoration decoration = this.decorations.get(control);
        if (decoration != null) {
            decoration.setImage(null);
            decoration.setDescriptionText(null);
            decoration.hide();
        }
        this.messages.remove(control);
        if (!this.messages.isEmpty()) {
            this.setErrorMessage(this.messages.entrySet().iterator().next().getValue().message);
        } else {
            this.setErrorMessage(null);
        }
        if (this.messages.size() > 1) {
            this.displayAll.setEnabled(true);
            this.displayAll.setVisible(true);
        } else {
            this.displayAll.setEnabled(false);
            this.displayAll.setVisible(false);
        }
    }

    @Override
    public void addErrorMessage(Object id, String message, Control control) {
        this.setItemMessage(control, message);
    }

    @Override
    public void removeErrorMessage(Object id, Control control) {
        this.removeItemMessage(control);
    }

    @Override
    public void removeErrorMessage(Object id) {
        if (id instanceof Control) {
            this.removeItemMessage((Control)id);
        }
    }

    class ErrorMessage {
        public Control control;
        public String message;

        ErrorMessage(Control control, String message) {
            this.control = control;
            this.message = message;
        }
    }
}

