/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.process.common.IProjectArea;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredSystemDefinitionTree
extends FilteredTree {
    private WorkbenchJob refreshJob;
    private final Set<Object> expandedProjectAreas = new HashSet<Object>();
    private final ViewerFilter extraFilter;

    public FilteredSystemDefinitionTree(Composite parent, int treeStyle, boolean useNewLook, ViewerFilter extraFilter) {
        super(parent, treeStyle, null, useNewLook);
        this.extraFilter = extraFilter;
    }

    protected void init(int treeStyle, PatternFilter filter) {
        super.init(treeStyle, this.createPatternFilter());
        this.getViewer().addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                FilteredSystemDefinitionTree.this.expandedProjectAreas.add(event.getElement());
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (event.getSelection() instanceof TreeSelection) {
                    Iterator it = ((TreeSelection)event.getSelection()).iterator();
                    while (it.hasNext()) {
                        FilteredSystemDefinitionTree.this.expandedProjectAreas.add(it.next());
                    }
                }
            }
        });
    }

    protected PatternFilter createPatternFilter() {
        return new SystemDefinitionPatternFilter();
    }

    protected WorkbenchJob doCreateRefreshJob() {
        this.refreshJob = super.doCreateRefreshJob();
        return this.refreshJob;
    }

    public void refresh() {
        this.refreshJob.cancel();
        this.refreshJob.schedule(this.getRefreshJobDelay());
    }

    protected class SystemDefinitionPatternFilter
    extends PatternFilter {
        private boolean hasPatternEverBeenSet;

        public SystemDefinitionPatternFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        protected boolean isParentMatch(Viewer viewer, Object element) {
            if (!this.hasPatternEverBeenSet && element instanceof IProjectArea && !FilteredSystemDefinitionTree.this.expandedProjectAreas.contains(element)) {
                return true;
            }
            return super.isParentMatch(viewer, element);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return true;
            }
            boolean match = super.isLeafMatch(viewer, element);
            if (match && FilteredSystemDefinitionTree.this.extraFilter != null) {
                match = FilteredSystemDefinitionTree.this.extraFilter.select(viewer, null, element);
            }
            return match;
        }

        public void setPattern(String patternString) {
            if (patternString != null && !patternString.isEmpty()) {
                this.hasPatternEverBeenSet = true;
            }
            super.setPattern(patternString);
        }
    }
}

