/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.common.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EmbeddedViewerTray
extends DialogTray
implements IPageChangedListener {
    private static final int MINIMUM_HEIGHT = 450;
    private int originalHeight;
    private int heightAdded;
    private FormToolkit toolkit;
    private Composite container;
    private Composite fileText;
    private Image close;
    private Image hover;
    private Label title;
    private Shell shell;
    private Text text;
    private IContributionItem closeAction;
    private ToolBarManager toolBarManager;
    private final String filePath;

    public EmbeddedViewerTray(String filePath) {
        this.filePath = filePath;
    }

    protected Control createContents(Composite parent) {
        this.shell = parent.getShell();
        this.ensureMinimumHeight(this.shell);
        Point point = this.shell.getSize();
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.getColors().initializeSectionToolBarColors();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 5;
        layout.numColumns = 2;
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)layout);
        this.container.addListener(12, event -> this.dispose());
        this.title = this.toolkit.createLabel(this.container, this.filePath);
        this.title.setBackground(parent.getBackground());
        this.title.setFont(JFaceResources.getBannerFont());
        this.title.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.createActions();
        this.toolBarManager = new ToolBarManager(0x800000);
        this.toolBarManager.add(this.closeAction);
        this.toolBarManager.createControl(this.container);
        this.toolBarManager.getControl().setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.fileText = new Composite(this.container, 0);
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        this.fileText.setLayout((Layout)layout);
        this.fileText.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        this.text = this.toolkit.createText(this.fileText, null, 776);
        this.text.setFont(JFaceResources.getTextFont());
        this.text.setLayoutData((Object)GridDataFactory.swtDefaults().hint(-1, point.y - 45).create());
        StringBuilder sb = new StringBuilder("\n");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Stream<String> stream = Files.lines(Paths.get(this.filePath, new String[0]));){
                stream.forEach(line -> {
                    StringBuilder stringBuilder2 = sb.append((String)line).append("\n");
                });
                this.text.setText(sb.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.container;
    }

    private void createActions() {
        this.createImages();
        this.closeAction = new ContributionItem(){

            public void fill(ToolBar parent, int index) {
                ToolItem item = new ToolItem(parent, 8);
                item.setImage(EmbeddedViewerTray.this.close);
                item.setHotImage(EmbeddedViewerTray.this.hover);
                item.setToolTipText(Messages.DialogItem_Label_Close);
                item.addListener(13, event -> {
                    TrayDialog dialog = (TrayDialog)EmbeddedViewerTray.this.shell.getData();
                    dialog.closeTray();
                });
            }
        };
    }

    private void createImages() {
        this.close = Activator.getImageDescriptor("icons/elcl16/close.png").createImage();
        this.hover = Activator.getImageDescriptor("icons/elcl16/close_hot.png").createImage();
    }

    private void dispose() {
        this.toolkit.dispose();
        this.toolBarManager.dispose();
        this.closeAction.dispose();
        this.close.dispose();
        this.hover.dispose();
        this.title.dispose();
        this.text.dispose();
        this.container.dispose();
        this.fileText.dispose();
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                EmbeddedViewerTray.this.shell.removeListener(11, (Listener)this);
                Point p = EmbeddedViewerTray.this.shell.getSize();
                if (EmbeddedViewerTray.this.heightAdded > 0 && p.y > EmbeddedViewerTray.this.originalHeight) {
                    p.y = Math.max(p.y - EmbeddedViewerTray.this.heightAdded, EmbeddedViewerTray.this.originalHeight);
                    EmbeddedViewerTray.this.shell.setSize(p);
                }
            }
        });
    }

    private void ensureMinimumHeight(Shell shell) {
        Point p = shell.getSize();
        this.originalHeight = p.y;
        if (p.y < 450) {
            this.heightAdded = 450 - p.y;
            p.y = 450;
            shell.setSize(p);
        } else {
            this.heightAdded = 0;
        }
    }

    public void pageChanged(PageChangedEvent event) {
    }
}

