/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.common.helper.ValidationHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.CreateDependencyTypeDialog;
import com.ibm.team.enterprise.systemdefinition.ui.editors.DependencyTypesControl;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.util.TranslatorEntryLabelProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DependencyTypeDialog
extends TitleAreaDialog {
    private final DependencyTypesControl fParentControl;
    private final ITeamRepository fTeamRepository;
    private final IProjectAreaHandle fProjectArea;
    private final String fTitle;
    private final String[] fDependencyTypeNameOptions;
    private final List<IDependencyType> fDefinedDependencyTypes;
    private final List<ITranslatorEntry> fAvailableTranslators;
    private final List<ITranslatorEntry> fSelectedTranslators;
    private int fLevel;
    private String fName;
    private final String fOriginalName;
    private final FormToolkit fToolkit;
    private Combo fNameCombo;
    private Button fTranslatorsAllButton;
    private Button fTranslatorsNoneButton;
    private Button fTranslatorsPartialButton;
    private CheckboxTableViewer fTranslatorsTableViewer;
    private Button fSelectAllTranslatorsButton;
    private Button fDeselectAllTranslatorsButton;

    public DependencyTypeDialog(Shell parentShell, FormToolkit toolkit, String title, IDependencyType dependencyType, List<String> parserProvidedTypes, List<ITranslatorEntry> translators, List<IDependencyType> existingDependencyTypes, ITeamRepository repository, IProjectAreaHandle projectArea, DependencyTypesControl parentControl) {
        super(parentShell);
        this.fParentControl = parentControl;
        ValidationHelper.validateNotNull((String)"title", (Object)title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fTeamRepository = repository;
        this.fDefinedDependencyTypes = existingDependencyTypes;
        this.fSelectedTranslators = new ArrayList<ITranslatorEntry>();
        this.fAvailableTranslators = translators;
        this.fProjectArea = projectArea;
        this.fDependencyTypeNameOptions = new String[parserProvidedTypes != null ? parserProvidedTypes.size() : 0];
        int index = 0;
        if (parserProvidedTypes != null) {
            for (String name : parserProvidedTypes) {
                this.fDependencyTypeNameOptions[index++] = name;
            }
        }
        for (ITranslatorEntry translator : dependencyType.getTranslators()) {
            this.fSelectedTranslators.add(translator);
        }
        this.fLevel = dependencyType.getLevel();
        this.fOriginalName = this.fName = dependencyType.getName();
        this.fToolkit = toolkit;
    }

    protected void validate(boolean suppressErrorMessage) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null || suppressErrorMessage) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(errorMessage);
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled(errorMessage == null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        composite.setLayoutData((Object)gridData);
        this.setTitle(this.fTitle);
        this.setMessage(Messages.DependencyTypeDialog_HEADER);
        Composite nameComposite = new Composite(composite, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        nameComposite.setLayoutData((Object)gridData);
        nameComposite.setLayout((Layout)new GridLayout(3, false));
        Label nameLabel = this.fToolkit.createLabel(nameComposite, Messages.DependencyTypeDialog_NAME_LABEL);
        nameLabel.setToolTipText(Messages.DependencyTypeDialog_NAME_TOOLTIP);
        nameLabel.setForeground(Display.getCurrent().getSystemColor(21));
        nameLabel.setBackground(Display.getCurrent().getSystemColor(22));
        this.fNameCombo = new Combo(nameComposite, 8);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        this.fNameCombo.setLayoutData((Object)gridData);
        this.populateNameCombo();
        this.fNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependencyTypeDialog.this.fName = DependencyTypeDialog.this.fNameCombo.getText();
                DependencyTypeDialog.this.validate(false);
            }
        });
        Button createTypeButton = this.fToolkit.createButton(nameComposite, Messages.DependencyTypeDialog_CREATE_TYPE, 8);
        createTypeButton.setEnabled(true);
        createTypeButton.addSelectionListener((SelectionListener)this.getCreateNewTypeListener());
        Composite radioComposite = new Composite(composite, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        radioComposite.setLayoutData((Object)gridData);
        radioComposite.setLayout((Layout)new GridLayout(1, false));
        this.fTranslatorsAllButton = this.createLevelRadioButton(radioComposite, Messages.DependencyTypeDialog_ALL, 16400);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fTranslatorsAllButton.setLayoutData((Object)gridData);
        this.fTranslatorsNoneButton = this.createLevelRadioButton(radioComposite, Messages.DependencyTypeDialog_NONE, 16400);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fTranslatorsNoneButton.setLayoutData((Object)gridData);
        this.fTranslatorsPartialButton = this.createLevelRadioButton(radioComposite, Messages.DependencyTypeDialog_PARTIAL, 16400);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fTranslatorsPartialButton.setLayoutData((Object)gridData);
        this.updateRadioButtonValues();
        Composite translatorComposite = new Composite(composite, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        translatorComposite.setLayoutData((Object)gridData);
        translatorComposite.setLayout((Layout)new GridLayout(2, false));
        Table table = this.fToolkit.createTable(translatorComposite, 66336);
        gridData = new GridData(4, -1, true, false);
        gridData.heightHint = table.getItemHeight() * 10;
        table.setLayoutData((Object)gridData);
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Accessible a = (Accessible)e.getSource();
                if (a.getControl() instanceof Table && ((Table)a.getControl()).getItemCount() == 0) {
                    e.result = Messages.DependencyTypeDialog_PARTIAL;
                }
            }
        });
        this.fTranslatorsTableViewer = new CheckboxTableViewer(table);
        this.fTranslatorsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTranslatorsTableViewer.setLabelProvider((IBaseLabelProvider)new TranslatorEntryLabelProvider((TableViewer)this.fTranslatorsTableViewer, this.fTeamRepository, this.fProjectArea, this.fParentControl));
        this.fTranslatorsTableViewer.setInput(this.fAvailableTranslators);
        block0: for (ITranslatorEntry t : this.fSelectedTranslators) {
            for (ITranslatorEntry te : this.fAvailableTranslators) {
                if (!te.getValue().equals(t.getValue())) continue;
                this.fTranslatorsTableViewer.setChecked((Object)te, true);
                continue block0;
            }
        }
        this.fTranslatorsTableViewer.addCheckStateListener(this.getCheckStateListener());
        if (this.fTranslatorsAllButton.getSelection()) {
            this.fTranslatorsTableViewer.setAllChecked(true);
        } else if (this.fTranslatorsNoneButton.getSelection()) {
            this.fTranslatorsTableViewer.setAllChecked(false);
        }
        this.createButtons(translatorComposite);
        this.updateButtonEnablement();
        this.fTranslatorsPartialButton.setEnabled(this.fAvailableTranslators.size() > 0);
        DependencyTypeDialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.enterprise.systemdefinition.ui.dialog_dependency_types");
        return composite;
    }

    private void populateNameCombo() {
        this.fNameCombo.setItems(this.fDependencyTypeNameOptions);
        if (this.fName != null && !this.fName.equals("")) {
            int index = this.fNameCombo.indexOf(this.fName);
            if (index < 0) {
                this.fNameCombo.add(this.fName, 0);
                index = 0;
            }
            this.fNameCombo.select(index);
        }
    }

    private void createButtons(Composite parent) {
        Composite buttonBar = this.fToolkit.createComposite(parent);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        buttonBar.setBackground(Display.getDefault().getSystemColor(22));
        this.fSelectAllTranslatorsButton = this.fToolkit.createButton(buttonBar, Messages.DependencyTypeDialog_SELECT_ALL_TRANSLATORS, 8);
        this.fSelectAllTranslatorsButton.setEnabled(this.fAvailableTranslators.size() > 0);
        this.fSelectAllTranslatorsButton.addSelectionListener((SelectionListener)this.getSelectAllTranslatorsListener());
        this.fDeselectAllTranslatorsButton = this.fToolkit.createButton(buttonBar, Messages.DependencyTypeDialog_DESELECT_ALL_TRANSLATORS, 8);
        this.fDeselectAllTranslatorsButton.setEnabled(this.fAvailableTranslators.size() > 0);
        this.fDeselectAllTranslatorsButton.addSelectionListener((SelectionListener)this.getDeselectAllTranslatorsListener());
        this.setButtonLayoutData();
    }

    private void updateButtonEnablement() {
        if (!this.fTranslatorsPartialButton.getSelection()) {
            this.fSelectAllTranslatorsButton.setEnabled(false);
            this.fDeselectAllTranslatorsButton.setEnabled(false);
            this.fTranslatorsTableViewer.setAllGrayed(true);
        } else {
            this.fSelectAllTranslatorsButton.setEnabled(this.fAvailableTranslators.size() > 0);
            this.fDeselectAllTranslatorsButton.setEnabled(this.fAvailableTranslators.size() > 0);
            this.fTranslatorsTableViewer.setAllGrayed(false);
        }
    }

    private void setButtonLayoutData() {
        GC gc = new GC((Drawable)this.fSelectAllTranslatorsButton);
        gc.setFont(this.fSelectAllTranslatorsButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fSelectAllTranslatorsButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fDeselectAllTranslatorsButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fSelectAllTranslatorsButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fDeselectAllTranslatorsButton.setLayoutData((Object)gridData);
    }

    protected SelectionAdapter getSelectAllTranslatorsListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependencyTypeDialog.this.fTranslatorsTableViewer.setAllChecked(true);
                DependencyTypeDialog.this.updateTranslators();
            }
        };
    }

    protected SelectionAdapter getDeselectAllTranslatorsListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependencyTypeDialog.this.fTranslatorsTableViewer.setAllChecked(false);
                DependencyTypeDialog.this.updateTranslators();
            }
        };
    }

    protected SelectionAdapter getCreateNewTypeListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateDependencyTypeDialog dialog = DependencyTypeDialog.this.getCreateDependencyTypeDialog();
                if (dialog.open() == 0) {
                    DependencyTypeDialog.this.createDependencyType(dialog.getDependencyType());
                    DependencyTypeDialog.this.validate(false);
                }
            }
        };
    }

    private void createDependencyType(String type) {
        this.fNameCombo.add(type, 0);
        this.fNameCombo.select(0);
        this.fName = type;
    }

    protected CreateDependencyTypeDialog getCreateDependencyTypeDialog() {
        ArrayList<String> existingTypes = new ArrayList<String>();
        String[] stringArray = this.fNameCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            existingTypes.add(name);
            ++n2;
        }
        return new CreateDependencyTypeDialog(this.fNameCombo.getShell(), existingTypes);
    }

    private ICheckStateListener getCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DependencyTypeDialog.this.updateTranslators();
                if (event.getChecked() && !DependencyTypeDialog.this.fTranslatorsPartialButton.getSelection()) {
                    DependencyTypeDialog.this.fTranslatorsPartialButton.setSelection(true);
                    DependencyTypeDialog.this.fTranslatorsAllButton.setSelection(false);
                    DependencyTypeDialog.this.fTranslatorsNoneButton.setSelection(false);
                    DependencyTypeDialog.this.handleLevelUpdate();
                }
            }
        };
    }

    private void updateTranslators() {
        Object[] translators = this.fTranslatorsTableViewer.getCheckedElements();
        this.fSelectedTranslators.clear();
        Object[] objectArray = translators;
        int n = translators.length;
        int n2 = 0;
        while (n2 < n) {
            Object translator = objectArray[n2];
            this.fSelectedTranslators.add((ITranslatorEntry)translator);
            ++n2;
        }
    }

    public ITranslatorEntry[] getTranslators() {
        return this.fSelectedTranslators.toArray(new ITranslatorEntry[this.fSelectedTranslators.size()]);
    }

    public int getLevel() {
        return this.fLevel;
    }

    public String getName() {
        return this.fName;
    }

    private Button createLevelRadioButton(Composite parent, String text, int style) {
        Button radioButton = new Button(parent, style);
        radioButton.setText(text);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependencyTypeDialog.this.handleLevelUpdate();
            }
        });
        return radioButton;
    }

    private void handleLevelUpdate() {
        if (this.fTranslatorsAllButton.getSelection()) {
            this.fLevel = 0;
            this.fTranslatorsTableViewer.setAllChecked(true);
        } else if (this.fTranslatorsNoneButton.getSelection()) {
            this.fLevel = 1;
            this.fTranslatorsTableViewer.setAllChecked(false);
        } else {
            this.fLevel = 2;
            this.updateTranslators();
        }
        this.updateButtonEnablement();
    }

    protected void updateRadioButtonValues() {
        if (this.fLevel == 0) {
            this.fTranslatorsAllButton.setSelection(true);
        } else if (this.fLevel == 1) {
            this.fTranslatorsNoneButton.setSelection(true);
        } else if (this.fLevel == 2) {
            this.fTranslatorsPartialButton.setSelection(true);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    public void create() {
        super.create();
        this.validate(true);
    }

    public String getErrorMessage() {
        if (this.fName == null || this.fName.equals("")) {
            return Messages.DependencyTypeDialog_NAME_REQUIRED;
        }
        if (!this.fName.equals(this.fOriginalName)) {
            for (IDependencyType type : this.fDefinedDependencyTypes) {
                if (!type.getName().equals(this.fName)) continue;
                return Messages.DependencyTypeDialog_DUPLICATE_TYPE;
            }
        }
        return null;
    }
}

