/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.VariableUtils;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CreateVariableDialog
extends TitleAreaDialog {
    private Label fVariableNameLabel;
    private Label fVariableValueLabel;
    private Text fVariableNameText;
    private Text fVariableValueText;
    private final IVariable fVariable;
    private IVariable fTempVariable;
    private final List<IVariable> fExistingVariables;
    private String fOriginalValue;
    private String fOriginalName;
    private final String fTitle;
    private final String fMessage;
    private boolean fVariableOverride = false;

    public CreateVariableDialog(Shell parentShell, IVariable variable, List<IVariable> existingVariables, String title, String message) {
        super(parentShell);
        this.fTitle = title;
        this.fMessage = message;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fVariable = variable;
        if (variable != null) {
            this.fOriginalName = variable.getName();
            this.fOriginalValue = variable.getValue();
            this.fTempVariable = (IVariable)EcoreUtil.copy((EObject)((EObject)variable));
        } else {
            this.fTempVariable = ModelFactory.eINSTANCE.createVariable();
        }
        this.fExistingVariables = existingVariables;
    }

    public CreateVariableDialog(Shell parentShell, IVariable variable, List<IVariable> existingVariables, boolean variableOverride, String title, String message) {
        this(parentShell, variable, existingVariables, title, message);
        this.fVariableOverride = variableOverride;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(3).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Label titleBarSeparator = new Label(composite, 258);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)titleBarSeparator);
        this.setTitle(this.fTitle);
        this.setMessage(this.fMessage);
        this.fVariableNameLabel = new Label(composite, 0);
        this.fVariableNameLabel.setText(Messages.CreateVariableDialog_NameLabel);
        this.fVariableNameText = new Text(composite, 2052);
        this.fVariableNameText.setText(this.fOriginalName == null ? "" : this.fOriginalName);
        this.fVariableNameText.setEditable(!this.fVariableOverride);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.fVariableNameText);
        this.fVariableNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateVariableDialog.this.validate(false);
                CreateVariableDialog.this.fTempVariable.setName(CreateVariableDialog.this.fVariableNameText.getText().trim().toUpperCase());
            }
        });
        this.fVariableValueLabel = new Label(composite, 0);
        this.fVariableValueLabel.setText(Messages.CreateVariableDialog_ValueLabel);
        this.fVariableValueText = new Text(composite, 2052);
        this.fVariableValueText.setText(this.fOriginalValue == null ? "" : this.fOriginalValue);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.fVariableValueText);
        if (!this.fVariableNameText.getEditable()) {
            this.fVariableValueText.setFocus();
        }
        this.fVariableValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateVariableDialog.this.validate(false);
                CreateVariableDialog.this.fTempVariable.setValue(CreateVariableDialog.this.fVariableValueText.getText().trim());
            }
        });
        CreateVariableDialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.enterprise.systemdefinition.ui.dialog_variable_definition");
        return composite;
    }

    public IVariable getVariable() {
        if (this.fVariable != null) {
            this.fVariable.setName(this.fTempVariable.getName());
            this.fVariable.setValue(this.fTempVariable.getValue());
            return this.fVariable;
        }
        return this.fTempVariable;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    protected void validate(boolean suppressErrorMessage) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null || suppressErrorMessage) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(errorMessage);
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled(errorMessage == null);
        if (this.fOriginalName != null && this.fOriginalValue != null) {
            okButton.setEnabled(okButton.isEnabled() && (!this.fOriginalName.equalsIgnoreCase(this.fVariableNameText.getText()) || !this.fOriginalValue.equalsIgnoreCase(this.fVariableValueText.getText())));
        }
    }

    public void create() {
        super.create();
        this.validate(true);
    }

    public String getErrorMessage() {
        String proposedName = this.fVariableNameText.getText().trim();
        if (proposedName == null || proposedName.equals("")) {
            return Messages.CreateVariableDialog_Error_NoName;
        }
        if (this.nameConflict(proposedName)) {
            return NLS.bind((String)Messages.CreateVariableDialog_Error_NameConflict, (Object)proposedName);
        }
        if (VariableUtils.containsWhitespace((String)proposedName)) {
            return Messages.CreateVariableDialog_Error_NoWhitespace;
        }
        if (VariableUtils.isReservedVariableName((String)proposedName)) {
            return NLS.bind((String)Messages.CreateVariableDialog_Error_ReservedName, (Object)proposedName.toUpperCase());
        }
        if (!VariableUtils.isAlphanumeric((String)proposedName)) {
            return Messages.CreateVariableDialog_ErrorInvalidCharacters;
        }
        return null;
    }

    protected boolean nameConflict(String name) {
        if (this.fOriginalName != null && this.getOriginalName().equalsIgnoreCase(this.fVariableNameText.getText())) {
            return false;
        }
        for (IVariable object : this.fExistingVariables) {
            IVariable variable = object;
            if (!variable.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public String getOriginalName() {
        return this.fOriginalName;
    }

    public String getOriginalValue() {
        return this.fOriginalValue;
    }
}

