/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.common.model.IHFSOutput;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CreateOutputDialog
extends TitleAreaDialog {
    private Label fOutputPathLabel;
    private Label fOutputConditionLabel;
    private Label fOutputDeployTypeLabel;
    private Text fOutputPathText;
    private Text fOutputConditionText;
    private Text fOutputDeployTypeText;
    private final IHFSOutput fOutput;
    private IHFSOutput fTempOutput;
    private final List<IHFSOutput> fExistingOutputs;
    private String fOriginalCondition;
    private String fOriginalPath;
    private String fOriginalDeployType;
    private final String fTitle;
    private final String fMessage;
    private boolean fOutputOverride = false;

    public CreateOutputDialog(Shell parentShell, IHFSOutput output, List<IHFSOutput> existingOutputs, String title, String message) {
        super(parentShell);
        this.fTitle = title;
        this.fMessage = message;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fOutput = output;
        if (output != null) {
            this.fOriginalPath = output.getPath();
            this.fOriginalCondition = output.getCondition();
            this.fOriginalDeployType = output.getDeployType();
            this.fTempOutput = ModelFactory.eINSTANCE.createHFSOutputCopy(output);
        } else {
            this.fTempOutput = ModelFactory.eINSTANCE.createHFSOutput();
        }
        this.fExistingOutputs = existingOutputs;
    }

    public CreateOutputDialog(Shell parentShell, IHFSOutput output, List<IHFSOutput> existingOutputs, boolean outputOverride, String title, String message) {
        this(parentShell, output, existingOutputs, title, message);
        this.fOutputOverride = outputOverride;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(3).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Label titleBarSeparator = new Label(composite, 258);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)titleBarSeparator);
        this.setTitle(this.fTitle);
        this.setMessage(this.fMessage);
        this.fOutputPathLabel = new Label(composite, 0);
        this.fOutputPathLabel.setText(Messages.CreateOutputDialog_PathLabel);
        this.fOutputPathText = new Text(composite, 2052);
        this.fOutputPathText.setText(this.fOriginalPath == null ? "" : this.fOriginalPath);
        this.fOutputPathText.setEditable(!this.fOutputOverride);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.fOutputPathText);
        this.fOutputPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateOutputDialog.this.validate(false);
                CreateOutputDialog.this.fTempOutput.setPath(CreateOutputDialog.this.fOutputPathText.getText());
            }
        });
        this.fOutputConditionLabel = new Label(composite, 0);
        this.fOutputConditionLabel.setText(Messages.CreateOutputDialog_ConditionLabel);
        this.fOutputConditionLabel.setToolTipText(Messages.CreateOutputDialog_ConditionTooltip);
        this.fOutputConditionText = new Text(composite, 2052);
        this.fOutputConditionText.setText(this.fOriginalCondition == null ? "" : this.fOriginalCondition);
        this.fOutputConditionText.setToolTipText(Messages.CreateOutputDialog_ConditionTooltip);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.fOutputConditionText);
        if (!this.fOutputPathText.getEditable()) {
            this.fOutputConditionText.setFocus();
        }
        this.fOutputConditionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateOutputDialog.this.validate(false);
                CreateOutputDialog.this.fTempOutput.setCondition(CreateOutputDialog.this.fOutputConditionText.getText().trim());
            }
        });
        this.fOutputDeployTypeLabel = new Label(composite, 0);
        this.fOutputDeployTypeLabel.setText(Messages.CreateOutputDialog_DeployTypeLabel);
        this.fOutputDeployTypeText = new Text(composite, 2052);
        this.fOutputDeployTypeText.setText(this.fOriginalDeployType == null ? "" : this.fOriginalDeployType);
        this.fOutputDeployTypeText.setEditable(!this.fOutputOverride);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.fOutputDeployTypeText);
        this.fOutputDeployTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateOutputDialog.this.validate(false);
                CreateOutputDialog.this.fTempOutput.setDeployType(CreateOutputDialog.this.fOutputDeployTypeText.getText().trim());
            }
        });
        CreateOutputDialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.enterprise.systemdefinition.ui.dialog_output_definition");
        return composite;
    }

    public IHFSOutput getOutput() {
        if (this.fOutput != null) {
            this.fOutput.setPath(this.fTempOutput.getPath());
            this.fOutput.setCondition(this.fTempOutput.getCondition());
            this.fOutput.setDeployType(this.fTempOutput.getDeployType());
            return this.fOutput;
        }
        return this.fTempOutput;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    protected void validate(boolean suppressErrorMessage) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null || suppressErrorMessage) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(errorMessage);
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled(errorMessage == null);
        if (this.fOriginalPath != null && this.fOriginalCondition != null && this.fOriginalDeployType != null) {
            okButton.setEnabled(okButton.isEnabled() && (!this.fOriginalPath.equals(this.fOutputPathText.getText()) || !this.fOriginalCondition.equals(this.fOutputConditionText.getText()) || !this.fOriginalDeployType.equals(this.fOutputDeployTypeText.getText())));
        }
    }

    public void create() {
        super.create();
        this.validate(true);
    }

    public String getErrorMessage() {
        String proposedPath = this.fOutputPathText.getText();
        if (proposedPath.trim().isEmpty()) {
            return Messages.CreateOutputDialog_Error_NoPath;
        }
        return null;
    }

    public String getOriginalPath() {
        return this.fOriginalPath;
    }

    public String getOriginalCondition() {
        return this.fOriginalCondition;
    }

    public String getOriginalDeployType() {
        return this.fOriginalDeployType;
    }
}

