/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateDependencyTypeDialog
extends Dialog {
    private Label fErrorMessageLabel;
    private Text fDependencyTypeText;
    private String fDependencyType;
    private Collection<String> fExistingDependencyTypes;

    public CreateDependencyTypeDialog(Shell parentShell, Collection<String> existingDependencyTypes) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fExistingDependencyTypes = existingDependencyTypes != null ? existingDependencyTypes : Collections.emptyList();
    }

    public String getDependencyType() {
        return this.fDependencyType;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 500;
        composite.setLayoutData((Object)gridData);
        this.createLabel(composite, Messages.CreateDependencyTypeDialog_DESCRIPTION, null);
        this.fErrorMessageLabel = this.createLabel(composite, "", JFaceColors.getErrorText((Display)composite.getDisplay()));
        this.fDependencyTypeText = this.createText(composite, Messages.CreateDependencyTypeDialog_TYPE_LABEL, "", 2);
        this.fDependencyTypeText.addModifyListener(this.getDependencyTypeModifiedListener());
        CreateDependencyTypeDialog.applyDialogFont((Control)composite);
        this.fDependencyTypeText.setFocus();
        return composite;
    }

    protected ModifyListener getDependencyTypeModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateDependencyTypeDialog.this.validateDependencyType();
            }
        };
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void validateDependencyType() {
        boolean enabled = true;
        String errorMessage = "";
        if (this.fDependencyTypeText.getText().trim().length() == 0) {
            enabled = false;
        } else if (this.fExistingDependencyTypes.contains(this.fDependencyTypeText.getText())) {
            enabled = false;
            errorMessage = Messages.CreateDependencyTypeDialog_DUPLICATE;
        } else {
            this.fDependencyType = this.fDependencyTypeText.getText();
        }
        this.getButton(0).setEnabled(enabled);
        this.fErrorMessageLabel.setText(errorMessage);
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        label.setForeground(color);
        return label;
    }

    protected Text createText(Composite parent, String labelText, String defaultText, int textHorizontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData());
        Text text = new Text(parent, 2052);
        text.setText(defaultText);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = textHorizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CreateDependencyTypeDialog_TITLE);
    }
}

