/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.content;

import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionEditor;
import com.ibm.team.enterprise.systemdefinition.ui.content.AbstractContentCommon;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.agent.MappingException;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.ui.editor.TeamFormPage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DataSetDefinitionCommon
extends AbstractContentCommon {
    private static final String ReqDataClass = Messages.DataSetDefinitionContent_DATA_CLASS_REQUIRED;
    private static final String ReqStorageClass = Messages.DataSetDefinitionContent_STORAGE_CLASS_REQUIRED;
    private static final String ReqManagementClass = Messages.DataSetDefinitionContent_MANAGEMENT_CLASS_REQUIRED;
    private static final String ReqVolumeSerial = Messages.DataSetDefinitionContent_VOLUME_SERIAL_REQUIRED;
    private static final String ReqGenericUnit = Messages.DataSetDefinitionContent_GENERIC_UNIT_REQUIRED;
    private static final String ReqSpaceUnits = Messages.DataSetDefinitionContent_SPACE_UNITS_REQUIRED;
    private static final String ReqPrimaryQuantity = Messages.DataSetDefinitionContent_PRIMARY_QUANTITY_REQUIRED;
    private static final String ReqSecondaryQuantity = Messages.DataSetDefinitionContent_SECONDARY_QUANTITY_REQUIRED;
    private static final String ReqDirectoryBlocks = Messages.DataSetDefinitionContent_DIRECTORY_BLOCKS_REQUIRED;
    private static final String ReqRecordFormat = Messages.DataSetDefinitionContent_RECORD_FORMAT_REQUIRED;
    private static final String ReqRecordLength = Messages.DataSetDefinitionContent_RECORD_LENGTH_REQUIRED;
    private static final String ReqBlockSize = Messages.DataSetDefinitionContent_BLOCK_SIZE_REQUIRED;
    public static final String MaxLrecl = "32760";
    public static final String MaxQuantity = "16777215";
    public static final String Undefined = "U";
    public FormToolkit toolkit;
    public Section generalSection;
    public Section detailsSection;
    public Text name;
    public Label nameLabel;
    public Text description;
    public Label descriptionLabel;
    public Text dsName;
    public Label dsNameLabel;
    public Text memberName;
    public Label memberNameLabel;
    public Group usageGroup;
    public Label usageGroupLabel;
    public Button zFolder;
    public Button newDataset;
    public Button existingDataset;
    public Button temporaryDataset;
    public Button prefixedDataset;
    public Button compactDataset;
    public Button nonImpacting;
    public Text dataClass;
    public Label dataClassLabel;
    public ModifyListener dataClassListener;
    public Text storageClass;
    public Label storageClassLabel;
    public ModifyListener storageClassListener;
    public Text managementClass;
    public Label managementClassLabel;
    public ModifyListener managementClassListener;
    public Text volumeSerial;
    public Label volumeSerialLabel;
    public ModifyListener volumeSerialListener;
    public Text genericUnit;
    public Label genericUnitLabel;
    public ModifyListener genericUnitListener;
    public Combo spaceUnits;
    public Label spaceUnitsLabel;
    public SelectionAdapter spaceUnitsListener;
    public Text primaryQuantity;
    public Label primaryQuantityLabel;
    public ModifyListener primaryQuantityListener;
    public Text secondaryQuantity;
    public Label secondaryQuantityLabel;
    public ModifyListener secondaryQuantityListener;
    public Text directoryBlocks;
    public Label directoryBlocksLabel;
    public ModifyListener directoryBlocksListener;
    public Combo recordFormat;
    public Label recordFormatLabel;
    public SelectionAdapter recordFormatListener;
    public Text recordLength;
    public Label recordLengthLabel;
    public ModifyListener recordLengthListener;
    public Text blockSize;
    public Label blockSizeLabel;
    public ModifyListener blockSizeListener;
    public Text additionalParm;
    public Label additionalParmLabel;
    public ModifyListener additionalParmListener;
    public Combo dataSetType;
    public Label dataSetTypeLabel;
    public SelectionAdapter dataSetTypeListener;
    public final IDataSetDefinition dataSetDefinition;
    public final IEnterpriseConfiguration configuration;
    public final MappingValidation validator;
    public final boolean addName;
    public final boolean addNameDisabled;
    public final int widthHint;
    public Map<String, Control> validationControlMap;
    public Control crossValidationControl;
    public static final String[] SPACE_UNITS = new String[]{"", Messages.DataSetDefinitionContent_UNITS_BLOCKS, Messages.DataSetDefinitionContent_UNITS_TRACKS, Messages.DataSetDefinitionContent_UNITS_CYLINDERS};
    public static final String[] DATA_SET_TYPES = new String[]{Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDSE, Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDSE1, Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDSE2, Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDS, Messages.DataSetDefinitionContent_DATA_SET_TYPE_SEQUENTIAL, Messages.DataSetDefinitionContent_DATA_SET_TYPE_UNSPECIFIED};

    public DataSetDefinitionCommon(IDataSetDefinition dataSetDefinition, IEnterpriseConfiguration configuration, FormToolkit toolkit, Object editor, TeamFormPage editorPage) {
        this(dataSetDefinition, configuration, toolkit, editor, editorPage, false, false, 200);
    }

    public DataSetDefinitionCommon(IDataSetDefinition dataSetDefinition, IEnterpriseConfiguration configuration, FormToolkit toolkit, Object editor, TeamFormPage editorPage, boolean addName, boolean addNameDisabled, int widthHint) {
        this.dataSetDefinition = dataSetDefinition;
        this.configuration = configuration;
        this.toolkit = toolkit;
        if (editor instanceof ISystemDefinitionEditor) {
            this.editor = (ISystemDefinitionEditor)editor;
        }
        if (editor instanceof ISystemDefinitionDialog) {
            this.dialog = (ISystemDefinitionDialog)editor;
        }
        this.editorPage = editorPage;
        this.addName = addName;
        this.addNameDisabled = addNameDisabled;
        this.widthHint = widthHint;
        this.validator = new MappingValidation(this.configuration);
    }

    public final void clearDetailsSection() {
        this.enableDetailsSection(false);
        this.dataClass.removeModifyListener(this.dataClassListener);
        this.storageClass.removeModifyListener(this.storageClassListener);
        this.managementClass.removeModifyListener(this.managementClassListener);
        this.spaceUnits.removeSelectionListener((SelectionListener)this.spaceUnitsListener);
        this.primaryQuantity.removeModifyListener(this.primaryQuantityListener);
        this.secondaryQuantity.removeModifyListener(this.secondaryQuantityListener);
        this.directoryBlocks.removeModifyListener(this.directoryBlocksListener);
        this.recordFormat.removeSelectionListener((SelectionListener)this.recordFormatListener);
        this.recordLength.removeModifyListener(this.recordLengthListener);
        this.blockSize.removeModifyListener(this.blockSizeListener);
        this.additionalParm.removeModifyListener(this.additionalParmListener);
        this.dataSetType.removeSelectionListener((SelectionListener)this.dataSetTypeListener);
        this.dataClass.setText("");
        this.storageClass.setText("");
        this.managementClass.setText("");
        this.spaceUnits.select(0);
        this.primaryQuantity.setText("");
        this.secondaryQuantity.setText("");
        this.directoryBlocks.setText("");
        this.recordFormat.select(0);
        this.recordLength.setText("");
        this.blockSize.setText("");
        this.additionalParm.setText("");
        this.dataSetType.setItems(DATA_SET_TYPES);
        this.dataSetType.select(DATA_SET_TYPES.length - 1);
        this.dataSetDefinition.setDataClass("");
        this.dataSetDefinition.setStorageClass("");
        this.dataSetDefinition.setManagementClass("");
        this.dataSetDefinition.setSpaceUnits("");
        this.dataSetDefinition.setPrimaryQuantity("");
        this.dataSetDefinition.setSecondaryQuantity("");
        this.dataSetDefinition.setDirectoryBlocks("");
        this.dataSetDefinition.setRecordFormat("");
        this.dataSetDefinition.setRecordLength("");
        this.dataSetDefinition.setBlockSize("");
        this.dataSetDefinition.setAdditionalParm("");
        this.dataSetDefinition.setDsType(9);
        this.dataClass.addModifyListener(this.dataClassListener);
        this.storageClass.addModifyListener(this.storageClassListener);
        this.managementClass.addModifyListener(this.managementClassListener);
        this.spaceUnits.addSelectionListener((SelectionListener)this.spaceUnitsListener);
        this.primaryQuantity.addModifyListener(this.primaryQuantityListener);
        this.secondaryQuantity.addModifyListener(this.secondaryQuantityListener);
        this.directoryBlocks.addModifyListener(this.directoryBlocksListener);
        this.recordFormat.addSelectionListener((SelectionListener)this.recordFormatListener);
        this.recordLength.addModifyListener(this.recordLengthListener);
        this.blockSize.addModifyListener(this.blockSizeListener);
        this.additionalParm.addModifyListener(this.additionalParmListener);
        this.dataSetType.addSelectionListener((SelectionListener)this.dataSetTypeListener);
        this.enableDetailsSection(true);
    }

    public final void enableBlkLreclElements(boolean enable) {
        this.recordLength.setEnabled(enable);
        this.recordLengthLabel.setEnabled(enable);
        this.blockSize.setEnabled(enable);
        this.blockSizeLabel.setEnabled(enable);
    }

    public final void enableDetailsSection(boolean b) {
        this.dataClass.setEnabled(b);
        this.dataClassLabel.setEnabled(b);
        this.storageClass.setEnabled(b);
        this.storageClassLabel.setEnabled(b);
        this.managementClass.setEnabled(b);
        this.managementClassLabel.setEnabled(b);
        this.spaceUnits.setEnabled(b);
        this.spaceUnitsLabel.setEnabled(b);
        this.primaryQuantity.setEnabled(b);
        this.primaryQuantityLabel.setEnabled(b);
        this.secondaryQuantity.setEnabled(b);
        this.secondaryQuantityLabel.setEnabled(b);
        this.directoryBlocks.setEnabled(b && this.isPds());
        this.directoryBlocksLabel.setEnabled(b && this.isPds());
        this.recordFormat.setEnabled(b);
        this.recordFormatLabel.setEnabled(b);
        this.recordLength.setEnabled(b);
        this.recordLengthLabel.setEnabled(b);
        this.blockSize.setEnabled(b);
        this.blockSizeLabel.setEnabled(b);
        this.dataSetType.setEnabled(b);
        this.dataSetTypeLabel.setEnabled(b);
    }

    public final String getDataSetLabel(int dsType) {
        if (dsType == 0) {
            return Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDSE;
        }
        if (dsType == 4) {
            return Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDSE1;
        }
        if (dsType == 5) {
            return Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDSE2;
        }
        if (dsType == 3) {
            return Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDS;
        }
        if (dsType == 1) {
            return Messages.DataSetDefinitionContent_DATA_SET_TYPE_SEQUENTIAL;
        }
        if (dsType == 9) {
            return Messages.DataSetDefinitionContent_DATA_SET_TYPE_UNSPECIFIED;
        }
        return null;
    }

    public final int getDataSetValue() {
        String label = this.dataSetType.getItem(this.dataSetType.getSelectionIndex());
        if (label.equals(Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDSE)) {
            return 0;
        }
        if (label.equals(Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDSE1)) {
            return 4;
        }
        if (label.equals(Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDSE2)) {
            return 5;
        }
        if (label.equals(Messages.DataSetDefinitionContent_DATA_SET_TYPE_PDS)) {
            return 3;
        }
        if (label.equals(Messages.DataSetDefinitionContent_DATA_SET_TYPE_SEQUENTIAL)) {
            return 1;
        }
        return 9;
    }

    public final void handleDataSetTypeSelected() {
        int dataSetValue = this.getDataSetValue();
        this.dataSetDefinition.setDsType(dataSetValue);
        if (dataSetValue == 1) {
            this.directoryBlocks.setText("");
            this.directoryBlocksLabel.setEnabled(false);
            this.directoryBlocks.setEnabled(false);
        } else if (dataSetValue == 3) {
            if (this.directoryBlocks.getText().trim().equals("") || this.directoryBlocks.getText().trim().equals("0")) {
                this.directoryBlocks.setText("1");
                this.dataSetDefinition.setDirectoryBlocks(this.directoryBlocks.getText().trim());
                this.directoryBlocksLabel.setEnabled(true);
                this.directoryBlocks.setEnabled(true);
            }
        } else if (!(dataSetValue != 0 && dataSetValue != 4 && dataSetValue != 5 || this.directoryBlocks.getText().trim().equals("") || this.directoryBlocks.getText().trim().equals("0"))) {
            this.directoryBlocks.setText("0");
            this.dataSetDefinition.setDirectoryBlocks(this.directoryBlocks.getText().trim());
            this.directoryBlocksLabel.setEnabled(false);
            this.directoryBlocks.setEnabled(false);
        }
    }

    public final void handleUsageUpdate() {
        if (this.zFolder.getSelection()) {
            this.dataSetDefinition.setUsageType(0);
            this.prefixedDataset.setSelection(true);
            this.dataSetDefinition.setPrefixDSN(true);
            if (this.dataSetType.indexOf(Messages.DataSetDefinitionContent_DATA_SET_TYPE_UNSPECIFIED) >= 0) {
                this.dataSetType.remove(Messages.DataSetDefinitionContent_DATA_SET_TYPE_UNSPECIFIED);
                this.dataSetType.select(0);
                this.dataSetDefinition.setDsType(this.getDataSetValue());
            }
            if (this.dataSetType.indexOf(Messages.DataSetDefinitionContent_DATA_SET_TYPE_SEQUENTIAL) >= 0) {
                this.dataSetType.remove(Messages.DataSetDefinitionContent_DATA_SET_TYPE_SEQUENTIAL);
            }
            this.setSelection(this.dataSetType, this.getDataSetLabel(0));
            this.handleDataSetTypeSelected();
            this.enableDetailsSection(true);
        } else if (this.newDataset.getSelection()) {
            this.dataSetDefinition.setUsageType(1);
            if (this.dataSetType.indexOf(Messages.DataSetDefinitionContent_DATA_SET_TYPE_UNSPECIFIED) >= 0) {
                this.dataSetType.remove(Messages.DataSetDefinitionContent_DATA_SET_TYPE_UNSPECIFIED);
                this.dataSetType.select(0);
                this.dataSetDefinition.setDsType(this.getDataSetValue());
            }
            if (this.dataSetType.indexOf(Messages.DataSetDefinitionContent_DATA_SET_TYPE_SEQUENTIAL) < 0) {
                this.dataSetType.add(Messages.DataSetDefinitionContent_DATA_SET_TYPE_SEQUENTIAL);
            }
            this.setSelection(this.dataSetType, this.getDataSetLabel(0));
            this.handleDataSetTypeSelected();
            this.enableDetailsSection(true);
        } else if (this.temporaryDataset.getSelection()) {
            this.dataSetDefinition.setUsageType(2);
            this.prefixedDataset.setSelection(false);
            this.dataSetDefinition.setPrefixDSN(false);
            this.dsName.setText("");
            this.dataSetDefinition.setDsName("");
            this.validateDataSetName();
            if (this.dataSetType.indexOf(Messages.DataSetDefinitionContent_DATA_SET_TYPE_SEQUENTIAL) < 0) {
                this.dataSetType.add(Messages.DataSetDefinitionContent_DATA_SET_TYPE_SEQUENTIAL, this.dataSetType.getItemCount());
            }
            if (this.dataSetType.indexOf(Messages.DataSetDefinitionContent_DATA_SET_TYPE_UNSPECIFIED) < 0) {
                this.dataSetType.add(Messages.DataSetDefinitionContent_DATA_SET_TYPE_UNSPECIFIED, this.dataSetType.getItemCount());
            }
            this.setSelection(this.dataSetType, this.getDataSetLabel(1));
            this.handleDataSetTypeSelected();
            this.enableDetailsSection(true);
        } else if (this.existingDataset.getSelection()) {
            this.dataSetDefinition.setUsageType(3);
            this.prefixedDataset.setSelection(false);
            this.dataSetDefinition.setPrefixDSN(false);
            if (this.dataSetType.indexOf(Messages.DataSetDefinitionContent_DATA_SET_TYPE_SEQUENTIAL) < 0) {
                this.dataSetType.add(Messages.DataSetDefinitionContent_DATA_SET_TYPE_SEQUENTIAL, this.dataSetType.getItemCount());
            }
            if (this.dataSetType.indexOf(Messages.DataSetDefinitionContent_DATA_SET_TYPE_UNSPECIFIED) < 0) {
                this.dataSetType.add(Messages.DataSetDefinitionContent_DATA_SET_TYPE_UNSPECIFIED, this.dataSetType.getItemCount());
            }
            this.setSelection(this.dataSetType, this.getDataSetLabel(9));
            this.handleDataSetTypeSelected();
            this.clearDetailsSection();
            this.enableDetailsSection(false);
            if ("NULLFILE".equals(this.dsName.getText().trim())) {
                this.enableBlkLreclElements(true);
            }
        }
        this.updateMemberNameEnabled();
        this.updateDataSetTypeEnabled();
        this.updatePrefixEnabled();
        this.updateCompactEnabled();
        this.validate();
        this.setDirty(true);
    }

    private boolean isPds() {
        return this.getDataSetValue() == 3;
    }

    public final void setSelection(Combo combo, String valToSelect) {
        if (valToSelect != null) {
            String[] items = combo.getItems();
            int numItems = items == null ? 0 : items.length;
            int i = 0;
            while (i < numItems) {
                if (valToSelect.equals(items[i])) {
                    combo.select(i);
                    return;
                }
                ++i;
            }
        }
    }

    public final void setValidationControlMap() {
        this.validationControlMap = new HashMap<String, Control>();
        this.validationControlMap.put("volume.unit", (Control)this.volumeSerial);
        this.validationControlMap.put("generic.unit", (Control)this.genericUnit);
        this.validationControlMap.put("space.units", (Control)this.spaceUnits);
        this.validationControlMap.put("directory.blocks", (Control)this.directoryBlocks);
        this.validationControlMap.put("record.format", (Control)this.recordFormat);
        this.validationControlMap.put("record.length", (Control)this.recordLength);
        this.validationControlMap.put("block.size", (Control)this.blockSize);
        this.validationControlMap.put("dataset.nametype", (Control)this.dataSetType);
    }

    public final void updateMemberNameEnabled() {
        boolean enable = this.dataSetDefinition.getUsageType() == 3 || this.dataSetDefinition.getUsageType() == 2;
        this.memberName.setEnabled(enable);
        this.memberName.setEditable(enable);
        this.memberNameLabel.setEnabled(enable);
    }

    public final void updateDataSetTypeEnabled() {
        boolean enable = this.dataSetDefinition.getUsageType() != 3;
        this.dataSetType.setEnabled(enable);
        this.dataSetTypeLabel.setEnabled(enable);
    }

    public final void updatePrefixEnabled() {
        boolean enable = this.dataSetDefinition.getUsageType() == 1 || this.dataSetDefinition.getUsageType() == 3;
        this.prefixedDataset.setEnabled(enable);
    }

    public final void updateCompactEnabled() {
        boolean enable = this.dataSetDefinition.getUsageType() == 1 || this.dataSetDefinition.getUsageType() == 3;
        this.compactDataset.setEnabled(enable);
    }

    @Override
    public final boolean validate() {
        boolean isValid = true;
        if (!this.validateDataSetName()) {
            isValid = false;
        }
        if (!this.validateMemberName()) {
            isValid = false;
        }
        if (this.zFolder.getSelection() || this.newDataset.getSelection()) {
            if (!this.validateDataClass(true)) {
                isValid = false;
            }
            if (!this.validateStorageClass(true)) {
                isValid = false;
            }
            if (!this.validateManagementClass(true)) {
                isValid = false;
            }
            if (!this.validateVolumeSerial(true)) {
                isValid = false;
            }
            if (!this.validateGenericUnit(true)) {
                isValid = false;
            }
            if (!this.validateSpaceUnits(false)) {
                isValid = false;
            }
            if (!this.validatePrimaryQuantity(false)) {
                isValid = false;
            }
            if (!this.validateSecondaryQuantity(false)) {
                isValid = false;
            }
            if (!this.validateDirectoryBlocks(!this.isPds())) {
                isValid = false;
            }
            if (!this.validateRecordFormat(false)) {
                isValid = false;
            }
            if (!this.validateRecordLength(false)) {
                isValid = false;
            }
            if (!this.validateBlockSize(false)) {
                isValid = false;
            }
            if (!this.crossValidate()) {
                isValid = false;
            }
        } else if (this.existingDataset.getSelection()) {
            if (!this.validateVolumeSerial(true)) {
                isValid = false;
            }
            if (!this.validateGenericUnit(true)) {
                isValid = false;
            }
            if (!this.validateRecordLength(true)) {
                isValid = false;
            }
            if (!this.validateBlockSize(true)) {
                isValid = false;
            }
            if (!this.crossValidate()) {
                isValid = false;
            }
        } else if (this.temporaryDataset.getSelection()) {
            if (!this.validateDataClass(true)) {
                isValid = false;
            }
            if (!this.validateStorageClass(true)) {
                isValid = false;
            }
            if (!this.validateManagementClass(true)) {
                isValid = false;
            }
            if (!this.validateVolumeSerial(true)) {
                isValid = false;
            }
            if (!this.validateGenericUnit(true)) {
                isValid = false;
            }
            if (!this.validateSpaceUnits(true)) {
                isValid = false;
            }
            if (!this.validatePrimaryQuantity(true)) {
                isValid = false;
            }
            if (!this.validateSecondaryQuantity(true)) {
                isValid = false;
            }
            if (!this.validateDirectoryBlocks(!this.isPds())) {
                isValid = false;
            }
            if (!this.validateRecordFormat(true)) {
                isValid = false;
            }
            if (!this.validateRecordLength(true)) {
                isValid = false;
            }
            if (!this.validateBlockSize(true)) {
                isValid = false;
            }
            if (!this.crossValidate()) {
                isValid = false;
            }
        } else {
            this.removeErrorMessage(this.dataClass, (Control)this.dataClass);
            this.removeErrorMessage(this.storageClass, (Control)this.storageClass);
            this.removeErrorMessage(this.managementClass, (Control)this.managementClass);
            this.removeErrorMessage(this.volumeSerial, (Control)this.volumeSerial);
            this.removeErrorMessage(this.genericUnit, (Control)this.genericUnit);
            this.removeErrorMessage(this.primaryQuantity, (Control)this.primaryQuantity);
            this.removeErrorMessage(this.secondaryQuantity, (Control)this.secondaryQuantity);
            this.removeErrorMessage(this.directoryBlocks, (Control)this.directoryBlocks);
            this.removeErrorMessage(this.recordFormat, (Control)this.recordFormat);
            this.removeErrorMessage(this.recordLength, (Control)this.recordLength);
            this.removeErrorMessage(this.blockSize, (Control)this.blockSize);
        }
        this.generalSection.redraw();
        this.detailsSection.redraw();
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private boolean checkValidateEmpty(Text text) {
        return text.getText().trim().equals("");
    }

    private boolean checkValidateOptional(Control control, boolean optional, String msg) {
        if (optional) {
            this.removeErrorMessage(control, control);
            return true;
        }
        this.addErrorMessageForRequiredField(control, msg, control);
        return false;
    }

    public final boolean crossValidate() {
        boolean result = this.validator.crossValidateDefinition(this.dataSetDefinition);
        if (!result) {
            MappingException cvException = this.validator.getCVException();
            String key = cvException.getAttributeId();
            String msg = cvException.getMessage();
            Control id = this.validationControlMap.get(key);
            this.addErrorMessage((Object)id, msg, id);
            this.crossValidationControl = id;
        } else if (this.crossValidationControl != null) {
            this.removeErrorMessage(this.crossValidationControl, this.crossValidationControl);
            this.crossValidationControl = null;
        }
        return result;
    }

    public final boolean validateDataSetName() {
        int validatorReturnCode = 0;
        if (this.dsName.getText().trim().equals("")) {
            if (this.existingDataset.getSelection()) {
                if (this.memberName.getText().trim().equals("")) {
                    this.addErrorMessageForRequiredField(this.dsName, Messages.DataSetDefinitionContent_DSN_OR_MEM_REQ_FOR_EXISTING, (Control)this.dsName);
                    return false;
                }
                this.removeErrorMessage(this.dsName, (Control)this.dsName);
                return true;
            }
            if (this.temporaryDataset.getSelection()) {
                this.removeErrorMessage(this.dsName, (Control)this.dsName);
                return true;
            }
            this.addErrorMessageForRequiredField(this.dsName, Messages.DataSetDefinitionContent_DATA_SET_NAME_REQUIRED, (Control)this.dsName);
            return false;
        }
        boolean isPropertyAllowed = false;
        if (this.existingDataset.getSelection() || this.newDataset.getSelection()) {
            isPropertyAllowed = true;
        }
        if ((validatorReturnCode = this.validator.isValidDSName(this.dsName.getText().trim(), this.temporaryDataset.getSelection(), this.prefixedDataset.getSelection(), isPropertyAllowed)) != 0) {
            this.addErrorMessage((Object)this.dsName, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_PDS_NAME, (Object)(this.temporaryDataset.getSelection() ? this.validator.getTempoDSErrorMessage(validatorReturnCode) : this.validator.getDSNameErrorMessage(validatorReturnCode))), (Control)this.dsName);
            return false;
        }
        this.removeErrorMessage(this.dsName, (Control)this.dsName);
        return true;
    }

    public final boolean validateMemberName() {
        if (this.memberName.getText().trim().equals("")) {
            this.removeErrorMessage(this.memberName, (Control)this.memberName);
            return true;
        }
        int validatorReturnCode = this.validator.isValidMemberName(this.memberName.getText().trim());
        if (validatorReturnCode != 0) {
            this.addErrorMessage((Object)this.memberName, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_MEMBER_NAME, (Object)this.validator.getNamingErrorMessage(validatorReturnCode)), (Control)this.memberName);
            return false;
        }
        this.removeErrorMessage(this.memberName, (Control)this.memberName);
        return true;
    }

    public final boolean validateDataClass() {
        if (this.zFolder.getSelection()) {
            return this.validateDataClass(true);
        }
        if (this.newDataset.getSelection()) {
            return this.validateDataClass(true);
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validateDataClass(true);
        }
        this.removeErrorMessage(this.dataClass, (Control)this.dataClass);
        return false;
    }

    public final boolean validateDataClass(boolean optional) {
        if (this.checkValidateEmpty(this.dataClass)) {
            return this.checkValidateOptional((Control)this.dataClass, optional, ReqDataClass);
        }
        int validatorReturnCode = this.validator.isValidDataClass(this.dataClass.getText().trim());
        if (validatorReturnCode != 0) {
            this.addErrorMessage((Object)this.dataClass, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_DATA_CLASS, (Object)this.validator.getAtrClsErrorMessage(validatorReturnCode, "8")), (Control)this.dataClass);
            return false;
        }
        this.removeErrorMessage(this.dataClass, (Control)this.dataClass);
        return true;
    }

    public final boolean validateStorageClass() {
        if (this.zFolder.getSelection()) {
            return this.validateStorageClass(true);
        }
        if (this.newDataset.getSelection()) {
            return this.validateStorageClass(true);
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validateStorageClass(true);
        }
        this.removeErrorMessage(this.storageClass, (Control)this.storageClass);
        return false;
    }

    public final boolean validateStorageClass(boolean optional) {
        if (this.checkValidateEmpty(this.storageClass)) {
            return this.checkValidateOptional((Control)this.storageClass, optional, ReqStorageClass);
        }
        int validatorReturnCode = this.validator.isValidStorageClass(this.storageClass.getText().trim());
        if (validatorReturnCode != 0) {
            this.addErrorMessage((Object)this.storageClass, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_STORAGE_CLASS, (Object)this.validator.getAtrClsErrorMessage(validatorReturnCode, "8")), (Control)this.storageClass);
            return false;
        }
        this.removeErrorMessage(this.storageClass, (Control)this.storageClass);
        return true;
    }

    public final boolean validateManagementClass() {
        if (this.zFolder.getSelection()) {
            return this.validateManagementClass(true);
        }
        if (this.newDataset.getSelection()) {
            return this.validateManagementClass(true);
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validateManagementClass(true);
        }
        this.removeErrorMessage(this.managementClass, (Control)this.managementClass);
        return false;
    }

    public final boolean validateManagementClass(boolean optional) {
        if (this.checkValidateEmpty(this.managementClass)) {
            return this.checkValidateOptional((Control)this.managementClass, optional, ReqManagementClass);
        }
        int validatorReturnCode = this.validator.isValidMngtClass(this.managementClass.getText().trim());
        if (validatorReturnCode != 0) {
            this.addErrorMessage((Object)this.managementClass, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_MANAGEMENT_CLASS, (Object)this.validator.getAtrClsErrorMessage(validatorReturnCode, "8")), (Control)this.managementClass);
            return false;
        }
        this.removeErrorMessage(this.managementClass, (Control)this.managementClass);
        return true;
    }

    public final boolean validateVolumeSerial() {
        if (this.zFolder.getSelection()) {
            return this.validateVolumeSerial(true);
        }
        if (this.newDataset.getSelection()) {
            return this.validateVolumeSerial(true);
        }
        if (this.existingDataset.getSelection()) {
            return this.validateVolumeSerial(true);
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validateVolumeSerial(true);
        }
        this.removeErrorMessage(this.volumeSerial, (Control)this.volumeSerial);
        return false;
    }

    public final boolean validateVolumeSerial(boolean optional) {
        int validatorReturnCode;
        if (this.checkValidateEmpty(this.volumeSerial)) {
            return this.checkValidateOptional((Control)this.volumeSerial, optional, ReqVolumeSerial);
        }
        int n = validatorReturnCode = this.dataSetDefinition.getUsageType() == 2 ? this.validator.isValidMultiVolumes(this.volumeSerial.getText().trim()) : this.validator.isValidVolumeSerial(this.volumeSerial.getText().trim());
        if (validatorReturnCode != 0) {
            this.addErrorMessage((Object)this.volumeSerial, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_VOLUME_SERIAL, (Object)this.validator.getMultiVolErrorMessage(validatorReturnCode, "6")), (Control)this.volumeSerial);
            return false;
        }
        this.removeErrorMessage(this.volumeSerial, (Control)this.volumeSerial);
        return true;
    }

    public final boolean validateGenericUnit() {
        if (this.zFolder.getSelection()) {
            return this.validateGenericUnit(true);
        }
        if (this.newDataset.getSelection()) {
            return this.validateGenericUnit(true);
        }
        if (this.existingDataset.getSelection()) {
            return this.validateGenericUnit(false);
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validateGenericUnit(true);
        }
        this.removeErrorMessage(this.genericUnit, (Control)this.genericUnit);
        return false;
    }

    public final boolean validateGenericUnit(boolean optional) {
        if (this.checkValidateEmpty(this.genericUnit)) {
            return this.checkValidateOptional((Control)this.genericUnit, optional, ReqGenericUnit);
        }
        int validatorReturnCode = this.validator.isValidGenericUnit(this.genericUnit.getText().trim());
        if (validatorReturnCode != 0) {
            this.addErrorMessage((Object)this.genericUnit, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_GENERIC_UNIT, (Object)this.validator.getGenericUnitErrorMessage(validatorReturnCode, "8", "2")), (Control)this.genericUnit);
            return false;
        }
        this.removeErrorMessage(this.genericUnit, (Control)this.genericUnit);
        return true;
    }

    public final boolean validateSpaceUnits() {
        if (this.zFolder.getSelection()) {
            return this.validateSpaceUnits(false);
        }
        if (this.newDataset.getSelection()) {
            return this.validateSpaceUnits(false);
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validateSpaceUnits(true);
        }
        this.removeErrorMessage(this.spaceUnits, (Control)this.spaceUnits);
        return false;
    }

    public final boolean validateSpaceUnits(boolean optional) {
        if (this.spaceUnits.getSelectionIndex() == 0) {
            return this.checkValidateOptional((Control)this.spaceUnits, optional, ReqSpaceUnits);
        }
        this.removeErrorMessage(this.spaceUnits, (Control)this.spaceUnits);
        return true;
    }

    public final boolean validatePrimaryQuantity() {
        if (this.zFolder.getSelection()) {
            return this.validatePrimaryQuantity(false);
        }
        if (this.newDataset.getSelection()) {
            return this.validatePrimaryQuantity(false);
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validatePrimaryQuantity(true);
        }
        this.removeErrorMessage(this.primaryQuantity, (Control)this.primaryQuantity);
        return false;
    }

    public final boolean validatePrimaryQuantity(boolean optional) {
        if (this.checkValidateEmpty(this.primaryQuantity)) {
            return this.checkValidateOptional((Control)this.primaryQuantity, optional, ReqPrimaryQuantity);
        }
        int validatorReturnCode = this.validator.isValidPrimary(this.primaryQuantity.getText().trim());
        if (validatorReturnCode != 0) {
            this.addErrorMessage((Object)this.primaryQuantity, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_PRIMARY_QUANTITY, (Object)this.validator.getAtrQuantErrorMessage(validatorReturnCode, MaxQuantity)), (Control)this.primaryQuantity);
            return false;
        }
        this.removeErrorMessage(this.primaryQuantity, (Control)this.primaryQuantity);
        return true;
    }

    public final boolean validateSecondaryQuantity() {
        if (this.zFolder.getSelection()) {
            return this.validateSecondaryQuantity(true);
        }
        if (this.newDataset.getSelection()) {
            return this.validateSecondaryQuantity(true);
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validateSecondaryQuantity(true);
        }
        this.removeErrorMessage(this.secondaryQuantity, (Control)this.secondaryQuantity);
        return false;
    }

    public final boolean validateSecondaryQuantity(boolean optional) {
        if (this.checkValidateEmpty(this.secondaryQuantity)) {
            return this.checkValidateOptional((Control)this.secondaryQuantity, optional, ReqSecondaryQuantity);
        }
        int validatorReturnCode = this.validator.isValidSecondary(this.secondaryQuantity.getText().trim());
        if (validatorReturnCode != 0) {
            this.addErrorMessage((Object)this.secondaryQuantity, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_SECONDARY_QUANTITY, (Object)this.validator.getAtrQuantErrorMessage(validatorReturnCode, "0", MaxQuantity)), (Control)this.secondaryQuantity);
            return false;
        }
        this.removeErrorMessage(this.secondaryQuantity, (Control)this.secondaryQuantity);
        return true;
    }

    public final boolean validateDirectoryBlocks() {
        if (this.zFolder.getSelection()) {
            return this.validateSecondaryQuantity(!this.isPds());
        }
        if (this.newDataset.getSelection()) {
            return this.validateSecondaryQuantity(!this.isPds());
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validateSecondaryQuantity(!this.isPds());
        }
        this.removeErrorMessage(this.directoryBlocks, (Control)this.directoryBlocks);
        return false;
    }

    public final boolean validateDirectoryBlocks(boolean optional) {
        if (this.checkValidateEmpty(this.directoryBlocks)) {
            return this.checkValidateOptional((Control)this.directoryBlocks, optional, ReqDirectoryBlocks);
        }
        int validatorReturnCode = this.validator.isValidDirBlock(this.directoryBlocks.getText().trim());
        if (validatorReturnCode != 0) {
            this.addErrorMessage((Object)this.directoryBlocks, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_DIR_BLOCKS, (Object)this.validator.getAtrBlockErrorMessage(validatorReturnCode)), (Control)this.directoryBlocks);
            return false;
        }
        this.removeErrorMessage(this.directoryBlocks, (Control)this.directoryBlocks);
        return true;
    }

    public final boolean validateRecordFormat() {
        if (this.zFolder.getSelection()) {
            return this.validateRecordFormat(false);
        }
        if (this.newDataset.getSelection()) {
            return this.validateRecordFormat(false);
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validateRecordFormat(true);
        }
        this.removeErrorMessage(this.recordFormat, (Control)this.recordFormat);
        return false;
    }

    public final boolean validateRecordFormat(boolean optional) {
        if (this.recordFormat.getSelectionIndex() == 0) {
            return this.checkValidateOptional((Control)this.recordFormat, optional, ReqRecordFormat);
        }
        this.removeErrorMessage(this.recordFormat, (Control)this.recordFormat);
        return true;
    }

    public final boolean validateRecordLength() {
        if (this.zFolder.getSelection()) {
            return this.validateRecordLength(false);
        }
        if (this.newDataset.getSelection()) {
            return this.validateRecordLength(false);
        }
        if (this.existingDataset.getSelection()) {
            return this.validateRecordLength(true);
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validateRecordLength(true);
        }
        this.removeErrorMessage(this.recordLength, (Control)this.recordLength);
        return false;
    }

    public final boolean validateRecordLength(boolean optional) {
        if (this.checkValidateEmpty(this.recordLength)) {
            return this.checkValidateOptional((Control)this.recordLength, optional, ReqRecordLength);
        }
        int validatorReturnCode = this.validator.isValidRcdLength(this.recordLength.getText().trim());
        if (validatorReturnCode != 0) {
            this.addErrorMessage((Object)this.recordLength, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_RECORD_LENGTH, (Object)this.validator.getAtrQuantErrorMessage(validatorReturnCode, MaxLrecl)), (Control)this.recordLength);
            return false;
        }
        this.removeErrorMessage(this.recordLength, (Control)this.recordLength);
        return true;
    }

    public final boolean validateBlockSize() {
        if (this.zFolder.getSelection()) {
            return this.validateBlockSize(false);
        }
        if (this.newDataset.getSelection()) {
            return this.validateBlockSize(false);
        }
        if (this.existingDataset.getSelection()) {
            return this.validateBlockSize(true);
        }
        if (this.temporaryDataset.getSelection()) {
            return this.validateBlockSize(true);
        }
        this.removeErrorMessage(this.blockSize, (Control)this.blockSize);
        return false;
    }

    public final boolean validateBlockSize(boolean optional) {
        if (this.checkValidateEmpty(this.blockSize)) {
            return this.checkValidateOptional((Control)this.blockSize, optional, ReqBlockSize);
        }
        int validatorReturnCode = this.validator.isValidBlockSize(this.blockSize.getText().trim());
        if (validatorReturnCode != 0) {
            this.addErrorMessage((Object)this.blockSize, NLS.bind((String)Messages.DataSetDefinitionContent_INVALID_BLOCK_SIZE, (Object)this.validator.getAtrBlockErrorMessage(validatorReturnCode, Integer.toString(0), Integer.toString(32760))), (Control)this.blockSize);
            return false;
        }
        this.removeErrorMessage(this.blockSize, (Control)this.blockSize);
        return true;
    }
}

