/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.content;

import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionEditor;
import com.ibm.team.ui.editor.TeamFormPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractContentCommon {
    protected IEnterpriseConfiguration configuration;
    protected ISystemDefinitionDialog dialog;
    protected ISystemDefinitionEditor editor;
    protected TeamFormPage editorPage;

    public abstract boolean validate();

    protected void setPageErrorIndicator(boolean isError) {
        if (this.editor != null) {
            Image image = null;
            if (isError && this.editor.isSaveAttempted()) {
                image = Activator.getImage("icons/ovr16/failed_ovr.gif");
            }
            this.editor.setPageImage(this.editorPage.getIndex(), image);
        }
    }

    public void addErrorMessage(Object id, String message, Control control) {
        if (this.editor != null) {
            this.editor.addErrorMessage(id, message, control, this.editorPage.getIndex());
        } else if (this.dialog != null) {
            this.dialog.addErrorMessage(id, message, control);
        }
    }

    public void addErrorMessageForRequiredField(Object id, String message, Control control) {
        if (this.editor != null) {
            if (this.editor.isSaveAttempted()) {
                this.editor.addErrorMessage(id, message, control, this.editorPage.getIndex());
            }
        } else if (this.dialog != null && this.dialog.isOkPressed()) {
            this.dialog.addErrorMessage(id, message, control);
        }
    }

    public void addErrorMessage(Object id, String message, IStatus status) {
        if (this.editor != null) {
            this.editor.addErrorMessage(id, message, status);
        }
    }

    public void removeErrorMessage(Object id, Control control) {
        if (this.editor != null) {
            this.editor.removeErrorMessage(id, control);
        } else if (this.dialog != null) {
            this.dialog.removeErrorMessage(id, control);
        }
    }

    public void removeErrorMessage(Object id) {
        if (this.editor != null) {
            this.editor.removeErrorMessage(id);
        } else if (this.dialog != null) {
            this.dialog.removeErrorMessage(id);
        }
    }

    protected void setDirty(boolean dirty) {
        if (this.editor != null) {
            this.editor.setDirty(dirty);
            this.editor.fireDirtyPropertyChangeEvent();
        }
    }
}

