/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui;

import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class EditorSystemDefinitionCache
implements ISystemDefinitionCache {
    private ITeamRepository fRepository;
    private ItemHandleAwareHashMap fEditorCache;

    public EditorSystemDefinitionCache(ITeamRepository repository) {
        this.fRepository = repository;
    }

    @Override
    public ISystemDefinition getSystemDefinition(ISystemDefinitionHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        ISystemDefinitionModelClient client;
        ISystemDefinition definition;
        if (this.fEditorCache == null) {
            this.fEditorCache = new ItemHandleAwareHashMap();
        }
        if ((definition = (ISystemDefinition)this.fEditorCache.get((Object)handle)) == null && (definition = (client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.fRepository)).fetchSystemDefinitionComplete(handle, true, monitor)) != null) {
            this.fEditorCache.put((Object)handle, (Object)definition);
        }
        return definition;
    }

    @Override
    public void clear() {
        if (this.fEditorCache != null) {
            this.fEditorCache.clear();
        }
    }

    @Override
    public List<ISystemDefinition> getSystemDefinitions(List<ISystemDefinitionHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fEditorCache == null) {
            this.fEditorCache = new ItemHandleAwareHashMap();
        }
        ArrayList<ISystemDefinition> result = new ArrayList<ISystemDefinition>();
        ArrayList<ISystemDefinitionHandle> toFetch = new ArrayList<ISystemDefinitionHandle>();
        int i = 0;
        while (i < handles.size()) {
            ISystemDefinition definition = (ISystemDefinition)this.fEditorCache.get((Object)handles.get(i));
            if (definition == null) {
                toFetch.add(handles.get(i));
            } else {
                result.add(definition);
            }
            ++i;
        }
        if (!toFetch.isEmpty()) {
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.fRepository);
            List defs = client.fetchSystemDefinitionsComplete(toFetch, true, monitor);
            result.addAll(defs);
        }
        return result;
    }
}

