/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui;

import com.ibm.team.enterprise.common.ui.IMenuAction;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ActionsContributionsRegistry {
    private boolean initialized;
    private final List<IConfigurationElement> contributions = new ArrayList<IConfigurationElement>();
    private final HashMap<String, List<IConfigurationElement>> actionsFor = new HashMap();
    public static final ActionsContributionsRegistry singleton = new ActionsContributionsRegistry();

    private void initialize() {
        this.initialized = true;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor("com.ibm.team.enterprise.systemdefinition.ui.systemDefinitionNodeActions");
        int i = 0;
        while (i < conf.length) {
            List<Object> contributions;
            IConfigurationElement currentConf = conf[i];
            this.contributions.add(currentConf);
            String actionFor = currentConf.getAttribute("actionFor");
            if (this.actionsFor.containsKey(actionFor)) {
                contributions = this.actionsFor.get(actionFor);
                contributions.add(currentConf);
            } else {
                contributions = new ArrayList<IConfigurationElement>();
                contributions.add(currentConf);
                this.actionsFor.put(actionFor, contributions);
            }
            ++i;
        }
    }

    public List<IConfigurationElement> getContributions() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.contributions;
    }

    public List<IConfigurationElement> getContributionsFor(String actionFor) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.actionsFor.containsKey(actionFor)) {
            return this.actionsFor.get(actionFor);
        }
        return new ArrayList<IConfigurationElement>();
    }

    public IMenuAction getAction(IConfigurationElement contribution) {
        if (!this.initialized) {
            this.initialize();
        }
        IMenuAction result = null;
        try {
            result = (IMenuAction)contribution.createExecutableExtension("class");
        }
        catch (Exception e) {
            Activator.log(new InvocationTargetException(e, Messages.action_contribution_initialization_failure));
        }
        return result;
    }
}

