/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.validation;

import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResultFeedParser;
import com.ibm.team.enterprise.systemdefinition.common.IProjectAreaNameRetriever;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionService;
import com.ibm.team.enterprise.systemdefinition.common.validation.ISystemDefinitionValidator;
import com.ibm.team.enterprise.systemdefinition.common.validation.SystemDefinitionValidationException;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingFunction;
import com.ibm.team.enterprise.zos.systemdefinition.common.nls.CommonMessage;
import com.ibm.team.enterprise.zos.systemdefinition.common.util.SystemDefinitionQuery;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class FunctionDefinitionDuplicateIdValidator
implements ISystemDefinitionValidator {
    @Override
    public void validate(ISystemDefinition systemDefinition, ISystemDefinitionService systemDefinitionService, IProjectAreaNameRetriever projectAreaRetriever) throws SystemDefinitionValidationException, TeamRepositoryException {
        if (this.isCorrectType(systemDefinition) && systemDefinition instanceof IPackagingFunction) {
            String id = ((IPackagingFunction)systemDefinition).getId();
            if (id == null) {
                id = "????";
            }
            String query = SystemDefinitionQuery.getFunctionDefinitionUuidForIdQuery(id, systemDefinition.getPlatform());
            try {
                String results = systemDefinitionService.runSelectQuery(query);
                SelectResultFeedParser parser = new SelectResultFeedParser();
                List selectResults = parser.parse((InputStream)new ByteArrayInputStream(results.getBytes("UTF-8")));
                if (selectResults.size() > 0) {
                    String foundUuid = null;
                    String foundProjectAreaUuid = "";
                    String foundProjectAreaName = "";
                    for (Binding binding : ((SelectResult)selectResults.get(0)).getBindings()) {
                        if (binding.getName().equals("uuid")) {
                            foundUuid = binding.getValue();
                            continue;
                        }
                        if (!binding.getName().equals("projectAreaUUID")) continue;
                        foundProjectAreaUuid = binding.getValue();
                        foundProjectAreaName = projectAreaRetriever.getProjectAreaName(foundProjectAreaUuid);
                    }
                    if (foundUuid != null && !systemDefinition.isNew() && foundUuid.equals(systemDefinition.getUuid())) {
                        return;
                    }
                    throw new SystemDefinitionValidationException(NLS.bind((String)CommonMessage.getCommonString("FunctionDefinitionError.2"), (Object)id, (Object)foundProjectAreaName));
                }
            }
            catch (SystemDefinitionValidationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private boolean isCorrectType(ISystemDefinition systemDefinition) {
        return systemDefinition.getType().equals("functiondefinition");
    }
}

