/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.util;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHistoryProcessor;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDTO;
import com.ibm.team.enterprise.systemdefinition.common.dto.DeltaType;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.common.util.ChangeLogUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.zos.IZosSystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.zos.ZosChangeLogUtil;

public class ZosSystemDefinitionHistoryProcessor
implements ISystemDefinitionHistoryProcessor {
    @Override
    public void process(ISystemDefinition oldSystemDefinition, ISystemDefinition newSystemDefinition, ChangeLogDTO changeLog) {
        if (newSystemDefinition instanceof IZosTranslator) {
            this.addTranslatorDeltas(oldSystemDefinition, (IZosTranslator)newSystemDefinition, changeLog);
        } else if (newSystemDefinition instanceof IDataSetDefinition) {
            this.addDataSetDefinitionDeltas(oldSystemDefinition, (IDataSetDefinition)newSystemDefinition, changeLog);
        }
    }

    private void addTranslatorDeltas(ISystemDefinition oldSystemDefinition, IZosTranslator newTranslator, ChangeLogDTO changeLog) {
        if (changeLog == null) {
            return;
        }
        int oldMaxRC = 0;
        boolean oldLinkEdit = false;
        boolean oldIgnore = false;
        Integer oldISPFLogPublishType = null;
        Integer oldISPFLogConsolidate = null;
        boolean oldISPFLogCompact = false;
        IZosTranslator oldTranslator = null;
        if (oldSystemDefinition instanceof IZosTranslator) {
            oldTranslator = (IZosTranslator)oldSystemDefinition;
            oldLinkEdit = oldTranslator.isLinkEdit();
            oldIgnore = oldTranslator.isNonImpacting();
            oldMaxRC = oldTranslator.getMaxRC();
            oldISPFLogPublishType = oldTranslator.getISPFLogPublishType();
            oldISPFLogConsolidate = oldTranslator.getISPFLogConsolidate();
            oldISPFLogCompact = oldTranslator.isISPFLogCompact();
        }
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZTRANSLATOR_IS_LINK_EDIT_TAG.getWholeTagName(), oldLinkEdit, newTranslator.isLinkEdit(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_NON_IMPACTING_TAG.getWholeTagName(), oldIgnore, newTranslator.isNonImpacting(), false, oldSystemDefinition == null);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_PUBLISH_TYPE.getWholeTagName(), oldISPFLogPublishType, newTranslator.getISPFLogPublishType(), null, false, false);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_CONSOLIDATE.getWholeTagName(), oldISPFLogConsolidate, newTranslator.getISPFLogConsolidate(), null, false, false);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_COMPACT.getWholeTagName(), oldISPFLogCompact, newTranslator.isISPFLogCompact(), false, oldSystemDefinition == null);
        ZosChangeLogUtil.generateCallMethodChangeLogDelta(changeLog, oldTranslator, newTranslator);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZTRANSLATOR_MAXRC_TAG.getWholeTagName(), oldMaxRC, newTranslator.getMaxRC(), false, oldSystemDefinition == null);
        ZosChangeLogUtil.generateDDConcantenationChangeLogDelta(changeLog, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCATS_TAG.getWholeTagName(), oldTranslator == null ? null : oldTranslator.getConcatenations(), newTranslator.getConcatenations(), oldSystemDefinition == null);
        ZosChangeLogUtil.generateDDAllocationChangeLogDelta(changeLog, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATIONS_TAG.getWholeTagName(), oldTranslator == null ? null : oldTranslator.getDDAllocations(), newTranslator.getDDAllocations(), oldSystemDefinition == null);
    }

    private void addDataSetDefinitionDeltas(ISystemDefinition oldSystemDefinition, IDataSetDefinition newDSDef, ChangeLogDTO changeLog) {
        IDataSetDefinition oldDataset = null;
        if (oldSystemDefinition != null && oldSystemDefinition instanceof IDataSetDefinition) {
            oldDataset = (IDataSetDefinition)oldSystemDefinition;
        }
        Integer oldUsageType = null;
        String oldDSName = null;
        String oldMember = null;
        boolean oldIsPrefix = false;
        boolean oldIgnore = false;
        boolean oldCompact = false;
        String oldDataClass = null;
        String oldStorageClass = null;
        String oldManClass = null;
        String oldVolSeri = null;
        String oldGenUnit = null;
        String oldSpaceUnits = null;
        String oldPrimQua = null;
        String oldSecQua = null;
        String oldDirecBlock = null;
        String oldRecordForm = null;
        String oldRecordLen = null;
        String oldBlockSize = null;
        String oldAdditionalParm = null;
        Integer oldDSType = null;
        if (oldDataset != null) {
            oldUsageType = oldDataset.getUsageType();
            oldDSName = oldDataset.getDsName();
            oldMember = oldDataset.getDsMember();
            oldIsPrefix = oldDataset.isPrefixDSN();
            oldIgnore = oldDataset.isNonImpacting();
            oldCompact = oldDataset.isCompact();
            oldDataClass = oldDataset.getDataClass();
            oldStorageClass = oldDataset.getStorageClass();
            oldManClass = oldDataset.getManagementClass();
            oldVolSeri = oldDataset.getVolumeSerial();
            oldGenUnit = oldDataset.getGenericUnit();
            oldSpaceUnits = oldDataset.getSpaceUnits();
            oldPrimQua = oldDataset.getPrimaryQuantity();
            oldSecQua = oldDataset.getSecondaryQuantity();
            oldDirecBlock = oldDataset.getDirectoryBlocks();
            oldRecordForm = oldDataset.getRecordFormat();
            oldRecordLen = oldDataset.getRecordLength();
            oldBlockSize = oldDataset.getBlockSize();
            oldAdditionalParm = oldDataset.getAdditionalParm();
            oldDSType = oldDataset.getDsType();
        }
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), SystemDefinitionUtil.RESOURCE_DEF_USAGE_TYPE_TAG.getWholeTagName(), oldUsageType, newDSDef.getUsageType(), oldSystemDefinition == null ? DeltaType.ADD : DeltaType.CHANGE, false, false);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_DSNAME_TAG.getWholeTagName(), oldDSName, newDSDef.getDsName(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_MEMBER_TAG.getWholeTagName(), oldMember, newDSDef.getDsMember(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_PREFIX_DSN_TAG.getWholeTagName(), oldIsPrefix, newDSDef.isPrefixDSN(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), SystemDefinitionUtil.SYSTEM_DEF_NON_IMPACTING_TAG.getWholeTagName(), oldIgnore, newDSDef.isNonImpacting(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_COMPACT_TAG.getWholeTagName(), oldCompact, newDSDef.isCompact(), false, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_DATA_CLASS_TAG.getWholeTagName(), oldDataClass, newDSDef.getDataClass(), true, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_STORAGE_CLASS_TAG.getWholeTagName(), oldStorageClass, newDSDef.getStorageClass(), true, oldSystemDefinition == null);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_MANAGEMENT_CLASS_TAG.getWholeTagName(), oldManClass, newDSDef.getManagementClass(), true, oldSystemDefinition == null);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_VOLUME_SERIAL_TAG.getWholeTagName(), oldVolSeri, newDSDef.getVolumeSerial(), oldSystemDefinition == null ? DeltaType.ADD : DeltaType.CHANGE, false, false);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_GENERIC_UNIT_TAG.getWholeTagName(), oldGenUnit, newDSDef.getGenericUnit(), oldSystemDefinition == null ? DeltaType.ADD : DeltaType.CHANGE, false, false);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_SPACE_UNITS_TAG.getWholeTagName(), oldSpaceUnits, newDSDef.getSpaceUnits(), oldSystemDefinition == null ? DeltaType.ADD : DeltaType.CHANGE, false, false);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_PRIMARY_QUANTITY_TAG.getWholeTagName(), oldPrimQua, newDSDef.getPrimaryQuantity(), oldSystemDefinition == null ? DeltaType.ADD : DeltaType.CHANGE, false, false);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_SECONDARY_QUANTITY_TAG.getWholeTagName(), oldSecQua, newDSDef.getSecondaryQuantity(), oldSystemDefinition == null ? DeltaType.ADD : DeltaType.CHANGE, false, false);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_DIRECTORY_BLOCKS_TAG.getWholeTagName(), oldDirecBlock, newDSDef.getDirectoryBlocks(), oldSystemDefinition == null ? DeltaType.ADD : DeltaType.CHANGE, false, false);
        ChangeLogUtil.generateChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_RECORD_FORMAT_TAG.getWholeTagName(), oldRecordForm, newDSDef.getRecordFormat(), false, oldSystemDefinition == null);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_RECORD_LENGTH_TAG.getWholeTagName(), oldRecordLen, newDSDef.getRecordLength(), oldSystemDefinition == null ? DeltaType.ADD : DeltaType.CHANGE, false, false);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_BLOCK_SIZE_TAG.getWholeTagName(), oldBlockSize, newDSDef.getBlockSize(), oldSystemDefinition == null ? DeltaType.ADD : DeltaType.CHANGE, false, false);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_ADD_PARM_TAG.getWholeTagName(), oldAdditionalParm, newDSDef.getAdditionalParm(), oldSystemDefinition == null ? DeltaType.ADD : DeltaType.CHANGE, false, false);
        ChangeLogUtil.addValuesChangeLogDelta(changeLog.getChanges(), IZosSystemDefinitionUtil.ZDATASETDEFINITION_TYPE_TAG.getWholeTagName(), oldDSType, newDSDef.getDsType(), null, false, false);
    }
}

