/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IHFSOutput;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.parsers.AbstractTranslatorParser;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.TagWithNS;
import com.ibm.team.enterprise.systemdefinition.common.util.zos.IZosSystemDefinitionUtil;
import com.ibm.team.enterprise.zos.systemdefinition.common.IConcatenation;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDDAllocation;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataDefinitionEntry;
import com.ibm.team.enterprise.zos.systemdefinition.common.IHFSDD;
import com.ibm.team.enterprise.zos.systemdefinition.common.IZosTranslator;
import com.ibm.team.enterprise.zos.systemdefinition.common.ZosSystemDefinitionFactory;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.ZosTranslator;
import com.ibm.team.enterprise.zos.systemdefinition.common.util.ZosTranslatorUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ZosTranslatorParser
extends AbstractTranslatorParser
implements ISystemDefinitionParser {
    @Override
    protected ITranslator newTranslator() {
        return new ZosTranslator();
    }

    @Override
    protected void parseTranslator(Element rdfDescriptionElement, ITranslator translator) {
        NodeList specialTypesElements;
        super.parseTranslator(rdfDescriptionElement, translator);
        IZosTranslator zosTranslator = (IZosTranslator)translator;
        String attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_SET_DEFINITION_UUID_TAG);
        if (attr != null && attr.trim().length() > 0) {
            zosTranslator.setDataDefinitionUuid(UUID.valueOf((String)attr));
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DEFAULT_OPTIONS_TAG)) != null) {
            zosTranslator.setDefaultOptions(attr);
        }
        this.parseConcats(rdfDescriptionElement, zosTranslator);
        this.parseDDAllocations(rdfDescriptionElement, zosTranslator);
        attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_MAXRC_TAG);
        if (attr != null && attr.trim().length() > 0) {
            zosTranslator.setMaxRC(Integer.parseInt(attr));
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_CALL_METHOD_TAG)) != null && attr.trim().length() > 0) {
            zosTranslator.setCallMethod(Integer.parseInt(attr));
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_COMMAND_MEMBER_TAG)) != null) {
            zosTranslator.setCommandMember(attr);
        }
        if ((specialTypesElements = rdfDescriptionElement.getElementsByTagNameNS(IZosSystemDefinitionUtil.ZTRANSLATOR_SPECIAL_TYPES_TAG.getNamespace(), IZosSystemDefinitionUtil.ZTRANSLATOR_SPECIAL_TYPES_TAG.getTagName())).getLength() > 0) {
            String[] specialTypes;
            Element specialTypesElement = (Element)specialTypesElements.item(0);
            String[] stringArray = specialTypes = this.readAttributesFromChildElement(specialTypesElement, IZosSystemDefinitionUtil.ZTRANSLATOR_SPECIAL_TYPE_TAG);
            int n = specialTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String specialType = stringArray[n2];
                if (specialType != null && !"".equals(specialType.trim())) {
                    zosTranslator.getSpecialTypes().add(specialType);
                }
                ++n2;
            }
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDNAME_LIST_TAG)) != null && attr.trim().length() > 0) {
            zosTranslator.setDdnamelist(attr);
        }
        attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_IS_LINK_EDIT_TAG);
        zosTranslator.setLinkEdit(Boolean.parseBoolean(attr));
        attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_PUBLISH_TYPE);
        if (attr != null && attr.trim().length() > 0) {
            zosTranslator.setISPFLogPublishType(Integer.parseInt(attr));
        } else {
            zosTranslator.setISPFLogPublishType(1);
        }
        attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_CONSOLIDATE);
        if (attr != null && attr.trim().length() > 0) {
            zosTranslator.setISPFLogConsolidate(Integer.parseInt(attr));
        } else {
            zosTranslator.setISPFLogConsolidate(0);
        }
        attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_COMPACT);
        zosTranslator.setISPFLogCompact(Boolean.parseBoolean(attr));
    }

    private void parseConcats(Element rdfDescriptionElement, IZosTranslator translator) {
        TagWithNS concatTag = IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_TAG;
        NodeList nodeList = rdfDescriptionElement.getElementsByTagNameNS(concatTag.getNamespace(), concatTag.getTagName());
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                this.parseConcat((Element)nodeList.item(i), translator);
                ++i;
            }
        }
    }

    private void parseConcat(Element concatElement, IZosTranslator translator) {
        TagWithNS dataDefinitionTag;
        NodeList nodeList;
        IConcatenation concat = ZosSystemDefinitionFactory.createConcatenation();
        String attr = this.readAttributeFromChildElement(concatElement, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_NAME_TAG);
        if (attr != null) {
            concat.setName(attr);
        }
        try {
            attr = this.readAttributeFromChildElement(concatElement, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_CONDITION_TAG);
            if (attr != null) {
                concat.setCondition(attr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((nodeList = concatElement.getElementsByTagNameNS((dataDefinitionTag = IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TAG).getNamespace(), dataDefinitionTag.getTagName())) != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                IDataDefinitionEntry dataDefinition = ZosSystemDefinitionFactory.createDataDefinitionEntry();
                Element dataDefinitionElement = (Element)nodeList.item(i);
                attr = this.readAttributeFromChildElement(dataDefinitionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_MEMBER_TAG);
                if (attr != null && attr.trim().length() > 0) {
                    dataDefinition.setMember(Boolean.parseBoolean(attr));
                }
                if ((attr = this.readAttributeFromChildElement(dataDefinitionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TYPE_TAG)) != null) {
                    dataDefinition.setKind(attr);
                }
                if ((attr = this.readAttributeFromChildElement(dataDefinitionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_VALUE_TAG)) != null) {
                    dataDefinition.setValue(attr);
                }
                concat.getDataDefinitionEntries().add(dataDefinition);
                ++i;
            }
        }
        translator.getConcatenations().add(concat);
    }

    private void parseDDAllocations(Element rdfDescriptionElement, IZosTranslator translator) {
        TagWithNS ddAllocationTag = IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_TAG;
        NodeList nodeList = rdfDescriptionElement.getElementsByTagNameNS(ddAllocationTag.getNamespace(), ddAllocationTag.getTagName());
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                this.parseDDAllocation((Element)nodeList.item(i), translator);
                ++i;
            }
        }
    }

    private void parseDDAllocation(Element ddAllocationElement, IZosTranslator translator) {
        TagWithNS hfsTag;
        TagWithNS dataDefinitionTag;
        NodeList nodeList;
        IDDAllocation ddAllocation = ZosSystemDefinitionFactory.createDDAllocation();
        String attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_NAME_TAG);
        if (attr != null) {
            ddAllocation.setName(attr);
        }
        if ((attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_KEEP_TAG)) != null && attr.trim().length() > 0) {
            ddAllocation.setKeep(Boolean.parseBoolean(attr));
        }
        if ((attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_MOD_TAG)) != null && attr.trim().length() > 0) {
            ddAllocation.setMod(Boolean.parseBoolean(attr));
        }
        if ((attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_MEMBER_TAG)) != null && attr.trim().length() > 0) {
            ddAllocation.setMember(Boolean.parseBoolean(attr));
        }
        if ((attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_TAG)) != null && attr.trim().length() > 0) {
            ddAllocation.setOutput(Boolean.parseBoolean(attr));
        }
        if ((attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_PUBLISH_TAG)) != null && attr.trim().length() > 0) {
            ddAllocation.setPublish(Boolean.parseBoolean(attr));
        }
        if ((attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_PUBLISH_TYPE_TAG)) != null && attr.trim().length() > 0) {
            if ("null".equalsIgnoreCase(attr)) {
                if (ddAllocation.isPublish()) {
                    ddAllocation.setPublishType(1);
                } else {
                    ddAllocation.setPublishType(0);
                }
            } else if (ddAllocation.isPublish() && Integer.parseInt(attr) == 0) {
                ddAllocation.setPublishType(1);
            } else {
                ddAllocation.setPublishType(Integer.parseInt(attr));
            }
        } else if (ddAllocation.isPublish()) {
            ddAllocation.setPublishType(1);
        } else {
            ddAllocation.setPublishType(0);
        }
        attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_CONSOLIDATE_LOG_TAG);
        if (attr != null && attr.trim().length() > 0) {
            ddAllocation.setConsolidateLog(Integer.parseInt(attr));
        } else {
            ddAllocation.setConsolidateLog(0);
        }
        attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_COMPACT_TAG);
        if (attr != null && attr.trim().length() > 0) {
            ddAllocation.setCompact(Integer.parseInt(attr));
        } else {
            ddAllocation.setCompact(0);
        }
        attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_USEDASINPUT_TAG);
        if (attr != null && attr.trim().length() > 0) {
            ddAllocation.setUsedAsInput(Boolean.parseBoolean(attr));
        }
        if ((nodeList = ddAllocationElement.getElementsByTagNameNS((dataDefinitionTag = IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TAG).getNamespace(), dataDefinitionTag.getTagName())) != null && nodeList.getLength() > 0) {
            Element dataDefinitionElement = (Element)nodeList.item(0);
            IDataDefinitionEntry dataDefinition = ZosSystemDefinitionFactory.createDataDefinitionEntry();
            attr = this.readAttributeFromChildElement(dataDefinitionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_MEMBER_TAG);
            if (attr != null && attr.trim().length() > 0) {
                dataDefinition.setMember(Boolean.parseBoolean(attr));
            }
            if ((attr = this.readAttributeFromChildElement(dataDefinitionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TYPE_TAG)) != null) {
                dataDefinition.setKind(attr);
            }
            if ((attr = this.readAttributeFromChildElement(dataDefinitionElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_VALUE_TAG)) != null) {
                dataDefinition.setValue(attr);
            }
            ddAllocation.setDataDefinitionEntry(dataDefinition);
            attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_SEQUENTIAL_TAG);
            if (attr != null && attr.trim().length() > 0) {
                ddAllocation.setSequential(Boolean.parseBoolean(attr));
            }
            if ((attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_DEPLOYTYPE_TAG)) != null && attr.trim().length() > 0) {
                ddAllocation.setDeployType(attr);
            }
        }
        if ((nodeList = ddAllocationElement.getElementsByTagNameNS((hfsTag = IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_TAG).getNamespace(), hfsTag.getTagName())) != null && nodeList.getLength() > 0) {
            Element hfsElement = (Element)nodeList.item(0);
            IHFSDD dd = ZosSystemDefinitionFactory.createHFSDD();
            attr = this.readAttributeFromChildElement(hfsElement, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH);
            if (attr != null && attr.trim().length() > 0) {
                dd.setPath(attr);
            }
            if ((attr = this.readAttributeFromChildElement(hfsElement, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH_PATHDISP)) != null) {
                dd.setPathDisp(IHFSDD.HFSPathDisp.get(attr));
            }
            if ((attr = this.readAttributeFromChildElement(hfsElement, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH_PERM)) != null) {
                dd.setPathPerm(attr);
            }
            if ((attr = this.readAttributeFromChildElement(hfsElement, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_FILETYPE)) != null) {
                dd.setFileType(IHFSDD.HFSFileType.get(attr));
            }
            if ((attr = this.readAttributeFromChildElement(hfsElement, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH_PATHOPTS)) != null) {
                String[] stringArray = attr.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    dd.getPathOpts().add(s);
                    ++n2;
                }
            }
            ddAllocation.setHfs(dd);
        }
        if ((attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_NAME_KIND_TAG)) != null && attr.trim().length() > 0) {
            ddAllocation.setOutputNameKind(ITranslator.OutputNameKind.valueOf(attr));
            if (ddAllocation.getOutputNameKind() != ITranslator.OutputNameKind.SAME_AS_INPUT && (attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_NAME_TAG)) != null && attr.trim().length() > 0) {
                ddAllocation.setOutputName(attr);
            }
        }
        try {
            attr = this.readAttributeFromChildElement(ddAllocationElement, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_CONDITION_TAG);
            if (attr != null) {
                ddAllocation.setCondition(attr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        translator.getDDAllocations().add(ddAllocation);
    }

    @Override
    protected Element convertToRdfElement(Document doc, ISystemDefinition systemDefinition) {
        Element rdfElement = super.convertToRdfElement(doc, systemDefinition);
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(IZosSystemDefinitionUtil.ZTRANSLATOR_NAMESPACE.getPrefix()).toString());
        attr.setValue(IZosSystemDefinitionUtil.ZTRANSLATOR_NAMESPACE.getNamespace());
        rdfElement.setAttributeNode(attr);
        return rdfElement;
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        IZosTranslator translator = (IZosTranslator)systemDefinition;
        if (translator.getDataDefinitionUuid() != null) {
            this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_SET_DEFINITION_UUID_TAG, translator.getDataDefinitionUuid().getUuidValue());
        }
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DEFAULT_OPTIONS_TAG, translator.getDefaultOptions());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_CALL_METHOD_TAG, String.valueOf(translator.getCallMethod()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_COMMAND_MEMBER_TAG, String.valueOf(translator.getCommandMember()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_MAXRC_TAG, String.valueOf(translator.getMaxRC()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDNAME_LIST_TAG, String.valueOf(translator.getDdnamelist()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_IS_LINK_EDIT_TAG, String.valueOf(translator.isLinkEdit()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_PUBLISH_TYPE, String.valueOf(translator.getISPFLogPublishType()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_CONSOLIDATE, String.valueOf(translator.getISPFLogConsolidate()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_COMPACT, String.valueOf(translator.isISPFLogCompact()));
        Element specialTypesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_SPECIAL_TYPES_TAG);
        for (String specialType : translator.getSpecialTypes()) {
            if (specialType == null || "".equals(specialType.trim())) continue;
            this.createPropertyElementNS(specialTypesElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_SPECIAL_TYPE_TAG, specialType);
        }
        Element concatsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCATS_TAG);
        for (IConcatenation concat : translator.getConcatenations()) {
            Element concatElement = this.createPropertyElementNS(concatsElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_TAG, null);
            this.createPropertyElementNS(concatElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_NAME_TAG, concat.getName());
            if (concat.getCondition() != null) {
                this.createPropertyElementNS(concatElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_CONDITION_TAG, concat.getCondition());
            }
            this.convertToDataDefinitionEntriesXml(concatElement, doc, concat.getDataDefinitionEntries());
        }
        Element ddAllocationsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATIONS_TAG);
        for (IDDAllocation ddAllocation : translator.getDDAllocations()) {
            Element ddAllocationElement = this.createPropertyElementNS(ddAllocationsElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_TAG, null);
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_KEEP_TAG, String.valueOf(ddAllocation.isKeep()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_MOD_TAG, String.valueOf(ddAllocation.isMod()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_MEMBER_TAG, String.valueOf(ddAllocation.isMember()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_NAME_TAG, ddAllocation.getName());
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_TAG, String.valueOf(ddAllocation.isOutput()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_PUBLISH_TAG, String.valueOf(ddAllocation.isPublish()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_PUBLISH_TYPE_TAG, String.valueOf(ddAllocation.getPublishType()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_CONSOLIDATE_LOG_TAG, String.valueOf(ddAllocation.getConsolidateLog()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_COMPACT_TAG, String.valueOf(ddAllocation.getCompact()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_USEDASINPUT_TAG, String.valueOf(ddAllocation.isUsedAsInput()));
            if (ddAllocation.getCondition() != null) {
                this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_CONDITION_TAG, ddAllocation.getCondition());
            }
            if (ZosTranslatorUtil.isMemberRenamed(ddAllocation)) {
                this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_NAME_KIND_TAG, ddAllocation.getOutputNameKind().name());
                this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_NAME_TAG, ddAllocation.getOutputName());
            }
            if (ddAllocation.isOutput()) {
                this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_DEPLOYTYPE_TAG, ddAllocation.getDeployType());
            }
            if (ddAllocation.getDataDefinitionEntry() != null) {
                this.convertToDataDefinitionEntryXml(ddAllocationElement, doc, ddAllocation.getDataDefinitionEntry());
            }
            if (ddAllocation.getHfs() != null) {
                Element hfsDDElement = this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_TAG, null);
                this.createPropertyElementNS(hfsDDElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_FILETYPE, String.valueOf(ddAllocation.getHfs().getFileType().name()));
                this.createPropertyElementNS(hfsDDElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH, ddAllocation.getHfs().getPath());
                this.createPropertyElementNS(hfsDDElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH_PERM, ddAllocation.getHfs().getPathPerm());
                this.createPropertyElementNS(hfsDDElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH_PATHDISP, ddAllocation.getHfs().getPathDisp().name());
                StringBuilder pathOpts = new StringBuilder();
                for (String s : ddAllocation.getHfs().getPathOpts()) {
                    if (pathOpts.length() > 0) {
                        pathOpts.append(',');
                    }
                    pathOpts.append(s);
                }
                this.createPropertyElementNS(hfsDDElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH_PATHOPTS, pathOpts.toString());
            }
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_SEQUENTIAL_TAG, String.valueOf(ddAllocation.isSequential()));
        }
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator translator = (com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator)systemDefinition;
        if (translator.getDataSetDefinition() != null) {
            this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_SET_DEFINITION_UUID_TAG, translator.getDataSetDefinition().getItemId().getUuidValue());
        }
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DEFAULT_OPTIONS_TAG, translator.getDefaultOptions());
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_CALL_METHOD_TAG, String.valueOf(translator.getCallMethod()));
        if (translator.getCallMethod() == 3) {
            this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_COMMAND_MEMBER_TAG, String.valueOf(translator.getAntSnippet()));
        } else {
            this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_COMMAND_MEMBER_TAG, String.valueOf(translator.getCommandMember()));
        }
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_MAXRC_TAG, String.valueOf(translator.getMaxRC()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDNAME_LIST_TAG, String.valueOf(translator.getDdNameList()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_IS_LINK_EDIT_TAG, String.valueOf(translator.isLinkEdit()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_PUBLISH_TYPE, String.valueOf(translator.getISPFLogPublishType()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_CONSOLIDATE, String.valueOf(translator.getISPFLogConsolidate()));
        this.createPropertyElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_ISPF_LOG_COMPACT, String.valueOf(translator.isISPFLogCompact()));
        Element specialTypesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_SPECIAL_TYPES_TAG);
        for (IStringHelper specialType : translator.getSpecialTypes()) {
            if (specialType.getValue() == null || "".equals(specialType.getValue().trim())) continue;
            this.createPropertyElementNS(specialTypesElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_SPECIAL_TYPE_TAG, specialType.getValue());
        }
        Element concatsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCATS_TAG);
        for (com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation concat : translator.getConcatenations()) {
            Element concatElement = this.createPropertyElementNS(concatsElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_TAG, null);
            this.createPropertyElementNS(concatElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_NAME_TAG, concat.getName());
            if (concat.getCondition() != null) {
                this.createPropertyElementNS(concatElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_CONDITION_TAG, concat.getCondition());
            }
            this.convertToDataDefinitionModelEntriesXml(concatElement, doc, concat.getDataDefinitionEntries());
        }
        Element ddAllocationsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATIONS_TAG);
        for (com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation ddAllocation : translator.getDDAllocations()) {
            Element ddAllocationElement = this.createPropertyElementNS(ddAllocationsElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_TAG, null);
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_KEEP_TAG, String.valueOf(ddAllocation.isKeep()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_MOD_TAG, String.valueOf(ddAllocation.isMod()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_MEMBER_TAG, String.valueOf(ddAllocation.isMember()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_NAME_TAG, ddAllocation.getName());
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_TAG, String.valueOf(ddAllocation.isOutput()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_PUBLISH_TAG, String.valueOf(ddAllocation.isPublish()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_PUBLISH_TYPE_TAG, String.valueOf(ddAllocation.getPublishType()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_CONSOLIDATE_LOG_TAG, String.valueOf(ddAllocation.getConsolidateLog()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_COMPACT_TAG, String.valueOf(ddAllocation.getCompact()));
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_USEDASINPUT_TAG, String.valueOf(ddAllocation.isUsedAsInput()));
            if (ddAllocation.getCondition() != null) {
                this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_CONDITION_TAG, ddAllocation.getCondition());
            }
            if (ZosTranslatorUtil.isMemberRenamed(ddAllocation)) {
                this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_NAME_KIND_TAG, ddAllocation.getOutputNameKind().getName());
                this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_OUTPUT_NAME_TAG, ddAllocation.getOutputName());
            }
            if (ddAllocation.isOutput()) {
                this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_DEPLOYTYPE_TAG, ddAllocation.getDeployType());
            }
            if (ddAllocation.getDataDefinitionEntry() != null) {
                this.convertToDataDefinitionEntryXml(ddAllocationElement, doc, ddAllocation.getDataDefinitionEntry());
            }
            if (ddAllocation.getHfs() != null) {
                Element hfsDDElement = this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_TAG, null);
                this.createPropertyElementNS(hfsDDElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_FILETYPE, String.valueOf(ddAllocation.getHfs().getFileType().getName()));
                this.createPropertyElementNS(hfsDDElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH, ddAllocation.getHfs().getPath());
                this.createPropertyElementNS(hfsDDElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH_PERM, ddAllocation.getHfs().getPathPerm());
                this.createPropertyElementNS(hfsDDElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH_PATHDISP, ddAllocation.getHfs().getPathDisp().getName());
                StringBuilder pathOpts = new StringBuilder();
                for (IStringHelper s : ddAllocation.getHfs().getPathOpts()) {
                    if (pathOpts.length() > 0) {
                        pathOpts.append(',');
                    }
                    pathOpts.append(s.getValue());
                }
                this.createPropertyElementNS(hfsDDElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_HFS_DD_PATH_PATHOPTS, pathOpts.toString());
            }
            this.createPropertyElementNS(ddAllocationElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DDALLOCATION_SEQUENTIAL_TAG, String.valueOf(ddAllocation.isSequential()));
        }
        List<IHFSOutput> outputs = translator.getHFSOutputs();
        Element outputsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, SystemDefinitionUtil.TRANSLATOR_OUTPUTS_TAG);
        if (outputs != null && outputs.size() > 0) {
            for (IHFSOutput o : outputs) {
                Element outputElement = this.createPropertyElementNS(outputsElement, doc, SystemDefinitionUtil.TRANSLATOR_OUTPUT_TAG, null);
                this.createPropertyElementNS(outputElement, doc, SystemDefinitionUtil.TRANSLATOR_OUTPUT_PATH_TAG, o.getPath());
                this.createPropertyElementNS(outputElement, doc, SystemDefinitionUtil.TRANSLATOR_OUTPUT_CONDITION_TAG, o.getCondition());
                this.createPropertyElementNS(outputElement, doc, SystemDefinitionUtil.TRANSLATOR_OUTPUT_DEPLOYTYPE_TAG, o.getDeployType());
            }
        }
    }

    private void convertToDataDefinitionEntriesXml(Element parentElement, Document doc, List<IDataDefinitionEntry> dataDefinitionEntries) {
        for (IDataDefinitionEntry dataDefinitionEntry : dataDefinitionEntries) {
            this.convertToDataDefinitionEntryXml(parentElement, doc, dataDefinitionEntry);
        }
    }

    private void convertToDataDefinitionModelEntriesXml(Element parentElement, Document doc, List<com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry> dataDefinitionEntries) {
        for (com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry dataDefinitionEntry : dataDefinitionEntries) {
            this.convertToDataDefinitionEntryXml(parentElement, doc, dataDefinitionEntry);
        }
    }

    private void convertToDataDefinitionEntryXml(Element parentElement, Document doc, IDataDefinitionEntry dataDefinitionEntry) {
        Element dataDefinitionElement = this.createPropertyElementNS(parentElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TAG, null);
        this.createPropertyElementNS(dataDefinitionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_MEMBER_TAG, String.valueOf(dataDefinitionEntry.isMember()));
        this.createPropertyElementNS(dataDefinitionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TYPE_TAG, dataDefinitionEntry.getKind());
        this.createPropertyElementNS(dataDefinitionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_VALUE_TAG, dataDefinitionEntry.getValue());
    }

    private void convertToDataDefinitionEntryXml(Element parentElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry dataDefinitionEntry) {
        Element dataDefinitionElement = this.createPropertyElementNS(parentElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TAG, null);
        this.createPropertyElementNS(dataDefinitionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_MEMBER_TAG, String.valueOf(dataDefinitionEntry.isMember()));
        this.createPropertyElementNS(dataDefinitionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TYPE_TAG, dataDefinitionEntry.getKind());
        this.createPropertyElementNS(dataDefinitionElement, doc, IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_VALUE_TAG, dataDefinitionEntry.getValue());
    }
}

