/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.SystemDefinitionFactory;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingFmidItem;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.PackagingVersion;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.parsers.AbstractVersionDefinitionParser;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingElements;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingFmidItem;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingVersion;
import com.ibm.team.enterprise.zos.systemdefinition.common.parsers.FmidItemDefinitionParserSmpe;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersionDefinitionParserSmpe
extends AbstractVersionDefinitionParser
implements ISystemDefinitionParser {
    @Override
    protected com.ibm.team.enterprise.systemdefinition.common.IVersionDefinition newVersionDefinition() {
        return new com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.PackagingVersion();
    }

    @Override
    protected void parseVersionDefinition(Element rdfDescriptionElement, com.ibm.team.enterprise.systemdefinition.common.IVersionDefinition systemDefinition) throws TeamRepositoryException {
        String attr = null;
        if (systemDefinition instanceof IPackagingVersion) {
            Element packagingFmidItemsElement;
            IPackagingVersion packagingVersion = (IPackagingVersion)systemDefinition;
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_BASEFMID_TAG);
            if (attr != null) {
                packagingVersion.setBaseFmid(attr);
            } else {
                packagingVersion.setBaseFmid("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_COMPONENTID_TAG);
            if (attr != null) {
                packagingVersion.setComponentId(attr);
            } else {
                packagingVersion.setComponentId("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_COMPONENTPREFIX_TAG);
            if (attr != null) {
                packagingVersion.setComponentPrefix(attr);
            } else {
                packagingVersion.setComponentPrefix("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_COPYRIGHT_TAG);
            if (attr != null) {
                packagingVersion.setCopyright(attr);
            } else {
                packagingVersion.setCopyright("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_DEFAULTFMID_TAG);
            if (attr != null) {
                packagingVersion.setDefaultFmid(attr);
            } else {
                packagingVersion.setDefaultFmid("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_EXTENDEDSERVICE_TAG);
            if (attr != null) {
                packagingVersion.setExtendedService(Boolean.parseBoolean(attr));
            } else {
                packagingVersion.setExtendedService(Boolean.parseBoolean("false"));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_GENERALLYAVAILABLE_TAG);
            if (attr != null) {
                packagingVersion.setGenerallyAvailable(Boolean.parseBoolean(attr));
            } else {
                packagingVersion.setGenerallyAvailable(Boolean.parseBoolean("false"));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_ID_TAG);
            if (attr != null) {
                packagingVersion.setId(attr);
            } else {
                packagingVersion.setId("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_OUTOFSERVICE_TAG);
            if (attr != null) {
                packagingVersion.setOutOfService(Boolean.parseBoolean(attr));
            } else {
                packagingVersion.setOutOfService(Boolean.parseBoolean("false"));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_SINGLEFUNCTION_TAG);
            if (attr != null) {
                packagingVersion.setSingleFunction(Boolean.parseBoolean(attr));
            } else {
                packagingVersion.setSingleFunction(Boolean.parseBoolean("false"));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_SYSTEMRELEASE_TAG);
            if (attr != null) {
                packagingVersion.setSystemRelease(attr);
            } else {
                packagingVersion.setSystemRelease("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_USERMODPREFIX_TAG);
            if (attr != null) {
                packagingVersion.setUsermodPrefix(attr);
            } else {
                packagingVersion.setUsermodPrefix("XX");
            }
            Element scopedPropertiesElement = this.getDirectElementByTagNameNS(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTIES_TAG);
            if (scopedPropertiesElement != null) {
                this.parseVersionDefinitionScopedProperties(scopedPropertiesElement, packagingVersion.getScopedProperties());
            }
            if ((packagingFmidItemsElement = this.getDirectElementByTagNameNS(rdfDescriptionElement, IPackagingElements.ELEMENT_VERSION_FMIDITEMS_TAG)) != null) {
                this.parseVersionDefinitionPackagingFmidItems(packagingFmidItemsElement, packagingVersion.getPackagingFmidItems());
            }
        }
    }

    protected void parseVersionDefinitionPackagingFmidItems(Element packagingFmidItemsElement, List<IPackagingFmidItem> packagingFmidItems) throws TeamRepositoryException {
        NodeList fmidItemNodes = packagingFmidItemsElement.getElementsByTagNameNS(IPackagingElements.ELEMENT_VERSION_FMIDITEM_TAG.getNamespace(), IPackagingElements.ELEMENT_VERSION_FMIDITEM_TAG.getTagName());
        if (fmidItemNodes != null && fmidItemNodes.getLength() > 0) {
            FmidItemDefinitionParserSmpe fmidItemDefinitionParserSmpe = new FmidItemDefinitionParserSmpe();
            int i = 0;
            while (i < fmidItemNodes.getLength()) {
                Node fmidItemNode = fmidItemNodes.item(i);
                if (fmidItemNode instanceof Element) {
                    Element fmidItemElement = (Element)fmidItemNode;
                    ISystemDefinition fmidItemDefinition = fmidItemDefinitionParserSmpe.newSystemDefinition();
                    fmidItemDefinitionParserSmpe.parseSystemDefinition(fmidItemElement, fmidItemDefinition);
                    packagingFmidItems.add((IPackagingFmidItem)fmidItemDefinition);
                }
                ++i;
            }
        }
    }

    protected void parseVersionDefinitionScopedProperties(Element scopedPropertiesElement, List<IScopedProperty> scopedProperties) {
        NodeList propertyNodes = scopedPropertiesElement.getElementsByTagNameNS(IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_TAG.getNamespace(), IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_TAG.getTagName());
        if (propertyNodes != null && propertyNodes.getLength() > 0) {
            int i = 0;
            while (i < propertyNodes.getLength()) {
                Node propertyNode = propertyNodes.item(i);
                if (propertyNode instanceof Element) {
                    Element propertyElement = (Element)propertyNode;
                    String name = this.readAttributeFromChildElement(propertyElement, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_NAME_TAG);
                    String value = this.readAttributeFromChildElement(propertyElement, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_VALUE_TAG);
                    String condition = null;
                    try {
                        condition = this.readAttributeFromChildElement(propertyElement, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_COND_TAG);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (name != null && value != null) {
                        IScopedProperty scopedProperty = SystemDefinitionFactory.createScopedProperty();
                        scopedProperty.setName(name);
                        scopedProperty.setValue(value);
                        if (condition != null) {
                            scopedProperty.setCondition(condition);
                        }
                        scopedProperties.add(scopedProperty);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    protected void convertVersionToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        if (systemDefinition instanceof IPackagingVersion) {
            IPackagingVersion packagingVersion = (IPackagingVersion)systemDefinition;
            FmidItemDefinitionParserSmpe fmidItemDefinitionParserSmpe = new FmidItemDefinitionParserSmpe();
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_BASEFMID_TAG, packagingVersion.getBaseFmid());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_COMPONENTID_TAG, packagingVersion.getComponentId());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_COMPONENTPREFIX_TAG, packagingVersion.getComponentPrefix());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_COPYRIGHT_TAG, packagingVersion.getCopyright());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_DEFAULTFMID_TAG, packagingVersion.getDefaultFmid());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_EXTENDEDSERVICE_TAG, Boolean.toString(packagingVersion.isExtendedService()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_GENERALLYAVAILABLE_TAG, Boolean.toString(packagingVersion.isGenerallyAvailable()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_ID_TAG, packagingVersion.getId());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_OUTOFSERVICE_TAG, Boolean.toString(packagingVersion.isOutOfService()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_SINGLEFUNCTION_TAG, Boolean.toString(packagingVersion.isSingleFunction()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_SYSTEMRELEASE_TAG, packagingVersion.getSystemRelease());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_USERMODPREFIX_TAG, packagingVersion.getUsermodPrefix());
            Element scopedPropertiesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTIES_TAG);
            if (packagingVersion.hasScopedProperties()) {
                for (IScopedProperty scopedProperty : packagingVersion.getScopedProperties()) {
                    Element property = this.createPropertyElementNS(scopedPropertiesElement, doc, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_TAG, null);
                    this.createPropertyElementNS(property, doc, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_NAME_TAG, scopedProperty.getName());
                    this.createPropertyElementNS(property, doc, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_VALUE_TAG, scopedProperty.getValue());
                    if (scopedProperty.getCondition() == null || scopedProperty.getCondition().trim().isEmpty()) continue;
                    this.createPropertyElementNS(property, doc, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_COND_TAG, scopedProperty.getCondition());
                }
            }
            Element packagingFmidItemsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_FMIDITEMS_TAG);
            if (packagingVersion.hasPackagingFmidItems()) {
                for (IPackagingFmidItem packagingFmidItem : packagingVersion.getPackagingFmidItems()) {
                    try {
                        Element fmidItemElement = this.createLiteralElementNS(packagingFmidItemsElement, doc, IPackagingElements.ELEMENT_VERSION_FMIDITEM_TAG);
                        fmidItemDefinitionParserSmpe.convertToSystemDefinitionXml(fmidItemElement, doc, packagingFmidItem);
                    }
                    catch (TeamRepositoryException e) {
                        throw new TeamRepositoryException((Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    protected void convertVersionToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        if (systemDefinition instanceof IVersionDefinition) {
            PackagingVersion packagingVersion = new PackagingVersion((IVersionDefinition)systemDefinition);
            FmidItemDefinitionParserSmpe fmidItemDefinitionParserSmpe = new FmidItemDefinitionParserSmpe();
            if (packagingVersion.getBaseFunction() != null) {
                IFunctionDefinition baseFunction = (IFunctionDefinition)packagingVersion.getBaseFunction();
                this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_BASEFMID_TAG, baseFunction.getItemId().getUuidValue());
            }
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_COMPONENTID_TAG, packagingVersion.getComponentId());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_COMPONENTPREFIX_TAG, packagingVersion.getComponentPrefix());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_COPYRIGHT_TAG, packagingVersion.getCopyright());
            if (packagingVersion.getDefaultFunction() != null) {
                IFunctionDefinition defaultFunction = (IFunctionDefinition)packagingVersion.getDefaultFunction();
                this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_DEFAULTFMID_TAG, defaultFunction.getItemId().getUuidValue());
            }
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_EXTENDEDSERVICE_TAG, Boolean.toString(packagingVersion.isExtendedService()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_GENERALLYAVAILABLE_TAG, Boolean.toString(packagingVersion.isGenerallyAvailable()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_ID_TAG, packagingVersion.getId());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_OUTOFSERVICE_TAG, Boolean.toString(packagingVersion.isOutOfService()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_SINGLEFUNCTION_TAG, Boolean.toString(packagingVersion.isSingleFunction()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_SYSTEMRELEASE_TAG, packagingVersion.getSystemRelease());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_USERMODPREFIX_TAG, packagingVersion.getUsermodPrefix());
            Element scopedPropertiesElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTIES_TAG);
            if (packagingVersion.hasScopedProperties()) {
                for (com.ibm.team.enterprise.systemdefinition.common.model.IScopedProperty scopedProperty : packagingVersion.getScopedProperties()) {
                    Element element = this.createPropertyElementNS(scopedPropertiesElement, doc, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_TAG, null);
                    this.createPropertyElementNS(element, doc, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_NAME_TAG, scopedProperty.getName());
                    this.createPropertyElementNS(element, doc, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_VALUE_TAG, scopedProperty.getValue());
                    if (scopedProperty.getCondition() == null || scopedProperty.getCondition().trim().isEmpty()) continue;
                    this.createPropertyElementNS(element, doc, IPackagingElements.ELEMENT_VERSION_SCOPEDPROPERTY_COND_TAG, scopedProperty.getCondition());
                }
            }
            Element packagingFmidItemsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_VERSION_FMIDITEMS_TAG);
            if (packagingVersion.hasFmidItemDefinitions()) {
                List<Object> fmidItems = new ArrayList();
                fmidItems = packagingVersion.getFmidItems();
                for (IFmidItemDefinition iFmidItemDefinition : fmidItems) {
                    PackagingFmidItem packagingFmidItem = new PackagingFmidItem(iFmidItemDefinition);
                    try {
                        Element fmidItemElement = this.createLiteralElementNS(packagingFmidItemsElement, doc, IPackagingElements.ELEMENT_VERSION_FMIDITEM_TAG);
                        fmidItemDefinitionParserSmpe.convertToSystemDefinitionXml(fmidItemElement, doc, packagingFmidItem);
                    }
                    catch (TeamRepositoryException e) {
                        throw new TeamRepositoryException((Throwable)e);
                    }
                }
            }
        }
    }
}

