/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.parsers;

import com.ibm.team.enterprise.zos.systemdefinition.common.IZosTranslator;
import com.ibm.team.enterprise.zos.systemdefinition.common.parsers.ZosTranslatorParser;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class RemoveSpecialTypeParser
extends DefaultHandler {
    private final XMLReader xmlReader = XMLReaderFactory.createXMLReader();
    private OutputStreamWriter osw;
    private StringBuffer text;
    private boolean inSpecialTypes;
    private boolean inSpecialType;

    public RemoveSpecialTypeParser() throws SAXException {
        this.xmlReader.setContentHandler(this);
        this.xmlReader.setDTDHandler(this);
        this.xmlReader.setEntityResolver(this);
        this.xmlReader.setErrorHandler(this);
    }

    public IZosTranslator fixIt(InputStream originalContent) throws TeamRepositoryException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.fixIt(originalContent, baos);
            return (IZosTranslator)new ZosTranslatorParser().parse(baos.toString());
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public IZosTranslator fixIt(String originalContent) throws TeamRepositoryException {
        try {
            return this.fixIt(new ByteArrayInputStream(originalContent.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private void fixIt(InputStream translatorContent, OutputStream outputStream) throws SAXException, IOException {
        this.osw = new OutputStreamWriter(outputStream, "UTF-8");
        this.xmlReader.parse(new InputSource(translatorContent));
    }

    @Override
    public void startDocument() throws SAXException {
        this.echo("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        this.echo("\n");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.dumpText();
        if (localName.equals("specialType")) {
            if (attrs != null && attrs.getLength() == 1) {
                this.echo("<ztranslator:specialTypes rdf:parseType=\"Literal\">");
                this.inSpecialTypes = true;
            } else {
                this.inSpecialType = true;
            }
        } else if (localName.equals("RDF")) {
            this.echo(String.valueOf('<') + qName);
            this.echo(" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:systemdefinition=\"http://www.ibm.com/team/enterprise/systemdefinition/\" xmlns:translator=\"http://www.ibm.com/team/enterprise/translator/\" xmlns:ztranslator=\"http://www.ibm.com/teamz/ztranslator/\"");
            this.echo(">");
        } else {
            this.echo(String.valueOf('<') + qName);
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    String attrName = attrs.getQName(i);
                    this.echo(" ");
                    this.echo(String.valueOf(attrName) + "=\"" + attrs.getValue(i) + "\"");
                    ++i;
                }
            }
            this.echo(">");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("specialType")) {
            if (this.inSpecialType) {
                if (this.text != null) {
                    this.echo("<ztranslator:specialType>");
                    this.dumpText();
                    this.echo("</ztranslator:specialType>");
                }
                this.inSpecialType = false;
            } else if (this.inSpecialTypes) {
                this.echo("</ztranslator:specialTypes>");
                this.inSpecialTypes = false;
            }
        } else {
            this.dumpText();
            this.echo("</" + qName + '>');
        }
    }

    @Override
    public void characters(char[] buffer, int offset, int len) throws SAXException {
        if (this.text == null) {
            this.text = new StringBuffer();
        }
        int max = offset + len;
        int i = offset;
        while (i < max) {
            char ch = buffer[i];
            String temp = this.escapeEntityCharacters(ch);
            if (temp == null) {
                this.text.append(ch);
            } else {
                this.text.append(temp);
            }
            ++i;
        }
    }

    private void dumpText() throws SAXException {
        if (this.text != null) {
            this.echo(this.text.toString());
            this.text = null;
        }
    }

    private void echo(String text) throws SAXException {
        try {
            this.osw.write(text);
            this.osw.flush();
        }
        catch (IOException e) {
            new SAXException(e);
        }
    }

    private String escapeEntityCharacters(char entity) {
        switch (entity) {
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }
}

