/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingDetailDefinition;
import com.ibm.team.enterprise.systemdefinition.common.util.TagWithNS;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingDetail;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingElements;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingEnumerations;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.PackagingLanguageDetail;
import com.ibm.team.enterprise.zos.systemdefinition.common.parsers.AbstractPackagingDefinitionParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PackagingDefinitionParserSmpe
extends AbstractPackagingDefinitionParser
implements ISystemDefinitionParser {
    private final TagWithNS ELEMENT_PACKAGING_FMIDOVERRIDE_TAG = new TagWithNS(IPackagingElements.NAMESPACE_PACKAGING_DEFINITION, "fmidOverride");
    private final TagWithNS ELEMENT_PACKAGING_PARTTYPE_TAG = new TagWithNS(IPackagingElements.NAMESPACE_PACKAGING_DEFINITION, "parttype");
    private final TagWithNS ELEMENT_PACKAGING_PROCESS_TAG = new TagWithNS(IPackagingElements.NAMESPACE_PACKAGING_DEFINITION, "process");

    @Override
    protected IPackagingDefinition newPackagingDefinition() {
        return new PackagingLanguageDetail();
    }

    @Override
    protected void parsePackagingDefinition(Element rdfDescriptionElement, ISystemDefinition systemDefinition) {
        String attr = null;
        if (systemDefinition instanceof IPackagingDetail) {
            IPackagingDetail packagingDetail = (IPackagingDetail)systemDefinition;
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_PACKAGING_BINARY_TAG);
            if (attr != null) {
                packagingDetail.setBinary(Boolean.parseBoolean(attr));
            } else {
                packagingDetail.setBinary(Boolean.parseBoolean("false"));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_PACKAGING_DISTLIB_TAG);
            if (attr != null) {
                packagingDetail.setDistlib(attr);
            } else {
                packagingDetail.setDistlib("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_PACKAGING_DISTNAME_TAG);
            if (attr != null) {
                packagingDetail.setDistname(attr);
            } else {
                packagingDetail.setDistname("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_PACKAGING_FMIDOVERRIDE_TAG);
            if (attr == null) {
                attr = this.readAttributeFromChildElement(rdfDescriptionElement, this.ELEMENT_PACKAGING_FMIDOVERRIDE_TAG);
            }
            if (attr != null) {
                packagingDetail.setFmidoverride(attr);
            } else {
                packagingDetail.setFmidoverride("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_PACKAGING_ID_TAG);
            if (attr != null) {
                packagingDetail.setId(IPackagingEnumerations.Id.get(attr));
            } else {
                packagingDetail.setId(IPackagingEnumerations.Id.get(""));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_PACKAGING_LOCATION_TAG);
            if (attr != null) {
                packagingDetail.setLocation(attr);
            } else {
                packagingDetail.setLocation("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_PACKAGING_MCSTYPE_TAG);
            if (attr == null) {
                attr = this.readAttributeFromChildElement(rdfDescriptionElement, this.ELEMENT_PACKAGING_PARTTYPE_TAG).replaceAll("\\+", "");
            }
            if (attr != null) {
                packagingDetail.setMcstype(IPackagingEnumerations.Mcstype.get(attr));
            } else {
                packagingDetail.setMcstype(IPackagingEnumerations.Mcstype.get(""));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_PACKAGING_PROCESSOR_TAG);
            if (attr == null) {
                attr = this.readAttributeFromChildElement(rdfDescriptionElement, this.ELEMENT_PACKAGING_PROCESS_TAG);
            }
            if (attr != null) {
                packagingDetail.setProcessor(IPackagingEnumerations.Processor.get(attr));
            } else {
                packagingDetail.setProcessor(IPackagingEnumerations.Processor.get(""));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_PACKAGING_SHIPALIAS_TAG);
            if (attr != null) {
                packagingDetail.setShipalias(attr);
            } else {
                packagingDetail.setShipalias("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_PACKAGING_SYSLIB_TAG);
            if (attr != null) {
                packagingDetail.setSyslib(attr);
            } else {
                packagingDetail.setSyslib("");
            }
        }
    }

    @Override
    protected void convertPackagingToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) {
        if (systemDefinition instanceof IPackagingDetail) {
            IPackagingDetail packagingDetail = (IPackagingDetail)systemDefinition;
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_BINARY_TAG, Boolean.toString(packagingDetail.isBinary()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_DISTLIB_TAG, packagingDetail.getDistlib());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_DISTNAME_TAG, packagingDetail.getDistname());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_FMIDOVERRIDE_TAG, packagingDetail.getFmidoverride());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_ID_TAG, IPackagingEnumerations.Id.toString(packagingDetail.getId()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_LOCATION_TAG, packagingDetail.getLocation());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_MCSTYPE_TAG, IPackagingEnumerations.Mcstype.toString(packagingDetail.getMcstype()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_PROCESSOR_TAG, IPackagingEnumerations.Processor.toString(packagingDetail.getProcessor()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_SHIPALIAS_TAG, packagingDetail.getShipalias());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_SYSLIB_TAG, packagingDetail.getSyslib());
        }
    }

    @Override
    protected void convertPackagingToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) {
        if (systemDefinition instanceof IPackagingDetailDefinition) {
            IPackagingDetailDefinition packagingDetail = (IPackagingDetailDefinition)systemDefinition;
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_BINARY_TAG, Boolean.toString(packagingDetail.isBinary()));
            if (packagingDetail.getDistlib() != null) {
                IDataSetDefinition distlib = (IDataSetDefinition)packagingDetail.getDistlib();
                this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_DISTLIB_TAG, distlib.getName());
            }
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_DISTNAME_TAG, packagingDetail.getDistname());
            if (packagingDetail.getFmidoverride() != null) {
                IFunctionDefinition fmidOverride = (IFunctionDefinition)packagingDetail.getFmidoverride();
                this.createPropertyElementNS(rdfDescriptionElement, doc, this.ELEMENT_PACKAGING_FMIDOVERRIDE_TAG, fmidOverride.getItemId().getUuidValue());
            }
            if (packagingDetail.getId() != null) {
                this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_ID_TAG, packagingDetail.getId().getName());
            }
            if (packagingDetail.getLocation() != null) {
                IDataSetDefinition location = (IDataSetDefinition)packagingDetail.getLocation();
                this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_LOCATION_TAG, location.getName());
            }
            if (packagingDetail.getMcstype() != null) {
                this.createPropertyElementNS(rdfDescriptionElement, doc, this.ELEMENT_PACKAGING_PARTTYPE_TAG, packagingDetail.getMcstype().getName());
            }
            if (packagingDetail.getProcessor() != null) {
                this.createPropertyElementNS(rdfDescriptionElement, doc, this.ELEMENT_PACKAGING_PROCESS_TAG, packagingDetail.getProcessor().getName());
            }
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_SHIPALIAS_TAG, packagingDetail.getShipalias());
            if (packagingDetail.getSyslib() != null) {
                IDataSetDefinition syslib = (IDataSetDefinition)packagingDetail.getSyslib();
                this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_PACKAGING_SYSLIB_TAG, syslib.getName());
            }
        }
    }
}

