/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.parsers;

import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.common.ILanguageExtension;
import com.ibm.team.enterprise.systemdefinition.common.ILanguageExtensionParser;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingDetailDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.parsers.AbstractLanguageExtensionParser;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionDtoString;
import com.ibm.team.enterprise.systemdefinition.common.util.TagWithNS;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingDetail;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingElements;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingEnumerations;
import com.ibm.team.enterprise.zos.systemdefinition.common.IPackagingItem;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.PackagingLanguageItem;
import com.ibm.team.enterprise.zos.systemdefinition.common.parsers.PackagingDefinitionParserSmpe;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LanguageExtensionParserSmpe
extends AbstractLanguageExtensionParser
implements ILanguageExtensionParser {
    private final TagWithNS ELEMENT_LANGUAGE_DELETE_TAG = new TagWithNS(IPackagingElements.NAMESPACE_LANGUAGE_EXTENSION_SMPE, "delete");
    private final TagWithNS ELEMENT_LANGUAGE_FOLDER_TAG = new TagWithNS(IPackagingElements.NAMESPACE_LANGUAGE_EXTENSION_SMPE, "folder");
    private final TagWithNS ELEMENT_LANGUAGE_HFSDATA_TAG = new TagWithNS(IPackagingElements.NAMESPACE_LANGUAGE_EXTENSION_SMPE, "hfsData");
    private final TagWithNS ELEMENT_LANGUAGE_HFSPATH_TAG = new TagWithNS(IPackagingElements.NAMESPACE_LANGUAGE_EXTENSION_SMPE, "hfsPath");
    private final TagWithNS ELEMENT_LANGUAGE_ITEMTYPE_TAG = new TagWithNS(IPackagingElements.NAMESPACE_LANGUAGE_EXTENSION_SMPE, "itemType");
    private final TagWithNS ELEMENT_LANGUAGE_LINKPARM_TAG = new TagWithNS(IPackagingElements.NAMESPACE_LANGUAGE_EXTENSION_SMPE, "linkParm");
    private final TagWithNS ELEMENT_LANGUAGE_SOURCEUPDATE_TAG = new TagWithNS(IPackagingElements.NAMESPACE_LANGUAGE_EXTENSION_SMPE, "sourceUpdate");

    @Override
    public TagWithNS getLanguageExtensionTag() {
        return IPackagingElements.ELEMENT_LANGUAGEEXTENSTION_TAG;
    }

    @Override
    public ISystemDefinition newSystemDefinition() {
        return this.newLanguageExtension();
    }

    @Override
    public ILanguageExtension newLanguageExtension() {
        return new PackagingLanguageItem();
    }

    @Override
    public void parseLanguageExtension(Element rdfDescriptionElement, ILanguageExtension systemDefinition) throws TeamRepositoryException {
        String attr = null;
        if (systemDefinition instanceof IPackagingItem) {
            IPackagingItem packagingItem = (IPackagingItem)systemDefinition;
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_ALIAS_TAG);
            if (attr != null) {
                packagingItem.setAlias(attr);
            } else {
                packagingItem.setAlias("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_CLASS_TAG);
            if (attr != null) {
                packagingItem.setClazz(attr);
            } else {
                packagingItem.setClazz("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_CSECT_TAG);
            if (attr != null) {
                packagingItem.setCsect(attr);
            } else {
                packagingItem.setCsect("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_DELETED_TAG);
            if (attr == null) {
                attr = this.readAttributeFromChildElement(rdfDescriptionElement, this.ELEMENT_LANGUAGE_DELETE_TAG);
            }
            if (attr != null) {
                packagingItem.setDeleted(Boolean.parseBoolean(attr));
            } else {
                packagingItem.setDeleted(Boolean.parseBoolean("false"));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_DISTTYPE_TAG);
            if (attr != null) {
                packagingItem.setDisttype(IPackagingEnumerations.Disttype.get(attr));
            } else {
                packagingItem.setDisttype(IPackagingEnumerations.Disttype.get(""));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_FMID_TAG);
            if (attr != null) {
                packagingItem.setFmid(attr);
            } else {
                packagingItem.setFmid("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_FOLDERS_TAG);
            if (attr == null) {
                attr = this.readAttributeFromChildElement(rdfDescriptionElement, this.ELEMENT_LANGUAGE_FOLDER_TAG);
            }
            if (attr != null) {
                packagingItem.setFolders(attr);
            } else {
                packagingItem.setFolders("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_HFSDATA_TAG);
            if (attr == null) {
                attr = this.readAttributeFromChildElement(rdfDescriptionElement, this.ELEMENT_LANGUAGE_HFSDATA_TAG);
            }
            if (attr != null) {
                packagingItem.setHfsdata(IPackagingEnumerations.Hfsdata.get(attr));
            } else {
                packagingItem.setHfsdata(IPackagingEnumerations.Hfsdata.get(""));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_HFSPATH_TAG);
            if (attr == null) {
                attr = this.readAttributeFromChildElement(rdfDescriptionElement, this.ELEMENT_LANGUAGE_HFSPATH_TAG);
            }
            if (attr != null) {
                packagingItem.setHfspath(attr);
            } else {
                packagingItem.setHfspath("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_ITEMTYPE_TAG);
            if (attr == null) {
                attr = this.readAttributeFromChildElement(rdfDescriptionElement, this.ELEMENT_LANGUAGE_ITEMTYPE_TAG);
            }
            if (attr != null) {
                packagingItem.setItemtype(IPackagingEnumerations.Itemtype.get(attr));
            } else {
                packagingItem.setItemtype(IPackagingEnumerations.Itemtype.get(""));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_JCLINCS_TAG);
            if (attr != null) {
                packagingItem.setJclincs(Boolean.parseBoolean(attr));
            } else {
                packagingItem.setJclincs(Boolean.parseBoolean("false"));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_LEPARM_TAG);
            if (attr == null) {
                attr = this.readAttributeFromChildElement(rdfDescriptionElement, this.ELEMENT_LANGUAGE_LINKPARM_TAG);
            }
            if (attr != null) {
                packagingItem.setLeparm(attr);
            } else {
                packagingItem.setLeparm("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_MODULE_TAG);
            if (attr != null) {
                packagingItem.setModule(attr);
            } else {
                packagingItem.setModule("");
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_SHIPPED_TAG);
            if (attr != null) {
                packagingItem.setShipped(Boolean.parseBoolean(attr));
            } else {
                packagingItem.setShipped(Boolean.parseBoolean("true"));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_TRANSFORM_TAG);
            if (attr != null) {
                packagingItem.setTransform(Boolean.parseBoolean(attr));
            } else {
                packagingItem.setTransform(Boolean.parseBoolean("false"));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_UPDATED_TAG);
            if (attr == null) {
                attr = this.readAttributeFromChildElement(rdfDescriptionElement, this.ELEMENT_LANGUAGE_SOURCEUPDATE_TAG);
            }
            if (attr != null) {
                packagingItem.setUpdated(Boolean.parseBoolean(attr));
            } else {
                packagingItem.setUpdated(Boolean.parseBoolean("false"));
            }
            attr = this.readAttributeFromChildElement(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_VPL_TAG);
            if (attr != null) {
                packagingItem.setVpl(Boolean.parseBoolean(attr));
            } else {
                packagingItem.setVpl(Boolean.parseBoolean("false"));
            }
            Element packagingDetailsElement = this.getDirectElementByTagNameNS(rdfDescriptionElement, IPackagingElements.ELEMENT_LANGUAGE_PACKAGINGS_TAG);
            if (packagingDetailsElement != null) {
                this.parseLanguageExtensionPackagingDetails(packagingDetailsElement, packagingItem.getPackagingDetails());
            }
        }
    }

    protected void parseLanguageExtensionPackagingDetails(Element packagingDetailsElement, List<IPackagingDetail> packagingDetails) throws TeamRepositoryException {
        NodeList packagingNodes = packagingDetailsElement.getElementsByTagNameNS(IPackagingElements.ELEMENT_LANGUAGE_PACKAGING_TAG.getNamespace(), IPackagingElements.ELEMENT_LANGUAGE_PACKAGING_TAG.getTagName());
        if (packagingNodes != null && packagingNodes.getLength() > 0) {
            PackagingDefinitionParserSmpe packagingDefinitionParserSmpe = new PackagingDefinitionParserSmpe();
            int i = 0;
            while (i < packagingNodes.getLength()) {
                Node packagingNode = packagingNodes.item(i);
                if (packagingNode instanceof Element) {
                    Element packagingElement = (Element)packagingNode;
                    ISystemDefinition packagingDefinition = packagingDefinitionParserSmpe.newSystemDefinition();
                    packagingDefinitionParserSmpe.parseSystemDefinition(packagingElement, packagingDefinition);
                    packagingDetails.add((IPackagingDetail)packagingDefinition);
                }
                ++i;
            }
        }
    }

    @Override
    public void convertExtensionToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        if (systemDefinition instanceof IPackagingItem) {
            IPackagingItem packagingItem = (IPackagingItem)systemDefinition;
            PackagingDefinitionParserSmpe packagingDefinitionParserSmpe = new PackagingDefinitionParserSmpe();
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_ALIAS_TAG, packagingItem.getAlias());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_CLASS_TAG, packagingItem.getClazz());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_CSECT_TAG, packagingItem.getCsect());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_DELETED_TAG, Boolean.toString(packagingItem.isDeleted()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_DISTTYPE_TAG, IPackagingEnumerations.Disttype.toString(packagingItem.getDisttype()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_FMID_TAG, packagingItem.getFmid());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_FOLDERS_TAG, packagingItem.getFolders());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_LEPARM_TAG, packagingItem.getLeparm());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_HFSDATA_TAG, IPackagingEnumerations.Hfsdata.toString(packagingItem.getHfsdata()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_HFSPATH_TAG, packagingItem.getHfspath());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_ITEMTYPE_TAG, IPackagingEnumerations.Itemtype.toString(packagingItem.getItemtype()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_JCLINCS_TAG, Boolean.toString(packagingItem.isJclincs()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_MODULE_TAG, packagingItem.getModule());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_SHIPPED_TAG, Boolean.toString(packagingItem.isShipped()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_TRANSFORM_TAG, Boolean.toString(packagingItem.isTransform()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_UPDATED_TAG, Boolean.toString(packagingItem.isUpdated()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_VPL_TAG, Boolean.toString(packagingItem.isVpl()));
            Element detailsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_PACKAGINGS_TAG);
            if (packagingItem.hasPackagingDetails()) {
                for (IPackagingDetail packagingDetail : packagingItem.getPackagingDetails()) {
                    try {
                        Element detailElement = this.createLiteralElementNS(detailsElement, doc, IPackagingElements.ELEMENT_LANGUAGE_PACKAGING_TAG);
                        packagingDefinitionParserSmpe.convertToSystemDefinitionXml(detailElement, doc, packagingDetail);
                    }
                    catch (TeamRepositoryException e) {
                        throw new TeamRepositoryException((Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void convertExtensionToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        if (systemDefinition instanceof IPackagingItemDefinition) {
            IPackagingItemDefinition packagingItem = (IPackagingItemDefinition)systemDefinition;
            PackagingDefinitionParserSmpe packagingDefinitionParserSmpe = new PackagingDefinitionParserSmpe();
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_ALIAS_TAG, packagingItem.getAlias());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_CLASS_TAG, packagingItem.getClazz());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_CSECT_TAG, packagingItem.getCsect());
            this.createPropertyElementNS(rdfDescriptionElement, doc, this.ELEMENT_LANGUAGE_DELETE_TAG, Boolean.toString(packagingItem.isDeleted()));
            if (packagingItem.getDisttype() != null) {
                this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_DISTTYPE_TAG, packagingItem.getDisttype().getName());
            }
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_FMID_TAG, SystemDefinitionDtoString.valueOf(packagingItem.getFmid()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, this.ELEMENT_LANGUAGE_FOLDER_TAG, packagingItem.getFolders());
            if (packagingItem.getHfsdata() != null) {
                this.createPropertyElementNS(rdfDescriptionElement, doc, this.ELEMENT_LANGUAGE_HFSDATA_TAG, packagingItem.getHfsdata().getName());
            }
            this.createPropertyElementNS(rdfDescriptionElement, doc, this.ELEMENT_LANGUAGE_HFSPATH_TAG, packagingItem.getHfspath());
            if (packagingItem.getItemtype() != null) {
                this.createPropertyElementNS(rdfDescriptionElement, doc, this.ELEMENT_LANGUAGE_ITEMTYPE_TAG, packagingItem.getItemtype().getName());
            }
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_JCLINCS_TAG, Boolean.toString(packagingItem.isJclincs()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, this.ELEMENT_LANGUAGE_LINKPARM_TAG, packagingItem.getLeparm());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_MODULE_TAG, packagingItem.getModule());
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_SHIPPED_TAG, Boolean.toString(packagingItem.isShipped()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, this.ELEMENT_LANGUAGE_SOURCEUPDATE_TAG, Boolean.toString(packagingItem.isUpdated()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_TRANSFORM_TAG, Boolean.toString(packagingItem.isTransform()));
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_VPL_TAG, Boolean.toString(packagingItem.isVpl()));
            Element detailsElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_PACKAGINGS_TAG);
            List<?> packaginglist = packagingItem.getDetails();
            for (IPackagingDetailDefinition packagingDetail : packaginglist) {
                try {
                    Element detailElement = this.createLiteralElementNS(detailsElement, doc, IPackagingElements.ELEMENT_LANGUAGE_PACKAGING_TAG);
                    packagingDefinitionParserSmpe.convertToSystemDefinitionXml(detailElement, doc, packagingDetail);
                }
                catch (TeamRepositoryException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void convertExtensionQueriesToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) {
        IPackagingItem packagingItem;
        if (systemDefinition instanceof IPackagingItem && Verification.isNonBlank((String)(packagingItem = (IPackagingItem)systemDefinition).getFolders())) {
            StringBuilder folderQuery = new StringBuilder();
            for (String folder : Arrays.asList(packagingItem.getFolders().split(","))) {
                folderQuery.append("[").append(folder).append("]");
            }
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_FOLDERQUERY_TAG, folderQuery.toString());
        }
    }

    @Override
    public void convertExtensionQueriesToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) {
        IPackagingItem packagingItem;
        if (systemDefinition instanceof IPackagingItem && Verification.isNonBlank((String)(packagingItem = (IPackagingItem)((Object)systemDefinition)).getFolders())) {
            StringBuilder folderQuery = new StringBuilder();
            for (String folder : Arrays.asList(packagingItem.getFolders().split(","))) {
                folderQuery.append("[").append(folder).append("]");
            }
            this.createPropertyElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGE_FOLDERQUERY_TAG, folderQuery.toString());
        }
    }

    @Override
    public Element createLanguageExtensionElement(Element rdfDescriptionElement, Document doc) {
        return this.createLiteralElementNS(rdfDescriptionElement, doc, IPackagingElements.ELEMENT_LANGUAGEEXTENSTION_TAG);
    }
}

