/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.parsers;

import com.ibm.team.enterprise.systemdefinition.common.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.parsers.AbstractResourceDefinitionParser;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.zos.IZosSystemDefinitionUtil;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataSetDefinition;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractDataSetDefinitionParser
extends AbstractResourceDefinitionParser
implements ISystemDefinitionParser {
    @Override
    protected IResourceDefinition newResourceDefinition() {
        return this.newDataSetDefinition();
    }

    protected abstract IDataSetDefinition newDataSetDefinition();

    @Override
    protected void parseResourceDefinition(Element rdfDescriptionElement, IResourceDefinition resourceDefinition) {
        super.parseResourceDefinition(rdfDescriptionElement, resourceDefinition);
        IDataSetDefinition dataSetDefinition = (IDataSetDefinition)resourceDefinition;
        String attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_MEMBER_TAG);
        if (attr != null) {
            dataSetDefinition.setDsMember(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_DSNAME_TAG)) != null) {
            dataSetDefinition.setDsName(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_STORAGE_CLASS_TAG)) != null) {
            dataSetDefinition.setStorageClass(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_DATA_CLASS_TAG)) != null) {
            dataSetDefinition.setDataClass(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_MANAGEMENT_CLASS_TAG)) != null) {
            dataSetDefinition.setManagementClass(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_VOLUME_SERIAL_TAG)) != null) {
            dataSetDefinition.setVolumeSerial(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_GENERIC_UNIT_TAG)) != null) {
            dataSetDefinition.setGenericUnit(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_SPACE_UNITS_TAG)) != null) {
            dataSetDefinition.setSpaceUnits(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_RECORD_UNIT_TAG)) != null && attr.trim().length() > 0) {
            dataSetDefinition.setRecordUnit(attr.charAt(0));
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_PRIMARY_QUANTITY_TAG)) != null) {
            dataSetDefinition.setPrimaryQuantity(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_SECONDARY_QUANTITY_TAG)) != null) {
            dataSetDefinition.setSecondaryQuantity(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_DIRECTORY_BLOCKS_TAG)) != null) {
            dataSetDefinition.setDirectoryBlocks(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_RECORD_LENGTH_TAG)) != null) {
            dataSetDefinition.setRecordLength(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_BLOCK_SIZE_TAG)) != null) {
            dataSetDefinition.setBlockSize(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_ADD_PARM_TAG)) != null) {
            dataSetDefinition.setAdditionalParm(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_TYPE_TAG)) != null && this.canParseToInteger(attr)) {
            dataSetDefinition.setDsType(Integer.parseInt(attr));
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_EXPIRATION_DATE_TAG)) != null) {
            dataSetDefinition.setExpirationDate(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_ALLOCATION_MULTIPLE_VOLUMES_TAG)) != null) {
            dataSetDefinition.setAllocationMultipleVolumes(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_RECORD_FORMAT_TAG)) != null) {
            dataSetDefinition.setRecordFormat(attr);
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_PREFIX_DSN_TAG)) != null) {
            dataSetDefinition.setPrefixDSN(Boolean.parseBoolean(attr));
        }
        if ((attr = this.readAttributeFromChildElement(rdfDescriptionElement, IZosSystemDefinitionUtil.ZDATASETDEFINITION_COMPACT_TAG)) != null) {
            dataSetDefinition.setCompact(Boolean.parseBoolean(attr));
        }
    }

    @Override
    protected Element convertToRdfElement(Document doc, ISystemDefinition systemDefinition) {
        Element rdfElement = super.convertToRdfElement(doc, systemDefinition);
        Attr attr = doc.createAttributeNS(SystemDefinitionUtil.XMLNS_NAMESPACE.getNamespace(), new StringBuffer(SystemDefinitionUtil.XMLNS_NAMESPACE.getPrefix()).append(":").append(IZosSystemDefinitionUtil.ZDATASETDEFINITION_NAMESPACE.getPrefix()).toString());
        attr.setValue(IZosSystemDefinitionUtil.ZDATASETDEFINITION_NAMESPACE.getNamespace());
        rdfElement.setAttributeNode(attr);
        return rdfElement;
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        IDataSetDefinition dataSetDefinition = (IDataSetDefinition)systemDefinition;
        Element infoElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_INFO_TAG);
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_MEMBER_TAG, dataSetDefinition.getDsMember());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_DSNAME_TAG, dataSetDefinition.getDsName());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_STORAGE_CLASS_TAG, dataSetDefinition.getStorageClass());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_DATA_CLASS_TAG, dataSetDefinition.getDataClass());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_MANAGEMENT_CLASS_TAG, dataSetDefinition.getManagementClass());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_VOLUME_SERIAL_TAG, dataSetDefinition.getVolumeSerial());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_GENERIC_UNIT_TAG, dataSetDefinition.getGenericUnit());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_SPACE_UNITS_TAG, dataSetDefinition.getSpaceUnits());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_RECORD_UNIT_TAG, String.valueOf(dataSetDefinition.getRecordUnit()));
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_PRIMARY_QUANTITY_TAG, dataSetDefinition.getPrimaryQuantity());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_SECONDARY_QUANTITY_TAG, dataSetDefinition.getSecondaryQuantity());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_DIRECTORY_BLOCKS_TAG, dataSetDefinition.getDirectoryBlocks());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_RECORD_LENGTH_TAG, dataSetDefinition.getRecordLength());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_BLOCK_SIZE_TAG, dataSetDefinition.getBlockSize());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_ADD_PARM_TAG, dataSetDefinition.getAdditionalParm());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_TYPE_TAG, String.valueOf(dataSetDefinition.getDsType()));
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_EXPIRATION_DATE_TAG, dataSetDefinition.getExpirationDate());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_ALLOCATION_MULTIPLE_VOLUMES_TAG, dataSetDefinition.getAllocationMultipleVolumes());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_RECORD_FORMAT_TAG, dataSetDefinition.getRecordFormat());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_PREFIX_DSN_TAG, String.valueOf(dataSetDefinition.isPrefixDSN()));
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_COMPACT_TAG, String.valueOf(dataSetDefinition.isCompact()));
    }

    @Override
    protected void convertToSystemDefinitionXml(Element rdfDescriptionElement, Document doc, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition systemDefinition) throws TeamRepositoryException {
        super.convertToSystemDefinitionXml(rdfDescriptionElement, doc, systemDefinition);
        com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition dataSetDefinition = (com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition)systemDefinition;
        Element infoElement = this.createLiteralElementNS(rdfDescriptionElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_INFO_TAG);
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_MEMBER_TAG, dataSetDefinition.getDsMember());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_DSNAME_TAG, dataSetDefinition.getDsName());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_STORAGE_CLASS_TAG, dataSetDefinition.getStorageClass());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_DATA_CLASS_TAG, dataSetDefinition.getDataClass());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_MANAGEMENT_CLASS_TAG, dataSetDefinition.getManagementClass());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_VOLUME_SERIAL_TAG, dataSetDefinition.getVolumeSerial());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_GENERIC_UNIT_TAG, dataSetDefinition.getGenericUnit());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_SPACE_UNITS_TAG, dataSetDefinition.getSpaceUnits());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_PRIMARY_QUANTITY_TAG, dataSetDefinition.getPrimaryQuantity());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_SECONDARY_QUANTITY_TAG, dataSetDefinition.getSecondaryQuantity());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_DIRECTORY_BLOCKS_TAG, dataSetDefinition.getDirectoryBlocks());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_RECORD_LENGTH_TAG, dataSetDefinition.getRecordLength());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_BLOCK_SIZE_TAG, dataSetDefinition.getBlockSize());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_ADD_PARM_TAG, dataSetDefinition.getAdditionalParm());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_TYPE_TAG, String.valueOf(dataSetDefinition.getDsType()));
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_EXPIRATION_DATE_TAG, dataSetDefinition.getExpirationDate());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_ALLOCATION_MULTIPLE_VOLUMES_TAG, dataSetDefinition.getAllocationMultipleVolumes());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_RECORD_FORMAT_TAG, dataSetDefinition.getRecordFormat());
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_PREFIX_DSN_TAG, String.valueOf(dataSetDefinition.isPrefixDSN()));
        this.createPropertyElementNS(infoElement, doc, IZosSystemDefinitionUtil.ZDATASETDEFINITION_COMPACT_TAG, String.valueOf(dataSetDefinition.isCompact()));
    }
}

