/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.systemdefinition.common.model.mapper;

import com.ibm.team.enterprise.systemdefinition.common.IHFSOutput;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.Concatenation;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DDAllocation;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.HFSOutput;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.StringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.OutputNameKind;
import com.ibm.team.enterprise.systemdefinition.common.model.mapper.TranslatorModelMapper;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.zos.systemdefinition.common.IConcatenation;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDDAllocation;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataDefinitionEntry;
import com.ibm.team.enterprise.zos.systemdefinition.common.IZosTranslator;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

public class ZosTranslatorModelMapper
extends TranslatorModelMapper {
    private static Log logger = LogFactory.getLog(ZosTranslatorModelMapper.class);

    @Override
    public void mapPlatformAttributes(ISystemDefinition jfsDef, com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition emfDef) throws TeamRepositoryException {
        if (!SystemDefinitionUtil.isTypeOf(emfDef.getItemType(), com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator.ITEM_TYPE)) {
            throw new TeamRepositoryException(NLS.bind((String)"Wrong system definition type to be mapped. Expected {0}, but {1} instead", (Object)com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator.ITEM_TYPE.getName(), (Object)emfDef.getItemType().getName()));
        }
        if (!jfsDef.getType().equals("translator") || !(jfsDef instanceof IZosTranslator)) {
            throw new TeamRepositoryException(NLS.bind((String)"Wrong system definition type to map. Expected {0}, but {1} instead", (Object)"translator", (Object)jfsDef.getType()));
        }
        com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator trs = (com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator)emfDef;
        IZosTranslator jfsTrs = (IZosTranslator)jfsDef;
        trs.setCallMethod(jfsTrs.getCallMethod());
        int callMethod = trs.getCallMethod();
        switch (callMethod) {
            case 1: 
            case 2: {
                trs.setCommandMember(jfsTrs.getCommandMember());
                trs.setISPFLogCompact(jfsTrs.isISPFLogCompact());
                trs.setISPFLogPublishType(jfsTrs.getISPFLogPublishType());
                trs.setISPFLogConsolidate(jfsTrs.getISPFLogConsolidate());
                break;
            }
            case 4: {
                trs.setCommandMember(jfsTrs.getCommandMember());
                trs.setDdNameList(jfsTrs.getDdnamelist());
                trs.setDefaultOptions(jfsTrs.getDefaultOptions());
                break;
            }
            case 0: {
                IDataSetDefinitionHandle dsdHandle;
                UUID jfsDSDid = jfsTrs.getDataDefinitionUuid();
                if (jfsDSDid != null && (dsdHandle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(jfsDSDid, null)) != null) {
                    trs.setDataSetDefinition(dsdHandle);
                }
                trs.setDefaultOptions(jfsTrs.getDefaultOptions());
                trs.setDdNameList(jfsTrs.getDdnamelist());
                trs.setLinkEdit(jfsTrs.isLinkEdit());
                break;
            }
            case 3: {
                trs.setAntSnippet(jfsTrs.getAntSnippet());
            }
        }
        trs.setMaxRC(jfsTrs.getMaxRC());
        List<String> jfsTypes = jfsTrs.getSpecialTypes();
        if (trs.getSpecialTypes() != null) {
            trs.getSpecialTypes().clear();
        }
        if (jfsTypes != null && jfsTypes.size() > 0) {
            List<IStringHelper> emfTypes = trs.getSpecialTypes();
            for (String jfsType : jfsTypes) {
                if (jfsType == null || jfsType.trim().isEmpty()) continue;
                StringHelper sh = ModelFactory.eINSTANCE.createStringHelper();
                sh.setValue(jfsType);
                emfTypes.add(sh);
            }
        }
        List<IConcatenation> jfsConcatenations = jfsTrs.getConcatenations();
        if (trs.getConcatenations() != null) {
            trs.getConcatenations().clear();
        }
        if (jfsConcatenations != null && jfsConcatenations.size() > 0) {
            List<com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation> emfConcatenations = trs.getConcatenations();
            for (IConcatenation jfsConcatenation : jfsConcatenations) {
                com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation emfConcatenation = this.mapConcatenation(jfsConcatenation);
                if (emfConcatenation == null) continue;
                emfConcatenations.add(emfConcatenation);
            }
        }
        List<IDDAllocation> jfsAllocations = jfsTrs.getDDAllocations();
        if (trs.getDDAllocations() != null) {
            trs.getDDAllocations().clear();
        }
        if (jfsAllocations != null && jfsAllocations.size() > 0) {
            List<com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation> emfAllocations = trs.getDDAllocations();
            for (IDDAllocation jfsAllocation : jfsAllocations) {
                com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation emfAllocation = this.mapDDAllocation(jfsAllocation);
                if (emfAllocation == null) continue;
                emfAllocations.add(emfAllocation);
            }
        }
        List<IHFSOutput> jfsHFSOutputs = jfsTrs.getHFSOutputs();
        if (trs.getHFSOutputs() != null) {
            trs.getHFSOutputs().clear();
        }
        if (jfsHFSOutputs != null && jfsHFSOutputs.size() > 0) {
            List<com.ibm.team.enterprise.systemdefinition.common.model.IHFSOutput> emfHFSOutputs = trs.getHFSOutputs();
            for (IHFSOutput jfsHFSOutput : jfsHFSOutputs) {
                com.ibm.team.enterprise.systemdefinition.common.model.IHFSOutput emfHFSOutput = this.mapHFSOutput(jfsHFSOutput);
                if (emfHFSOutput == null) continue;
                emfHFSOutputs.add(emfHFSOutput);
            }
        }
    }

    private com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation mapConcatenation(IConcatenation jfsConcatenation) throws TeamRepositoryException {
        Concatenation emfConcatenation = null;
        if (jfsConcatenation != null) {
            emfConcatenation = ModelFactory.eINSTANCE.createConcatenation();
            emfConcatenation.setName(jfsConcatenation.getName());
            emfConcatenation.setCondition(jfsConcatenation.getCondition());
            List<IDataDefinitionEntry> jfsEntries = jfsConcatenation.getDataDefinitionEntries();
            List<com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry> emfEntries = emfConcatenation.getDataDefinitionEntries();
            if (emfEntries != null) {
                emfEntries.clear();
            }
            if (jfsEntries != null && jfsEntries.size() > 0) {
                for (IDataDefinitionEntry jfsEntry : jfsEntries) {
                    DataDefinitionEntry emfEntry = ModelFactory.eINSTANCE.createDataDefinitionEntry();
                    emfEntry.setKind(jfsEntry.getKind());
                    emfEntry.setMember(jfsEntry.isMember());
                    String jfsDSDid = jfsEntry.getValue();
                    if (jfsDSDid != null) {
                        UUID jfsDSuuid;
                        try {
                            jfsDSuuid = UUID.valueOf((String)jfsDSDid);
                        }
                        catch (IllegalArgumentException e) {
                            jfsDSuuid = null;
                        }
                        if (jfsDSuuid == null) {
                            emfEntry.setValue(jfsDSDid);
                        } else {
                            IDataSetDefinitionHandle dsdHandle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(jfsDSuuid, null);
                            if (dsdHandle != null) {
                                emfEntry.setValue(dsdHandle.getItemId().getUuidValue());
                            } else {
                                logger.error((Object)NLS.bind((String)"Could not set value for {0} in concatenation {1}", (Object)jfsDSDid, (Object)emfConcatenation.getName()));
                            }
                        }
                    }
                    emfEntries.add(emfEntry);
                }
            }
        }
        return emfConcatenation;
    }

    private com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation mapDDAllocation(IDDAllocation jfsAllocation) throws TeamRepositoryException {
        DDAllocation emfAllocation = null;
        if (jfsAllocation != null) {
            ITranslator.OutputNameKind jfsOnk;
            emfAllocation = ModelFactory.eINSTANCE.createDDAllocation();
            emfAllocation.setName(jfsAllocation.getName());
            emfAllocation.setMember(jfsAllocation.isMember());
            emfAllocation.setKeep(jfsAllocation.isKeep());
            emfAllocation.setMod(jfsAllocation.isMod());
            emfAllocation.setOutput(jfsAllocation.isOutput());
            emfAllocation.setPublish(jfsAllocation.isPublish());
            emfAllocation.setOutputName(jfsAllocation.getOutputName());
            emfAllocation.setInstream(jfsAllocation.getInstream());
            emfAllocation.setCondition(jfsAllocation.getCondition());
            emfAllocation.setSequential(jfsAllocation.isSequential());
            emfAllocation.setDeployType(jfsAllocation.getDeployType());
            emfAllocation.setUsedAsInput(jfsAllocation.isUsedAsInput());
            emfAllocation.setPublishType(jfsAllocation.getPublishType());
            emfAllocation.setConsolidateLog(jfsAllocation.getConsolidateLog());
            emfAllocation.setCompact(jfsAllocation.getCompact());
            IDataDefinitionEntry jfsEntry = jfsAllocation.getDataDefinitionEntry();
            if (jfsEntry != null) {
                UUID jfsDSuuid;
                DataDefinitionEntry emfEntry = ModelFactory.eINSTANCE.createDataDefinitionEntry();
                emfEntry.setKind(jfsEntry.getKind());
                emfEntry.setMember(jfsEntry.isMember());
                String jfsDSDid = jfsAllocation.getDataDefinitionEntry().getValue();
                try {
                    jfsDSuuid = UUID.valueOf((String)jfsDSDid);
                }
                catch (IllegalArgumentException e) {
                    jfsDSuuid = null;
                }
                if (jfsDSuuid == null) {
                    emfEntry.setValue(jfsDSDid);
                } else {
                    IDataSetDefinitionHandle dsdHandle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(jfsDSuuid, null);
                    if (dsdHandle != null) {
                        emfEntry.setValue(dsdHandle.getItemId().getUuidValue());
                    } else {
                        logger.error((Object)NLS.bind((String)"Could not set value for {0} in allocation {1}", (Object)jfsDSDid, (Object)emfAllocation.getName()));
                    }
                }
                emfAllocation.setDataDefinitionEntry(emfEntry);
            }
            if ((jfsOnk = jfsAllocation.getOutputNameKind()) != null) {
                OutputNameKind emfOnk = null;
                if (jfsOnk == ITranslator.OutputNameKind.SAME_AS_INPUT) {
                    emfOnk = OutputNameKind.SAME_AS_INPUT_LITERAL;
                } else if (jfsOnk == ITranslator.OutputNameKind.USE_PATTERN) {
                    emfOnk = OutputNameKind.USE_PATTERN_LITERAL;
                } else if (jfsOnk == ITranslator.OutputNameKind.USE_VARIABLE) {
                    emfOnk = OutputNameKind.USE_VARIABLE_LITERAL;
                }
                emfAllocation.setOutputNameKind(emfOnk);
            }
        }
        return emfAllocation;
    }

    private com.ibm.team.enterprise.systemdefinition.common.model.IHFSOutput mapHFSOutput(IHFSOutput jfsHFSOutput) {
        HFSOutput emfHFSOutput = null;
        if (jfsHFSOutput != null) {
            emfHFSOutput = ModelFactory.eINSTANCE.createHFSOutput();
            emfHFSOutput.setCondition(jfsHFSOutput.getCondition());
            emfHFSOutput.setDeployType(jfsHFSOutput.getDeployType());
            emfHFSOutput.setPath(jfsHFSOutput.getPath());
        }
        return emfHFSOutput;
    }
}

